#delimit;


/****************************************************/
/* parental income */
/****************************************************/

/* cleaning adapted from Micklewright "A Note on Household Income Data in NCDS3 (1986)*/

tempvar YESCASH;  /* define whether father |& mother |& other income are missing */
qui ge `YESCASH'=1 if (n2462!=. | n2465!=.) & (n2463!=. | n2466!=.) &  (n2464!=. | n2467!=.);
qui replace `YESCASH'=2 if (n2462!=. | n2465!=.) & (n2463!=. | n2466!=.) &  (n2464==. & n2467==.);
qui replace `YESCASH'=3 if (n2462!=. | n2465!=.) & (n2463==. & n2466==.) &  (n2464!=. | n2467!=.);
qui replace `YESCASH'=4 if (n2462!=. | n2465!=.) & (n2463==. & n2466==.) &  (n2464==. & n2467==.);
qui replace `YESCASH'=5 if (n2462==. & n2465==.) & (n2463!=. | n2466!=.) &  (n2464!=. | n2467!=.);
qui replace `YESCASH'=6 if (n2462==. & n2465==.) & (n2463!=. | n2466!=.) &  (n2464==. & n2467==.);
qui replace `YESCASH'=7 if (n2462==. & n2465==.) & (n2463==. & n2466==.) &  (n2464!=. | n2467!=.);
qui replace `YESCASH'=8 if (n2462==. & n2465==.) & (n2463==. & n2466==.) &  (n2464==. & n2467==.);

tempvar sele;
ge `sele'=1;
replace `sele'=0 if n2350==.; /* missing in 1974 parental questionnaire */
replace `sele'=0 if n2468!=.; /* coded as non respondant */
replace `sele'=0 if n2468==. & n2371!=10 & n2371!=. & n2392==1 &
(`YESCASH'== 3 | `YESCASH'== 4 | `YESCASH'== 7 | `YESCASH'== 8);  /* mother present and working but missing income */
replace `sele'=0 if n2468==. & n2375!=10 & n2375!=. & n2383==6 & (`YESCASH'>= 5 & `YESCASH' <= 8);
/* father present and employed but missing income */


/* father net pay */

cap drop YF_F;
ge YF_F= .;
label var YF_F "father net income";

tempvar temp;
ge `temp'=0;

tempvar t2462; ge `t2462'=n2462 if `sele'==1;

foreach var of varlist `t2462' {;
qui replace `temp'=`var';

qui replace `var'=(0+4)/2   if `temp'==1 & `sele'==1;
qui replace `var'=(5+9)/2   if `temp'==2 & `sele'==1;
qui replace `var'=(10+14)/2 if `temp'==3 & `sele'==1;
qui replace `var'=(15+19)/2 if `temp'==4 & `sele'==1;
qui replace `var'=(20+24)/2 if `temp'==5 & `sele'==1;
qui replace `var'=(25+29)/2 if `temp'==6 & `sele'==1;
qui replace `var'=(30+34)/2 if `temp'==7 & `sele'==1;
qui replace `var'=(35+39)/2 if `temp'==8 & `sele'==1;
qui replace `var'=(40+44)/2 if `temp'==9 & `sele'==1;
qui replace `var'=(45+49)/2 if `temp'==10 & `sele'==1;
qui replace `var'=(50+59)/2 if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

tempvar t2465; ge `t2465'=n2465 if `sele'==1;

foreach var of varlist `t2465' {;
qui replace `temp'=`var';

qui replace `var'=2         if `temp'==1 & `sele'==1;
qui replace `var'=7         if `temp'==2 & `sele'==1;
qui replace `var'=12        if `temp'==3 & `sele'==1;
qui replace `var'=17        if `temp'==4 & `sele'==1;
qui replace `var'=22        if `temp'==5 & `sele'==1;
qui replace `var'=27        if `temp'==6 & `sele'==1;
qui replace `var'=32        if `temp'==7 & `sele'==1;
qui replace `var'=37        if `temp'==8 & `sele'==1;
qui replace `var'=42        if `temp'==9 & `sele'==1;
qui replace `var'=47        if `temp'==10 & `sele'==1;
qui replace `var'=54.5      if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

qui replace YF_F= `t2462';
qui replace YF_F= `t2465' if YF_F==.;
qui replace YF_F=0 if YF_F==. & `sele'==1;

tab YF_F;

/* mother net pay */

cap drop YM_F;
ge YM_F= .;
label var YM_F "mother net income";

tempvar temp;
ge `temp'=0;

tempvar t2463; ge `t2463'=n2463 if `sele'==1;

foreach var of varlist `t2463' {;
qui replace `temp'=`var';

qui replace `var'=(0+4)/2   if `temp'==1 & `sele'==1;
qui replace `var'=(5+9)/2   if `temp'==2 & `sele'==1;
qui replace `var'=(10+14)/2 if `temp'==3 & `sele'==1;
qui replace `var'=(15+19)/2 if `temp'==4 & `sele'==1;
qui replace `var'=(20+24)/2 if `temp'==5 & `sele'==1;
qui replace `var'=(25+29)/2 if `temp'==6 & `sele'==1;
qui replace `var'=(30+34)/2 if `temp'==7 & `sele'==1;
qui replace `var'=(35+39)/2 if `temp'==8 & `sele'==1;
qui replace `var'=(40+44)/2 if `temp'==9 & `sele'==1;
qui replace `var'=(45+49)/2 if `temp'==10 & `sele'==1;
qui replace `var'=(50+59)/2 if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

tempvar t2466; ge `t2466'=n2466 if `sele'==1;

foreach var of varlist `t2466' {;
qui replace `temp'=`var';

qui replace `var'=2         if `temp'==1 & `sele'==1;
qui replace `var'=7         if `temp'==2 & `sele'==1;
qui replace `var'=12        if `temp'==3 & `sele'==1;
qui replace `var'=17        if `temp'==4 & `sele'==1;
qui replace `var'=22        if `temp'==5 & `sele'==1;
qui replace `var'=27        if `temp'==6 & `sele'==1;
qui replace `var'=32        if `temp'==7 & `sele'==1;
qui replace `var'=37        if `temp'==8 & `sele'==1;
qui replace `var'=42        if `temp'==9 & `sele'==1;
qui replace `var'=47        if `temp'==10 & `sele'==1;
qui replace `var'=54.5      if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

qui replace YM_F= `t2463';
qui replace YM_F= `t2466' if YM_F==.;
qui replace YM_F=0 if YM_F==. & `sele'==1;

tab YM_F;

/* other */

cap drop YO_F;
ge YO_F= .;
label var YO_F "other income";

tempvar temp;
ge `temp'=0;

tempvar t2464; ge `t2464'=n2464 if `sele'==1;

foreach var of varlist `t2464' {;
qui replace `temp'=`var';

qui replace `var'=(0+4)/2   if `temp'==1 & `sele'==1;
qui replace `var'=(5+9)/2   if `temp'==2 & `sele'==1;
qui replace `var'=(10+14)/2 if `temp'==3 & `sele'==1;
qui replace `var'=(15+19)/2 if `temp'==4 & `sele'==1;
qui replace `var'=(20+24)/2 if `temp'==5 & `sele'==1;
qui replace `var'=(25+29)/2 if `temp'==6 & `sele'==1;
qui replace `var'=(30+34)/2 if `temp'==7 & `sele'==1;
qui replace `var'=(35+39)/2 if `temp'==8 & `sele'==1;
qui replace `var'=(40+44)/2 if `temp'==9 & `sele'==1;
qui replace `var'=(45+49)/2 if `temp'==10 & `sele'==1;
qui replace `var'=(50+59)/2 if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

tempvar t2467; ge `t2467'=n2467 if `sele'==1;

foreach var of varlist `t2467' {;
qui replace `temp'=`var';

qui replace `var'=2         if `temp'==1 & `sele'==1;
qui replace `var'=7         if `temp'==2 & `sele'==1;
qui replace `var'=12        if `temp'==3 & `sele'==1;
qui replace `var'=17        if `temp'==4 & `sele'==1;
qui replace `var'=22        if `temp'==5 & `sele'==1;
qui replace `var'=27        if `temp'==6 & `sele'==1;
qui replace `var'=32        if `temp'==7 & `sele'==1;
qui replace `var'=37        if `temp'==8 & `sele'==1;
qui replace `var'=42        if `temp'==9 & `sele'==1;
qui replace `var'=47        if `temp'==10 & `sele'==1;
qui replace `var'=54.5      if `temp'==11 & `sele'==1;
qui replace `var'=72.5      if `temp'==12 & `sele'==1;

};

qui replace YO_F= `t2464';
qui replace YO_F= `t2467' if YO_F==.;
qui replace YO_F=0 if YO_F==. & `sele'==1;

tab YO_F;

/* total income */

cap drop YT_F;
ge YT_F= .;
label var YT_F "parental total income";
replace YT_F= YF_F + YM_F + YO_F if `sele'==1;
tab YT_F;

su YT_F;


/* annual income */
qui replace YF_F=YF_F*52;
qui replace YM_F=YM_F*52;
qui replace YO_F=YO_F*52;
qui replace YT_F=YT_F*52;

/* deflate to January 2001 prices */

cap drop rpiyr; qui ge rpiyr=n2358+1900; /* deflate to Jan 2001 prices */
qui su n2358, detail; qui replace rpiyr=`r(p50)'+1900 if inrange(n2358,74,75)!=1;
cap drop rpimth; qui ge rpimth=n2356;
qui su n2356, detail; qui replace rpimth=`r(p50)' if inrange(n2356,1,12)!=1;

cap drop *merge;
sort rpiyr rpimth;
merge rpiyr rpimth using price_ind.dta, keep(rpi) update replace;
keep if inlist(_merge,1,3);

qui replace YF_F=YF_F/rpi;
qui replace YM_F=YM_F/rpi;
qui replace YO_F=YO_F/rpi;
qui replace YT_F=YT_F/rpi;
cap drop rpi *merge;

su YT_F;
