#delimit;

/****************************************************/
/* wages */
/****************************************************/

/* age 23 */

cap drop hrw4;
ge hrw4=.;

qui replace hrw4=n4269*5/n4331         if n4274==1 & n4331 <=96; /* daily to weekly to hourly */
qui replace hrw4=n4269/n4331           if n4274==2 & n4331 <=96; /* weekly to hourly */
qui replace hrw4=n4269/2/n4331         if n4274==3 & n4331 <=96; /* bi-weekly to hourly */
qui replace hrw4=n4269/4.333333/n4331  if n4274==4 & n4331 <=96; /* monthly to weekly to hourly */
qui replace hrw4=n4269/(52/4)/n4331    if n4274==5 & n4331 <=96; /* tri-monthly to weekly to hourly */
qui replace hrw4=n4269/(52/2)/n4331    if n4274==6 & n4331 <=96; /* 6 months to weekly to hourly */
qui replace hrw4=n4269/52/n4331        if n4274==7 & n4331 <=96; /* yearly to weekly to hourly */


qui sum n4331 if econ4B==2, detail; /* median number of weekly hours if working full-time */
qui replace hrw4=hrw4*`r(p50)'*52; /* yearly income */

cap drop rpiyr; qui ge rpiyr=1981; /* deflate to Jan 2001 prices */
cap drop rpimth; qui ge rpimth=n4124;
qui su n4124, detail; qui replace rpimth=`r(p50)' if inrange(n4124,1,12)!=1;

cap drop *merge;
sort rpiyr rpimth;
merge rpiyr rpimth using price_ind.dta, keep(rpi) update replace;
keep if inlist(_merge,1,3);

qui replace hrw4=hrw4/rpi;
cap drop rpi *merge;


label variable hrw4 "age 23 hourly gross pay";

/* age 33 - gross hourly wage */

cap drop hrw5;
ge hrw5=.;

qui replace hrw5=n500543/n500550           if n500549==1 & n500550 <=96; /* weekly to hourly */
qui replace hrw5=n500543/2/n500550         if n500549==2 & n500550 <=96; /* bi-weekly to hourly */
qui replace hrw5=n500543/4/n500550         if n500549==3 & n500550 <=96; /* four weeks to hourly */
qui replace hrw5=n500543/4.333333/n500550  if n500549==4 & n500550 <=96; /* monthly to weekly to hourly */
qui replace hrw5=n500543/52/n500550        if n500549==5 & n500550 <=96; /* yearly to weekly to hourly */

/* replace hrw5=ghlwage if ghlwage!=.; */

qui sum n500550 if econ5==1, detail; /* median number of weekly hours if working full-time */
qui replace hrw5=hrw5*`r(p50)'*52; /* yearly income */

cap drop rpiyr; qui ge rpiyr=1991; /* deflate to Jan 2001 prices */
cap drop rpimth; qui ge rpimth=n504740;
qui su n504740, detail; qui replace rpimth=`r(p50)' if inrange(n504740,1,12)!=1;

cap drop *merge;
sort rpiyr rpimth;
merge rpiyr rpimth using price_ind.dta, keep(rpi) update replace;
keep if inlist(_merge,1,3);

qui replace hrw5=hrw5/rpi;
cap drop rpi *merge;

label variable hrw5 "age 33 hourly gross pay";

/* age 33 - yearly net wage */

cap drop ynw5;
ge ynw5=.;

qui replace ynw5=n500536*52			if n500542==1; 	/* weekly to yearly */
qui replace ynw5=n500536*26			if n500542==2;	/* fortnightly to yearly */
qui replace ynw5=n500536*13			if n500542==3;	/* 4 weeks to yearly */
qui replace ynw5=n500536*12 		if n500542==4;	/* monthly to yearly */
qui replace ynw5=n500536 			if n500542==5;	/* yearly */

cap drop rpiyr; qui ge rpiyr=1991; /* deflate to Jan 2001 prices */
cap drop rpimth; qui ge rpimth=n504740;
qui su n504740, detail; qui replace rpimth=`r(p50)' if inrange(n504740,1,12)!=1;

cap drop *merge;
sort rpiyr rpimth;
merge rpiyr rpimth using price_ind.dta, keep(rpi) update replace;
keep if inlist(_merge,1,3);

qui replace ynw5=ynw5/rpi;
cap drop rpi *merge;

label variable ynw5 "age 33 yearly net pay";

/* age 41 */

cap drop hrw6;
ge hrw6=.;

cap drop hours_wk; gen hours_wk=999;
replace hours_wk  =          (chours1)                  if chours1<99 & otimeany==2;
replace chours2   =          0                          if chours2==999|chours2==.;
replace chours3   =          0                          if chours3>997|chours2==.;
replace chours4   =          0                          if chours4>997|chours2==.;
replace hours_wk  =          chours2+chours3+chours4    if otimeany==1;

replace hours_wk  =. if  otimeany==. & chours1==. & chours2==0 & chours3==0 & chours4==0;
replace hours_wk  =. if  chours1==99 & otimeany==2;
replace hours_wk  =. if otimeany==8|otimeany==9;
replace hours_wk  =. if hours_wk==0;
replace hours_wk  =. if (chours1==0|chours1==.) & chours2==0 & chours3==0;

qui replace hrw6=cgropay/hours_wk           if cgroprd==1 & hours_wk <=96; /* weekly to hourly */
qui replace hrw6=cgropay/2/hours_wk         if cgroprd==2 & hours_wk <=96; /* bi-weekly to hourly */
qui replace hrw6=cgropay/4/hours_wk         if cgroprd==3 & hours_wk <=96; /* four weeks to hourly */
qui replace hrw6=cgropay/4.333333/hours_wk  if cgroprd==4 & hours_wk <=96; /* monthly to weekly to hourly */
qui replace hrw6=cgropay/52/hours_wk        if cgroprd==5 & hours_wk <=96; /* yearly to weekly to hourly */

/* replace hrw6=hr_gro if hr_gro!=.; */

qui sum hours_wk if econ6==1, detail; /* median number of weekly hours if working full-time */
qui replace hrw6=hrw6*`r(p50)'*52; /* yearly income */

qui replace hrw6=hrw6/rpi_int; /* rpi already in the data */

label variable hrw6 "age 41 hourly gross pay";

/* outliers */

foreach var of varlist hrw* ynw*{;  /* clean from outliers */
    _pctile `var', p(2 , 98);
    replace `var'=. if `var'  <r(r1) | `var'>r(r2);
};

su hrw*;
su ynw*;
