/*  This file check the number of breaks in the job history of NCDS
    cohort members. A break is defined as a `k1' months non-education
    period followed by a 3 months (or longer) education spell (act`j'==7). */

#delimit;
* use vector456.dta,replace;         

keep if act15==7;                               

local k1=6;
local j=16;                                                             
tempvar br; ge `br'=0;
tempvar tt; ge `tt'=0;
tempvar ss; ge `ss'=0;

while `j' <100 {;  /* April 1981 */      
local l1=`j'+1; /* 1 month past j */
local l2=`j'+2; /* 2 months past j */

di " loop " `j';

qui replace `br'=`br'+1 if act`j'==7 & `tt'>=`k1' & (act`l1'==7 & act`l2'==7); 
qui replace `tt'=`tt'+1 if act`j'!=7 & act`j'!=-99;
qui replace `tt'=0 if act`j'==7;

local j=`j'+1;
};        
          
bysort sex: tab `br';   
cap drop br;
ge br=`br';
