*NCDS 99

#delimit;


/* -------------------------- EDUCATIONAL CATEGORIES ---------------------------- */

    /*   99 survey "00" variables. specific qualification
        as derived by Andrew Jenkins + information from ncds 91 (if they took part
        in the 1991 survey, then in 1999 they reported their qualification only from 
        1991 onwards.  */
        
tokenize 6 A6 V6;
while ("`1'"~=""){; 
    cap drop quNO`1'; ge quNO`1'=0;         
    cap drop quOL`1'; ge quOL`1'=0;
    cap drop quAL`1'; ge quAL`1'=0;
    cap drop quHE`1'; ge quHE`1'=0;    
    
    macro shift;
};        

/* ~~~~~~~~~~ NO QUAL ~~~~~~~~~ */

foreach var of varlist n501513-n501541 n501441-n501469 {;    

qui replace quNO6=1 if `var'==1; /* cselo            */

qui replace quNO6=1 if `var'==37; /* no qual          */
qui replace quNO6=1 if `var'==34 | `var'==35  | `var'==36 ; /* other            */
qui replace quNO6=1 if `var'==25; /* hgv              */
qui replace quNO6=1 if `var'==10; /* rsa1             */
   
};     

replace quNO6=1   if cselo00  ==1         /* CSE low levels                   */  ;
replace quNO6=1   if scotlo00 ==1         /* Scot standard lower grades       */  ;
replace quNO6=1   if scot600  ==1         /* Scot other                       */  ;
replace quNO6=1   if gcselo00 ==1         /* GCSE grades D-E                  */  ;

replace quNO6=1   if nvq100   ==1         /* NVQ1                             */  ;
replace quNO6=1   if nvq800   ==1         /* NVQ other                        */  ;
replace quNO6=1   if rsa100   ==1         /* RSA certificate                  */  ;
replace quNO6=1   if rsa500   ==1         /* RSA other                        */  ;
replace quNO6=1   if pit100   ==1         /* Pitmans elementary               */  ;
replace quNO6=1   if pit400   ==1         /* Pitmans  other                   */  ;
replace quNO6=1   if gnvq100  ==1         /* GNVQ foundation                  */  ;
replace quNO6=1   if gnvq400  ==1         /* GNVQ  other                      */  ;
replace quNO6=1   if hgv00    ==1         /* HGV qualification                */  ;
replace quNO6=1   if othvoc00 ==1         /* other vocational                 */  ;
replace quNO6=1   if hinvq00  ==0         /* no Aca or Voc qualification      */  ;
replace quNO6=1   if hinvq00  ==1         /* low  Aca or Voc qualification    */  ;

qui recode quNOA6 quNOV6 (0=1) if quNO6==1;  

    /* ~~~~~~~~~~ O LEVEL ~~~~~~~~~ */


foreach var of varlist n501513-n501541 n501441-n501469 {;    

qui replace quOLA6=1 if `var'==3; /* olev             */
qui replace quOLA6=1 if `var'==6; /* scotolev         */
qui replace quOLA6=1 if `var'==7; /* scotstand        */
qui replace quOLA6=1 if `var'==2; /* csehi            */
qui replace quOLA6=1 if `var'==4; /* gcsehi           */

qui replace quOLV6=1 if `var'==11; /* rsa2             */
qui replace quOLV6=1 if `var'==20; /* jib              */
qui replace quOLV6=1 if `var'==14; /* cgpart1          */
qui replace quOLV6=1 if `var'==17; /* cgother          */
qui replace quOLV6=1 if `var'==18; /* cg can't say     */
qui replace quOLV6=1 if `var'==19; /* cgia             */
qui replace quOLV6=1 if `var'==13; /* cgop             */

};

replace quOLA6=1   if gcsehi00 ==1         /* GCSE grades A-C                  */  ;
replace quOLA6=1   if olevlo00 ==1         /* O Levels grades D-E              */  ;
replace quOLA6=1   if olevhi00 ==1         /* O Levels grades A-C              */  ;
replace quOLA6=1   if csehi00  ==1         /* CSE 1                            */  ;
replace quOLA6=1   if scot200  ==1         /* SCOT standard 1-3                */  ;
replace quOLA6=1   if scot300  ==1         /* SCOT O levels                    */  ;

replace quOLV6=1   if btec100  ==1         /* BTEC First Certifcate            */  ;
replace quOLV6=1   if btec200  ==1         /* BTEC First Diploma               */  ;
replace quOLV6=1   if btec500  ==1         /* BTEC other                       */  ;
replace quOLV6=1   if city100  ==1         /* City and Guilds Part 1           */  ;
replace quOLV6=1   if city200  ==1         /* City and Guilds part 2           */  ;
replace quOLV6=1   if city500  ==1         /* City and Guilds other            */  ;
replace quOLV6=1   if rsa200   ==1         /* RSA First Diploma                */  ;
replace quOLV6=1   if pit200   ==1         /* Pitmans level 2                  */  ;
replace quOLV6=1   if nvq200   ==1         /* NVQ level 2                      */  ;
replace quOLV6=1   if gnvq200  ==1         /* GNVQ intermidiate                */  ;
replace quOLV6=1   if appren00 ==1         /* Trade Apprent                    */  ;

    /* ~~~~~~~~~~~~~ A LEVEL ~~~~~~~~~~~~~~~~~~ */

foreach var of varlist n501513-n501541 n501441-n501469 {;    

qui replace quALA6=1 if `var'==5; /* alev             */
qui replace quALA6=1 if `var'==8; /* scothigh         */
qui replace quALA6=1 if `var'==9; /* scot6th          */

qui replace quALV6=1 if `var'==12; /* rsa3             */
qui replace quALV6=1 if `var'==23; /* tec              */
qui replace quALV6=1 if `var'==15; /* cgpart23         */
qui replace quALV6=1 if `var'==16; /* cgft             */
qui replace quALV6=1 if `var'==21; /* onc              */

};

replace quALA6=1   if asllo00  ==1         /* A-S level at grade D to E        */  ;
replace quALA6=1   if aslhi00  ==1         /* A-S level at grade A to C        */  ;
replace quALA6=1   if alevlo00 ==1         /* A level at grade D-E             */  ;
replace quALA6=1   if alevhi00 ==1         /* A level at grade A-C             */  ;
replace quALA6=1   if alev00   ==1         /* A level at any grade             */  ;
replace quALA6=1   if scot400  ==1         /* SCOT higher                      */  ;
replace quALA6=1   if scot500  ==1         /* SCOT Certificate 6th year        */  ;

replace quALV6=1   if oncond00 ==1         /* ONC or OND                       */  ;
replace quALV6=1   if btec300  ==1         /* BTEC National Certifcate Diploma */  ;
replace quALV6=1   if city300  ==1         /* City and Guilds Part 3           */  ;
replace quALV6=1   if city400  ==1         /* City and Guilds Part 4           */  ;
replace quALV6=1   if rsa300   ==1         /* RSA Advanced Diploma             */  ;
replace quALV6=1   if pit300   ==1         /* Pitmans level 3                  */  ;
replace quALV6=1   if nvq300   ==1         /* NVQ level 3                      */  ;
replace quALV6=1   if gnvq300  ==1         /* GNVQ advanced                    */  ;

    /* ~~~~~~~~~~~~~ DEGREE ~~~~~~~~~~~~~~~~~~ */

foreach var of varlist n501513-n501541 n501441-n501469 {;    

qui replace quHEA6=1 if `var'==31; /* firstdeg         */
qui replace quHEA6=1 if `var'==29; /* poly             */
qui replace quHEA6=1 if `var'==30; /* he               */
qui replace quHEA6=1 if `var'==32; /* pgdiploma        */
qui replace quHEA6=1 if `var'==33; /* pgdeg            */
qui replace quHEA6=1 if `var'==28; /* nurs             */ 

qui replace quHEV6=1 if `var'==24; /* techi            */
qui replace quHEV6=1 if `var'==22; /* hnc              */
qui replace quHEV6=1 if `var'==26; /* proffull         */
qui replace quHEV6=1 if `var'==27; /* profpart         */

};

replace quHEA6=1   if deg00    ==1         /* degree                           */  ;
replace quHEA6=1   if odeg00   ==1         /* other degree                     */  ;
replace quHEA6=1   if hdeg00   ==1         /* higher degree                    */  ;
replace quHEA6=1   if altodeg  ==1         /* other degree 2                   */  ;

replace quHEA6=1   if dip00    ==1         /* Diploma, Cert, Teacher traing    */  ;
replace quHEA6=1   if nurse00  ==1         /* nurse or paramedic               */  ;
replace quHEA6=1   if pgce00   ==1         /* PGCE or other postgrad in HE     */  ;

replace quHEV6=1   if hnchnd00 ==1         /* HNC or HND                       */  ;
replace quHEV6=1   if btec400  ==1         /* BTEC Higher Certificate          */  ;
replace quHEV6=1   if rsa400   ==1         /* RSA Higher Diploma               */  ;
replace quHEV6=1   if nvq400   ==1         /* NVQ level 4                      */  ;
replace quHEV6=1   if nvq500   ==1         /* NVQ level 5                      */  ;
replace quHEV6=1   if nvq600   ==1         /* NVQ level 6                      */  ;


/************** give sequential structure *****************/

qui replace quOL6=1 if quOLA6==1 | quOLV6==1;
qui replace quAL6=1 if quALA6==1 | quALV6==1;
qui replace quHE6=1 if quHEA6==1 | quHEV6==1;

tokenize 6 A6 V6;
while ("`1'"~=""){;  
    qui replace quNO`1'=1 if quOL`1'==1 |   quAL`1'==1 |   quHE`1'==1;
    qui replace quOL`1'=1 if quAL`1'==1 |   quHE`1'==1;
    qui replace quAL`1'=1 if quHE`1'==1;
    
    cap drop educat`1'_F;
    qui ge     educat`1'_F=0 if quNO`1'==1;
    qui replace educat`1'_F=1 if quOL`1'==1;
    qui replace educat`1'_F=2 if quAL`1'==1;
    qui replace educat`1'_F=3 if quHE`1'==1;    
    
    macro shift;
};        
