* NCDS 81

#delimit;                                       
macro drop _all;

    /*  this do file defines the education categoires using the 81 variables.
        there are 3 kind of variables from 81:
        "n4465" "n4478" "n4523" contain info about training qulification (1st, 2nd, 3rd)
        "n4573" "n4622" "n4634" contain info about other courses (1st, 2nd, 3rd)
        "n4529" contain info about highest qualifcation obtained
        all of them refer to card C

        plus there are other qualifcation variables
        "n4439" "n4448" contain info about apprenticeship
        "n4655" "n4656" specific about O levels
        "n4657" "n4658" specific about A levels     */

global eduall = "n4465 n4478 n4523 n4529 n4573 n4622 n4634 n4448";

tokenize 4 A4 V4;
while ("`1'"~=""){;     
    cap drop quNO`1'; ge quNO`1'=0;
    cap drop quOL`1'; ge quOL`1'=0;
    cap drop quAL`1'; ge quAL`1'=0;
    cap drop quHE`1'; ge quHE`1'=0;    
    
    macro shift;
};

tempvar tn4465; ge `tn4465'=n4465; qui replace `tn4465'=. if n4464~=1 /* set qualification to missing if not yet completed    */  ;
tempvar tn4478; ge `tn4478'=n4478; qui replace `tn4478'=. if n4477~=1 /* training                                             */  ;
tempvar tn4523; ge `tn4523'=n4523; qui replace `tn4523'=. if n4522~=1                                                             ;
                                                       
tempvar tn4573; ge `tn4573'=n4573; qui replace `tn4573'=. if n4575~=1 /* other courses                                        */  ;
tempvar tn4622; ge `tn4622'=n4622; qui replace `tn4622'=. if n4624~=1                                                             ;
tempvar tn4634; ge `tn4634'=n4634; qui replace `tn4634'=. if n4636~=1                                                             ;
                                                       
tempvar tn4529; ge `tn4529'=n4529; qui replace `tn4529'=. if n4528~=1 /* education since school                               */  ;

global eduall = "`tn4465' `tn4478' `tn4523' `tn4529' `tn4573' `tn4622' `tn4634' n4448";    

    /* ~~~~~~~~~~ NO QUAL ~~~~~~~~~ */

qui replace quNO4=1   if  n4464==2|n4464==3       /* no training qualif or still in       */  ;
qui replace quNO4=1   if  n4477==2|n4477==3       /* no training qualif or still in       */  ;
qui replace quNO4=1   if  n4522==2|n4522==3       /* no training qualif or still in       */  ;
qui replace quNO4=1   if  n4575==2|n4575==8       /* no other courses qualif or still in  */  ;
qui replace quNO4=1   if  n4624==2|n4624==8       /* no other courses qualif or still in  */  ;
qui replace quNO4=1   if  n4636==2|n4636==8       /* no other courses qualif or still in  */  ;
qui replace quNO4=1   if  n4528==2|n4528==3       /* no qualif since school or still in   */  ;
qui replace quNO4=1   if  n4439==2|n4439==3       /* no apprenticeship or still in        */  ;

foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==88; /* none               */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==01; /* HGV, PSV           */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==02; /* other              */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==03; /* CSE any level      */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==11; /* RSA 1              */ };

foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==05; /* cert of ext edu    */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==09; /* scot leaving cert  */ };
foreach var of varlist $eduall  {;qui replace quNO4=1 if `var'==10; /* scot univ prel exam*/ };     

qui replace quNO4=1 if n4655~=. | n4657!=.;  /* check whether they responded in the survey (new!) */

qui recode quNOA4 quNOV4 (0=1) if quNO4==1;

    /* ~~~~~~~~~~ O LEVEL ~~~~~~~~~ */

qui replace quOLA4 =1 if n4656>=1 & n4656<=9        /* O Lev, CSE1, Scot O Lev              */  ;  
qui replace quOLA4 =1 if n4439==1                  /* apprenticeship                       */  ;   
 
foreach var of varlist $eduall  {;qui replace quOLA4 =1 if `var'==4; /* GCE O Lev          */ };
foreach var of varlist $eduall  {;qui replace quOLA4 =1 if `var'==7; /* SCE O Lev          */ }; 
                                                   
foreach var of varlist $eduall  {;qui replace quOLV4 =1 if `var'==12; /* RSA 2              */ };
foreach var of varlist $eduall  {;qui replace quOLV4 =1 if `var'==14; /* cgop               */ };
foreach var of varlist $eduall  {;qui replace quOLV4 =1 if `var'==15; /* cgpart1            */ };
foreach var of varlist $eduall  {;qui replace quOLV4 =1 if `var'==18; /* cgia               */ };
foreach var of varlist $eduall  {;qui replace quOLV4 =1 if `var'==19; /* jib                */ };
                  
    /* ~~~~~~~~~~~~~ A LEVEL ~~~~~~~~~~~~~~~~~~ */

qui replace quALA4 =1 if n4658>=1 & n4658<=9         /* A Lev, Scot Higher                   */  ;

foreach var of varlist $eduall  {;qui replace quALA4 =1 if `var'==6; /* GCE A Lev          */ };
foreach var of varlist $eduall  {;qui replace quALA4 =1 if `var'==8; /* SCE A Lev          */ };
                                                   
foreach var of varlist $eduall  {;qui replace quALV4 =1 if `var'==13; /* RSA 3              */ };
foreach var of varlist $eduall  {;qui replace quALV4 =1 if `var'==16; /* cgpart23           */ };
foreach var of varlist $eduall  {;qui replace quALV4 =1 if `var'==17; /* cgft               */ };
foreach var of varlist $eduall  {;qui replace quALV4 =1 if `var'==20; /* onc                */ };
foreach var of varlist $eduall  {;qui replace quALV4 =1 if `var'==22; /* tec                */ };

    /* ~~~~~~~~~~~~~ DEGREE ~~~~~~~~~~~~~~~~~~ */

foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==26; /* poly               */ };
foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==27; /* he                 */ };
foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==29; /* firstdeg           */ };
foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==30; /* pgdiploma          */ };
foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==31; /* pgdeg              */ };
foreach var of varlist $eduall  {;qui replace quHEA4 =1 if `var'==25; /* nurs               */ }; 
                                                   
foreach var of varlist $eduall  {;qui replace quHEV4 =1 if `var'==21; /* hnc                */ };
foreach var of varlist $eduall  {;qui replace quHEV4 =1 if `var'==23; /* techi              */ };
foreach var of varlist $eduall  {;qui replace quHEV4 =1 if `var'==24; /* prof               */ };

/************** give sequential structure *****************/     

qui replace quOL4=1 if quOLA4==1 | quOLV4==1;
qui replace quAL4=1 if quALA4==1 | quALV4==1;
qui replace quHE4=1 if quHEA4==1 | quHEV4==1;        

tokenize 4 A4 V4;
while ("`1'"~=""){;  
    qui replace quNO`1'=1 if quOL`1'==1 |   quAL`1'==1 |   quHE`1'==1;
    qui replace quOL`1'=1 if quAL`1'==1 |   quHE`1'==1;
    qui replace quAL`1'=1 if quHE`1'==1;
    
    cap drop educat`1'_F;
    qui ge     educat`1'_F=0 if quNO`1'==1;
    qui replace educat`1'_F=1 if quOL`1'==1;
    qui replace educat`1'_F=2 if quAL`1'==1;
    qui replace educat`1'_F=3 if quHE`1'==1;    
    
    macro shift;
};                                         
