/* this file selects variables of interest */

#delimit;
clear;


/*****************************************************/
/* age 0 */
/*****************************************************/

use child.dta,replace;
keep serial
/* sex */ n622
/* parents age */ n494 n553;
cap drop *merge;
sort serial;
save age0.dta,replace;

/*****************************************************/
/* age 7 */
/*****************************************************/

use child.dta,replace;
keep serial
/* father's SC */ n190
/* father's figure */ n104
/* mother's figure */ n103
/* ability */ n90 n92 n1840
/* school quality */ n4 /* also region */ n20 n22 n24 n46
/* parental interest */ n43 n44 n27 n28 n29 n41 n42
/* accommodation */ n199 n200 n201
/* region */ n623
/* mother work */ n197 n198
/* non-cognitive skills */ n432 n434 n436 n438 n440 n442 n444 n446 n448 n450 n452 n454 n455;
cap drop *merge;
sort serial;
save age7.dta,replace;

/*****************************************************/
/* age 11 */
/*****************************************************/

use child.dta,replace;
keep serial
/* father's SC */ n1171
/* father's figure */ n1127
/* mother's figure */ n1122
/* ability */ n920 n923 n926 n929 n1008
/* school quality */ n801 n802 n824 n825 n829 n832 n835 n865
/* parental interest */ n851 n852 n849 n850
/* accommodation */ n1151 n1152 n1156
/* region */ n1102
/* mother work */ n1212
/* financial difficulties */ n1230
/* non-cognitive skills */ n974 n977 n980 n983 n986 n989 n992 n995 n998 n1001 n1004 n1005 n1008;
cap drop *merge;
sort serial;
save age11.dta,replace;

/*****************************************************/
/* age 16 */
/*****************************************************/

use child.dta,replace;
keep serial
/* father's SC */ n2384
/* mother's SC */ n2393
/* father's figure */ n2375
/* mother's figure */ n2371
/* ability */ n2928 n2930 n2925 n2927 n2923
/* parental education */ n2396 n2397
/* parental income */ n2462 n2463 n2464 n2465 n2466 n2467 n2468 n2322 n2323
/* parental occupation */ n2392 n2383
/* school quality */ n2092 n2093 n2102 n2103 n2104 n2141 n2144 n2196 n2203
/* parental interest */ n2324 n2325 n2158 n2159 n2160 n2161
/* parental interview */ n2356 n2358
/* siblings */ n2367 n2368 n2369 n2370
/* accommodation */ n2470 n2471 n2476
/* region */ n2350
/* mother work */ n2392
/* log permanent parental income */ p_faminc
/* financial difficulties */ n2441;
cap drop *merge;
sort serial;
save age16.dta,replace;

/*****************************************************/
/* age 23 */
/*****************************************************/

use ncds4.dta, replace;
keep serial
/* month of interview */ n4124
/* current job pay */ n4239 n4269 n4274 n4331 n4260
/* last job pay */ n4348 n4371 n4376 n4221 n4363
/*  job dates */ n4150 n4152 n4159 n4161 n4168 n4170 n4177 n4179
/* education finance */ n4529-n4533 n4544-n4555
/* education failed course */ n4638 n4646 n4648 n4649
/* partner */ n5113 n5116 n5119 n5123 n5136 n5150 n5132 n5152 n5156 n5158 n5160 n5162 n5164 n6166
/* benefits */ n5513-n5548
/* other payments */ n5549-n5577
/* savings */ n5613-n5728
/* social class */ n6132 n6149
/* education */ n4439 n4448 n4464 n4465 n4477 n4478 n4522 n4523 n4528 n4529 n4572 n4573 n4575 n4621 n4622 n4624
                n4633 n4634 n4636 n4655 n4656 n4657 n4658;
cap drop *merge;
sort serial;
save age23.dta,replace;

use dervars4.dta, replace;
keep serial
/* employment status */ econstat empstat;
rename empstat empstat4;
rename econstat econstat4;
cap drop *merge;
sort serial;
save age23_2.dta,replace;

/*****************************************************/
/* age 33 */
/*****************************************************/

use ncds5.dta, replace;
keep serial
/* month of interview */ n504740
/* current job pay */ n500520 n500527 n500543 n500549 n500550 n500536 n500542 ghlwage
/* last job pay */ n500560 n500566 n500567
/* social class */ n530033 n530133 n530233 n530333 n530433 n530533 n530633 n530733 n530833 n530933 n531033 n531133 n530056
                   n540033
/* job dates */ n507415-n507654
/* education */ n501513-n501541 n501441-n501469
/* ethnic group */ n504654;

cap drop *merge;
sort serial;
save age33.dta,replace;

/*************************************************/
/* age 41 */
/*************************************************/

use ncds&bcs70v1_7,replace;
keep if sample==2;
rename nserial serial;
keep serial
/* interview date */ intdate
/* social class */ sc*;
cap drop *merge;
sort serial;
save age41_1.dta,replace;


use ncds&bcs70v1_6,replace;
rename nserial serial;
keep if sample==2;
keep serial
/* education age left full-time edu */ agelfte2 actagel2 lftmore2
/* education academic */ edquals2
/* education gcse */ edgcse1 edgcse2 gceyrq
/* education Olev */ edolev1 edolev2 olvlyrq
/* education cse */ edcse1 edcse2 cseyrq
/* education Alev */ numaslvl edyear46 edyear47 edyear48 edyear49 edyear50 edyear51 edyear52 edyear53 edyear54 edyear55
/* education gcse Alev */ numgcsas edyear56 edyear57 edyear58 edyear59 edyear60 edyear61 edyear62 edyear63 edyear64 edyear55
/* education scots */ edscot1 edscot2 edscot3 edscot4 edscot5 edscot6 edscotya edscotyb edscotyc edscotyd edscotye edscotyf
/* education diploma HE */ eddiped eddipwhn
/* education degree */ numdeg edqwhe66 edqwhe67 edqwhe68 edqwhe69 edqwhe70
/* education other degree */ numothdg edqwhe72 edqwhe73 edqwhe74 edqwhe75 edqwhe76 edqwhe77 edqwhe78 edqwhe79 edqwhe80
/* education higher degree */ numhghdg edyear81 edyear82 edyear83 edyear84 edyear85
/* education vocational */ vocqual
/* education btec */ bteclev bteclev2 bteclev3 bteclev4 bteclev5 bteclev6 bteclev7 bteclev8 bteclev9 btecle10 btecle11
btecle12 btecle13 btecle14 btecle15
vocyear vocyear2 vocyear3 vocyear4 vocyear5 vocyear6 vocyear7 vocyear8 vocyear9 vocyea10 vocyea11 vocyea12 vocyea13
vocyea14 vocyea15
/* education c&g */ citylev citylev2 citylev3 citylev4 citylev5 citylev6 citylev7 citylev8 citylev9
cityle10 cityle11 cityle12 cityle13 cityle14 cityle15
vocyea16 vocyea17 vocyea18 vocyea19 vocyea20 vocyea21 vocyea22 vocyea23 vocyea24 vocyea25 vocyea26 vocyea27 vocyea28
vocyea29 vocyea30
/* education rsa */ rsalev rsalev2 rsalev3 rsalev4 rsalev5 rsalev6 rsalev7 rsalev8 rsalev9 rsalev10 rsalev11 rsalev12
vocyea31 vocyea32 vocyea33 vocyea34 vocyea35 vocyea36 vocyea37 vocyea38 vocyea39 vocyea40 vocyea41 vocyea42
/* education pitmans */ pitlev pitlev2 pitlev3 pitlev4 pitlev5 pitlev6 pitlev7
vocyea43 vocyea44 vocyea45 vocyea46 vocyea47 vocyea48 vocyea49
/* education NVQ */ nvqlev nvqlev2 nvqlev3 nvqlev4 nvqlev5 nvqlev6 nvqlev7 nvqlev8 nvqlev9 nvqlev10
vocyea50 vocyea51 vocyea52 vocyea53 vocyea54 vocyea55 vocyea56 vocyea57 vocyea58 vocyea59
/* education GNVQ */ gnvlev gnvlev2 gnvlev3 gnvlev4 gnvlev5
vocyea60 vocyea61 vocyea62 vocyea63 vocyea64
/* education ONC */ voconc vocyea65 vocyea66 vocyea67 vocyea68 vocyea69 vocyea70 vocyea71 vocyea72 vocyea73
/* education HNC */ vochnc vocyea74 vocyea75 vocyea76 vocyea77 vocyea78
/* education T.A. */ vocappr vocyea79 vocyea80 vocyea81 vocyea82 vocyea83 vocyea84 vocyea85 vocyea86 vocyea87
/* education HGV */  vochgv  vocyea88 vocyea89 vocyea90 vocyea91 vocyea92
/* education nurse */ numparam edqwhe86 edqwhe87 edqwhe88 edqwhe89 edqwhe90 edqwhe91 edqwhe92 edqwhe93 edqwhe94 edqwhe95
 edqwhe96 edqwhe97 edqwhe98 edqwhe99 edqwh100
/* education PGCE */ pgceyear pgcewhen
/* education teaching */ numotht edyea101 edyea102 edyea103 edyea104 edyea105 edyea106 edyea107 edyea108 edyea109 edyea110
edyea111 edyea112 edyea113 edyea114 edyea115
/* education current */ currqual curtype*;
cap drop *merge;
sort serial;
save age41_2.dta,replace;

use ncds&bcs70v1_5,replace;
rename nserial serial;
keep if sample==2;
keep serial
/* current pay */ cgropay cgroprd chours1 chours2 chours3 chours4 chours5 otimeany econact;
rename econact econact6;
cap drop *merge;
sort serial;
save age41_3.dta,replace;

use ifsdvs.dta,replace;
rename nserial serial;
keep if sample==2;
keep serial
/* hourly gross wages */ hr_gro
/* hourly net wages */ hr_net
/* annual gross income */ ann_gro
/* annual net income */ ann_net
/* hours worked */ hours
/* rpi index */ rpi_int;
cap drop *merge;
sort serial;
save age41_4.dta,replace;

/*************************************************/
/* derived variables age 41 */
/*************************************************/

use "qual derived ncds",replace;
cap drop serial;
rename nserial serial;
cap drop nserial;
keep if sample==2;
cap drop *merge;
sort serial;
save age41_5.dta,replace;

/*************************************************/
/* exam file */
/*************************************************/
use exams,replace;
keep serial
/* general */  e234 e236 e343 e347 e349 e361 e363 e383 e383 e387 e389 e428 e430 e432 e434 e436 e440 e442
/* subjects */ e443 e446 e449 e452 e455 e458 e461 e464 e467 e470 e473 e476 e479 e482 e485 e488 e491 e494 e497 e500 e503;
sort serial;
save exams.dta,replace;

merge serial using  age41_5.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age41_4.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age41_3.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age41_2.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age41_1.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age33.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age23_2.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age23.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age16.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age11.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age7.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  age0.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  ExpeNcds.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  jobdates5.dta;
tab *merge;
cap drop *merge;
sort serial;
merge serial using  jobdates6.dta;
tab *merge;
cap drop *merge;


save ncds.dta,replace;
