function [AbMat,A2,A0,K2,K0,Sc,Yp,Xc,Tc,Uc,...
    dimEc,dimK2,dimK0,dimSc,dimXc,dimYp,dimTc,dimUc] =...
    f_states(Ab2,Ab0,Sch,Ypr,Exp,Prd)

% Skills State variables
A2=MyTabulate(Ab2);
A0=MyTabulate(Ab0);

AbMat=cell(max(Prd),1);
for i=1:max(Prd) % define Skill age 16 and Skill age 7 data distributions
     AbMat{i}=MyTabulate2(Ab2(Prd==i),Ab0(Prd==i));
end

% Grids
K2=MyGrid(Ab2,[0 10 25 33 50 66 75 90 100]); % skill age 16 grid (0,1,2...)
K0=MyGrid(Ab0,[0 10 25 33 50 66 75 90 100]); % skill age 7 grid (0,1,2...)

Sc=(0:max(Sch))';                       % schooling grid
Yp=MyGrid(Ypr,0);                       % parental income grid (0,1,2...)
Xc=(0:max(Exp))';                       % experience grid    
Tc=(1:(65-16))';                        % time grid
Uc=(0:2)';                              % unobserved heterogeneity grid

% Dimensions
dimEc=4;              % shock
dimK2=length(K2);     % skill type age 16
dimK0=length(K0);     % skill type age 7
dimSc=length(Sc);     % schooling: No Qual, O Level, A Level, H.E.
dimXc=length(Xc);     % experience
dimYp=length(Yp);     % parental income
dimTc=length(Tc);     % time
dimUc=length(Uc);     % time
