function [STres] = f_pmatrices(STres,sb,tut,sub,eta,Smat,Vlife,Ab2,Ab0,Ypr)

global beta 

c=sb+1; % add 1 to take into account the baseline case

if sb==0, % baseline
    STres.tstmat(1,c) = abs(max(tut)); % amount of subsidy 
    STres.tstmat(3,c) = STres.tstmat(1,c)*Smat(1,1,1); % per-capita cost of subsidy (should be 0)
elseif sb>0 && sb<4, % Schooling Grants
    STres.tstmat(1,c) = abs(tut(sb)); % amount of subsidy  
    STres.tstmat(3,c) = STres.tstmat(1,c)*Smat(1,1,sb+(sb==3))*sb; % per-capita cost of subsidy 
else % parental income subsidies
    STres.tstmat(1,c) = abs(sub); % amount of subsidy 
    STres.tstmat(3,c) = STres.tstmat(1,c); % per-capita cost of subsidy 
end
STres.tstmat(2,c) = STres.tstmat(1,c)/prctile(Ypr,50); % subsidy as a % of median income

STres.etamat(1,c) = eta; % return to parental income
STres.etamat(2,c) = STres.etamat(1,c)/STres.etamat(1,1); % ratio over baseline

STres.k2mat(1,c) = mean(Ab2); % Average Ab2 level
STres.k2mat(2,c) = std(Ab2); % STD Ab2 level
STres.k2mat(3,c) = (STres.k2mat(1,c)-STres.k2mat(1,1))/STres.k2mat(2,1); % ratio over baseline

STres.k0mat(1,c) = mean(Ab0); % Average Ab0 level 
STres.k0mat(2,c) = std(Ab0); % Average Ab0 level 
STres.k0mat(3,c) = (STres.k0mat(1,c)-STres.k0mat(1,1))/STres.k0mat(2,1); % ratio over baseline

Vlifenet=Vlife(:,1)-beta^(25-16)*STres.tstmat(3,c); % lifetime utility net of grant/subsidy

STres.SWFmat(:,c,1) = f_swf(Vlifenet)'; % SWF
STres.SWFmat(:,c,2) = STres.SWFmat(:,c,1)./STres.SWFmat(:,1,1); % SWF ration to baseline case

STres.SCHmat(:,c) = [Smat(1,1,1); Smat(1,1,2); Smat(1,1,4)]; % School enrloments

STres.Vmat(:,c) = Vlifenet; % Value functions

STres.Abmat(:,c,1) = Ab2;
STres.Abmat(:,c,2) = Ab0;
