function f_pgraphics(STres)

% This function computes the difference in the V at each pctile. 
% Note that the V vectors are rankend within each policy and not based
% on the no-subsidy policy. This alternative differences can be obtained using
% the commented code. 

global nn

%% Differences at each pctile point (ranking within each V vector)
Vmatsort=sort(STres.Vmat,1);
Vmatplot=Vmatsort-repmat(Vmatsort(:,1),1,size(Vmatsort,2));

%% Differences at each pctile point (ranking based on no-subsidy V vector)
% [aux Ind]=sort(STres.Vmat(:,1));
% for i = 1:size(STres.Vmat,2)
%     Vmatsort(:,i)=STres.Vmat(Ind,i);
% end
% Vmatplot=Vmatsort-repmat(Vmatsort(:,1),1,size(Vmatsort,2));

%% Plot
plot((1:nn)/nn,Vmatplot(:,4),'red',(1:nn)/nn,Vmatplot(:,7),':',(1:nn)/nn,Vmatplot(:,8),'cyan')
xlabel('Percentiles of the expected lifetime utility distribution');
ylabel('Difference in Lifetime Utility (values in thousands)');
line([0.0 1.0],[0.0 0.0],'LineWidth',1,'LineStyle','--','Color','black');
saveas(gcf,'welfare.fig')
% saveas(gcf,'welfare.eps')



