function [x,y,z,g,k2,k0,Smat,Vlife]=f_peducat(varargin)

global tut Ypr eta 

% PEducat.m computes:
% x   = value of subsidy
% y   = subisdy/median parental income
% z   = per-capita cost of subsidy
% g   = return to parental income
% Smat= matrix with schooling enrollment
% Vlife=mean life time wealth
% Inputs:
% educat - Edu category for which we target increase (OL=1; AL=2; HE=3)
% subsidy - Edu category that we subsidize irrespective of educat (OL=1; AL=2; HE=3)
% Example
% [x,y,z,g,k2,k0,Smat]=f_peducat(3,1)

if nargin<2
    error('too few input arguments')
elseif nargin>2
    error('too many input arguments')
end

% educat  =varargin{1}; % Target increase (OL=1; AL=2; HE=3)
subsidy =varargin{2}; % Subisidy level (OL=1; AL=2; HE=3) 

tut=[0, 0, 0]';   % Rs param: tuition fees O Levels

if subsidy==0
    a=0; %
elseif subsidy>0 && subsidy <=3
    a=-prctile(Ypr,75)/subsidy; % higher subsidy for lower qualification
elseif subsidy>3
    a=3*eta;
end

tollerance=1e-4;
options=optimset('Display','iter','MaxIter',100,'MaxFunEvals',1000,'TolFun',tollerance);
a=fminsearch(@f_pexperiment,a,options); % find subsidy/return to parental income that achieves targeted increase in education
[Smat,Qmat,Tmat,Vlife]=f_psimulation(a); % cannot use the one from fminsearch cause only take max F

if subsidy==0
    x=0; y=0; z=0; g=eta;
elseif subsidy>0 && subsidy<=3
    x=a; 
    y=abs(x/prctile(Ypr,50)); 
    z=abs(x*Smat(1,1,subsidy+(subsidy==3))*subsidy); % per-capita cost of subsidy     
    g=eta;
elseif subsidy>3
    x=[]; y=[]; z=[]; g=a;
end
load TversionXVI;
k2=mean(Ab2s);
k0=mean(Ab0s);
