function [THETA,valP] = f_mstep(THETA,bl,bu)

global tollerance fhundle

% OFE04UCF  MINIMIZATIONS
ncnln=0;
a=0;
cjac=zeros(max(1,ncnln),length(THETA));
istate=zeros(length(bl),1);
clamda=zeros(length(bl),1);
r=zeros(length(THETA));
ifail=-1;
e04uef('derivative level=0')
e04uef('Hessian=no')
e04uef('Major Iteration Limit==20')
e04uef('Major Print Level==20')
e04uef('Minor Print Level==0')
e04uef('Monitoring File==1')
e04uef('Optimality Tolerance = tollerance')

mode=0;
n=0;
objf=[];
objgrd=[];
nstate=0;

% SIMPLEX
% options=optimset('Display','off','MaxIter',500,'MaxFunEvals',10000,'TolFun',tollerance);
options=optimset('Display','iter','MaxIter',1000,'MaxFunEvals',10000,'TolFun',tollerance);

valP=0;
   
for it=1:100
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    [iter,c,objf,objgrd,x,cjac,istate,clamda,r,ifail] =...
    e04ucf(bl,bu,'confun','f_nagsolve',THETA,ncnln,a,cjac,istate,clamda,r,ifail);

    THETA=x;

    if objf>valP & valP~=0 % inconsitent routine
        disp('NAG > Simplex')
        disp('pause mode')
        pause
    end

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    [xP,valP,flag,output]=fminsearch(@f_simplexsolve,[THETA],options);

    THETA=xP;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if abs(objf-valP)<tollerance
        break
    elseif abs(objf-valP)>=tollerance
        save MstepresultsXVI.mat ...
            fhundle it valP xP;
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end
