function [Rw]=f_modelWAG(THETA)

% VERSION X

global dimK2 dimK0 dimSc dimXc dimUc
global K2 K0 Xc 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

al_01   = THETA(02)     ;
al_02   = THETA(02)+abs(THETA(03))     ;
al_03   = THETA(02)+abs(THETA(04))     ;
al_K2   = THETA(05)     ;
al_K0   = THETA(06)     ;
al_S1   = THETA(07)     ;   % Rw coeff: O Levels schooling in wage equation
al_S2   = THETA(08)     ;   % Rw coeff: O Levels schooling in wage equation
al_S3   = THETA(09)     ;   % Rw coeff: O Levels schooling in wage equation
al_X0   = THETA(10)     ;   % Rw coeff: O Levels schooling in wage equation
al_X1   = THETA(11)     ;
al_X2   = THETA(12)     ;
al_X3   = THETA(13)     ;

al_00=[al_01, al_02, al_03]';  % dUc
al_S=[0, al_S1, al_S2, al_S3]'; %                        % dSc
al_X=[al_X0, al_X0+al_X1, al_X0+al_X2, al_X0+al_X3]'; %   % dSc

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% REWARDS
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Ru unemployment reward
% Wage constant aux matrix
auxRw00=repmat(al_00,[1 dimK2 dimSc dimK0 dimXc]);              % dUc dK2 dSc dK0 dXc

% Skill age 16 returns  aux matrix
auxRwK2=al_K2*repmat(K2,[1 dimUc dimSc dimK0 dimXc]);           % dK2 dUc dSc dK0 dXc
auxRwK2=permute(auxRwK2,[2 1 3 4 5]);                           % dUc dK2 dSc dK0 dXc

% Skill age 7 returns  aux matrix
auxRwK0=al_K0*repmat(K0,[1 dimUc dimK2 dimSc dimXc]);           % dK0 dUc dK2 dSc dXc
auxRwK0=permute(auxRwK0,[2 3 4 1 5]);                           % dUc dK2 dSc dK0 dXc

% Schooling returns aux matrix
auxRwS=repmat(al_S,[1 dimUc dimK2 dimK0 dimXc]);                % dSc dUc dK2 dK0 dXc  
auxRwS=permute(auxRwS,[2 3 1 4 5]);                             % dUc dK2 dSc dK0 dXc 

% Experience returns aux matrix
auxRwX=al_X*Xc';                                                % dSc dXc
auxRwX=repmat(auxRwX,[1 1 dimUc dimK2 dimK0]);                  % dSc dXc dUc dK2 dK0
auxRwX=permute(auxRwX,[3 4 1 5 2]);                             % dUc dK2 dSc dK0 dXc

Rw=auxRw00+auxRwK2+auxRwK0+auxRwS+auxRwX;                       % dUc dK2 dSc dK0 dXc
clear auxRw00 auxRwK2 auxRwK0 auxRwS auxRwX
