function [Lam]=f_modelLAM(THETA)

% VERSION IX

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global dimT tol
global beta tut1 tut2 tut3 rho

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

l1_01   = THETA(01) ;                   % Constant in P(Q1=1)
l1_02   = THETA(01)+THETA(end-1) ;        % Constant in P(Q1=1)
l1_03   = THETA(01)-THETA(end) ;        % Constant in P(Q1=1)
l1_K2   = THETA(02) ;                   % K coeff in P(Q1=1)
l1_K0   = THETA(03) ;                   % Y coeff in P(Q1=1) 

l2_00   = THETA(04) ;   % Constant in P(Q2=1)
l2_K2   = THETA(05) ;   % K coeff in P(Q2=1)
l2_K0   = THETA(06) ;   % Y coeff in P(Q2=1) 

l3_00   = THETA(04) ;   % Constant in P(Q3=1)
l3_K2   = THETA(05) ;   % K coeff in P(Q3=1)
l3_K0   = THETA(06) ;   % Y coeff in P(Q3=1) 

l1_00=[l1_01, l1_02, l1_03]';  % dUc

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% PROBABILITIES
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% probabilities of success in school
auxLaUc=repmat(l1_00,[1 dimK2 dimSc-1 dimK0]);                      % dUc dK2 dSc-1 dK0
auxLa00=repmat([0 l2_00 l3_00]',[1 dimUc dimK2 dimK0]);             % dSc-1 dUc dK2 dK0
auxLa00=permute(auxLa00,[2 3 1 4]);                                 % dUc dK2 dSc-1 dK0
auxLaK2=K2*[l1_K2 l2_K2 l3_K2]; %                                   % dK2 dSc-1
auxLaK2=repmat(auxLaK2,[1 1 dimUc dimK0]);                          % dK2 dSc-1 dUc dK0
auxLaK2=permute(auxLaK2,[3 1 2 4]);                                 % dUc dK2 dSc-1 dK0
auxLaK0=K0*[l1_K0 l2_K0 l3_K0]; %                                   % dK0 dSc-1
auxLaK0=repmat(auxLaK0,[1 1 dimUc dimK2]);                          % dK0 dSc-1 dUc dK2
auxLaK0=permute(auxLaK0,[3 4 2 1]);                                 % dUc dK2 dSc-1 dK0
Lam=auxLaUc+auxLa00+auxLaK2+auxLaK0;                                % dUc dK2 dSc-1 dK0

clear auxLa00 auxLaK2 auxLaK0
