function L=f_likelihoodWAG(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global ni nn no np

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sigU    = abs(THETA(1))    ;   % s.d error term in observed Wage

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Rw]=f_modelWAG(THETA); % import output from model

%%% Expected Next Period Life-Time Rewards
RwL=zeros(no,dimUc);
RwL(:,1)=MyLinear(K2,Sc,K0,Xc,squeeze(Rw(1,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear');       
RwL(:,2)=MyLinear(K2,Sc,K0,Xc,squeeze(Rw(2,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear');       
RwL(:,3)=MyLinear(K2,Sc,K0,Xc,squeeze(Rw(3,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear');       

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% LIKELIHOOD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=ones(no,dimUc);

L(indW,:)=(1/sigU)*normpdf((log(repmat(Wag(indW),[1 dimUc]))-RwL(indW,:))/sigU); 

clear Rw RwL

% final value
L=max(L,1e-300);
