function L=f_likelihoodPHI(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global beta
global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global ni nn no np

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Phi]=f_modelPHI(THETA); % import output from model

% assign deltas (probability of receiving a job offer)
PhiL=zeros(no,dimUc);
PhiL(:,1)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Phi(1,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
PhiL(:,2)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Phi(2,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
PhiL(:,3)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Phi(3,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% LIKELIHOOD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=ones(no,dimUc);

L(ind1,:)   =1-PhiL(ind1,:)                           ; % W -> W  
L(ind4,:)   =PhiL(ind4,:)                             ; % W -> U

clear Phi PhiL

% final value
L=max(L,1e-300);
