function L=f_likelihoodDTA(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global ni nn no np

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Dta,Dta1]=f_modelDTA(THETA); % import output from model

% assign deltas (probability of receiving a job offer)
DtaL=zeros(no,dimUc);
DtaL(:,1)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta(1,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
DtaL(:,2)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta(2,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
DtaL(:,3)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta(3,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc

Dta1L=zeros(no,dimUc);
Dta1L(:,1)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta1(1,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
Dta1L(:,2)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta1(2,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc
Dta1L(:,3)=MyNormcdf(MyLinear(K2,Sc,K0,Xc,squeeze(Dta1(3,:,:,:,:)),Ab2,Qua,Ab0,Exp,'linear')); % dK2 dSc dK0 dXc

DtaL(Prd==2,:)=Dta1L(Prd==2,:); % DTA for period 1 is different from DTA in remaining periods

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% LIKELIHOOD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=ones(no,dimUc);

L(ind2,:)   =DtaL(ind2,:)         ; % U -> W;
L(ind3,:)   =1-DtaL(ind3,:)       ; % U -> U;

L(ind8,:)   =DtaL(ind8,:)         ; % S1 -> W  | Q1=1;
L(ind9,:)   =DtaL(ind9,:)         ; % S1 -> W  | Q1=0;
L(ind10,:)  =(1-DtaL(ind10,:))    ; % S1 -> U  | Q1=1;
L(ind11,:)  =(1-DtaL(ind11,:))    ; % S1 -> U  | Q1=0

L(ind14,:)  =DtaL(ind14,:)        ; % S2 -> W  | Q2=1
L(ind15,:)  =DtaL(ind15,:)        ; % S2 -> W  | Q2=0
L(ind16,:)  =(1-DtaL(ind16,:))    ; % S2 -> U  | Q2=1
L(ind17,:)  =(1-DtaL(ind17,:))    ; % S2 -> U  | Q2=0

L(ind19,:)  =DtaL(ind19,:)        ; % S3 -> W
L(ind20,:)  =(1-DtaL(ind20,:))    ; % S3 -> U

clear Dta1 Dta2 DtaL Dta1L

% final value
L=max(L,1e-300);
