function L=f_likelihood(THETA)

global THETAF tWAG tLAM tDTA tPHI tSCH

% VERSION X

ThetaWAG=THETA(1                           :tWAG);
ThetaLAM=THETA(tWAG+1                      :tWAG+tLAM);
ThetaDTA=THETA(tWAG+tLAM+1                 :tWAG+tLAM+tDTA);
ThetaPHI=THETA(tWAG+tLAM+tDTA+1            :tWAG+tLAM+tDTA+tPHI);
ThetaSCH=THETA(tWAG+tLAM+tDTA+tPHI+1       :tWAG+tLAM+tDTA+tPHI+tSCH);

LWAG=f_likelihoodWAG(ThetaWAG); 
LLAM=f_likelihoodLAM(ThetaLAM); 
LDTA=f_likelihoodDTA(ThetaDTA); 
LPHI=f_likelihoodPHI(ThetaPHI); 

THETAF=[ThetaWAG;ThetaLAM;ThetaDTA;ThetaPHI];

LSCH=f_likelihoodSCH(ThetaSCH); 

L=LWAG.*LLAM.*LDTA.*LPHI.*LSCH;
L=max(L,1e-300);
