clear all
clear global
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SETTINGS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set(0,'DefaultFigureWindowStyle','docked') ; % dock figures

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load FresultsXVsq

dimUc=3;
dimSc=4;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Qualifications by Skills
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% True Data
subplot(2,1,1);
bar(QK2mat(:,1),QK2mat(:,2:end),1);
title 'Age 16 cognitive skills';
xlabel('quantiles');
ylabel('fraction');
subplot(2,1,2);
bar(QK0mat(:,1),QK0mat(:,2:end),1);
title 'Age 7 cognitive skills';
xlabel('quantiles');
ylabel('fraction');
legend('No Qual','O Lev','A Lev','HE','Location','BO','Orientation','horizontal') ;
saveas(gcf, 'QbySkill', 'eps');

%%% Simul Data
subplot(3,3,1:3);
bar(QK2mat(:,1),QK2mat(:,2:end),1);
title 'Data - Age 16 cognitive skills';
subplot(3,3,4:6);
bar(QK2Smat(:,1),QK2Smat(:,2:end),1);
title 'Simulation - Age 16 cognitive skills';
% legend('No Qual','O Lev','A Lev','HE','Location','SO','Orientation','horizontal') ;
saveas(gcf, 'QbySkill16Fit', 'eps');

%%% Simul Data with heterogeneity
subplot(3,3,7);
bar(QK2SHmat(:,1,1),QK2SHmat(:,2:end,1),1);
title 'Simulation type 1';
subplot(3,3,8);
bar(QK2SHmat(:,1,2),QK2SHmat(:,2:end,2),1);
title 'Simulation type 2';
legend('No Qual','O Lev','A Lev','HE','Location','BO','Orientation','horizontal');
subplot(3,3,9);
bar(QK2SHmat(:,1,3),QK2SHmat(:,2:end,3),1);
title 'Simulation type 3';
saveas(gcf, 'QbySkill16HetFit', 'fig');


%%% Simul Data
subplot(3,3,1:3);
bar(QK0mat(:,1),QK0mat(:,2:end),1);
title 'Data - Age 7 cognitive skills';
% legend('No Qual','O Lev','A Lev','HE','Location','SO','Orientation','horizontal') ;
subplot(3,3,4:6);
bar(QK0Smat(:,1),QK0Smat(:,2:end),1);
title 'Simulation - Age 7 cognitive skills';
% legend('No Qual','O Lev','A Lev','HE','Location','SO','Orientation','horizontal') ;
saveas(gcf, 'QbySkill7Fit', 'eps');


subplot(3,3,7);
bar(QK0SHmat(:,1,1),QK0SHmat(:,2:end,1),1);
title 'Simulation type 1';
subplot(3,3,8);
bar(QK0SHmat(:,1,2),QK0SHmat(:,2:end,2),1);
title 'Simulation type 2';
legend('No Qual','O Lev','A Lev','HE','Location','BO','Orientation','horizontal');
subplot(3,3,9);
bar(QK0SHmat(:,1,3),QK0SHmat(:,2:end,3),1);
title 'Simulation type 3';
saveas(gcf, 'QbySkill7HetFit', 'fig');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Educational Choices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Edumat=zeros(5,2);
Edumat(:,1)=(1:5)'; 

%%% True Data
Edumat(1,2)=Tmat(5,1,1); % Take O Levels
Edumat(2,2)=sum([Tmat(7,1,2); Tmat(8,1,2); Tmat(10,1,2)]); % Pass O Levels
Edumat(3,2)=Tmat(7,1,2); % Take A Levels
Edumat(4,2)=sum([Tmat(13,1,4); Tmat(14,1,4); Tmat(16,1,4)]); % Pass A Levels
Edumat(5,2)=Tmat(13,1,4); % Take HE
% Edumat(6,2)=Tmat(18,1,5); % Pass HE

%%% Simul Data
Edumat(1,3)=TSmat(5,1,1); % Take O Levels
Edumat(2,3)=sum([TSmat(7,1,2); TSmat(8,1,2); TSmat(10,1,2)]); % Take O Levels
Edumat(3,3)=TSmat(7,1,2); % Take A Levels
Edumat(4,3)=sum([TSmat(13,1,4); TSmat(14,1,4); TSmat(16,1,4)]); % Take A Levels
Edumat(5,3)=TSmat(13,1,4); % Take HE
% Edumat(6,3)=TSmat(18,1,5); % Pass HE

%%% Data Plot
subplot(1,1,1);
bar(Edumat(:,1),Edumat(:,2),0.8,'r');
set(gca,'XTickLabel',{'Take O Lev','Pass O Lev','Take A Lev','Pass A Lev','Take HE'});
saveas(gcf, 'EduChoices', 'eps');

%%% Model Fit
subplot(2,1,1);
EduChoicesFit=bar(Edumat(:,1),Edumat(:,2:3),0.8);
legend('True Data','Simul Data','Location','NE') ;
set(gca,'XTickLabel',{'Take O Lev','Pass O Lev','Take A Lev','Pass A Lev','Take HE'});
title 'True vs Simulated Educational Choices';
set(EduChoicesFit(2),'FaceColor',[0 1 1]);
saveas(gcf, 'EduChoicesFit', 'eps');

%%% Het Simul Data
EdumatH=zeros(5,dimUc+1);
EdumatH(:,1)=(1:5)'; 
EdumatH(1,2:end)=TSmatH(5,:,1); % Take O Levels
EdumatH(2,2:end)=sum([TSmatH(7,:,2); TSmatH(8,:,2); TSmatH(10,:,2)]); % Take O Levels
EdumatH(3,2:end)=TSmatH(7,:,2); % Take A Levels
EdumatH(4,2:end)=sum([TSmatH(13,:,4); TSmatH(14,:,4); TSmatH(16,:,4)]); % Take A Levels
EdumatH(5,2:end)=TSmatH(13,:,4); % Take HE

%%% Model Fit Het
subplot(2,1,2);
EduChoicesHetFit=bar(EdumatH(:,1),EdumatH(:,2:end),0.8);
legend('Type 1','Type 2','Type 3','Location','NE') ;
set(gca,'XTickLabel',{'Take O Lev','Pass O Lev','Take A Lev','Pass A Lev','Take HE'});
title 'Simulated Educational Choices by Type';
set(EduChoicesHetFit(3),'FaceColor',[0.9412 0.9412 0.9412]);
saveas(gcf, 'EduChoicesHetFit', 'eps');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Wages
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(1,1,1);
bar((1:4)',log(Wmat(2:end,1,1)*1e3),'r');
axis([0 5 9.2 10.4]);
set(gca,'XTickLabel',{'No Qual','O Level','A Level','HE'});
saveas(gcf, 'WbyQ', 'eps');

subplot(1,1,1);
bar((1:5)',log(WK2mat(:,2)*1e3));
axis([0 6 9.2 10.4]);
xlabel('quantiles');
saveas(gcf, 'WbyK2', 'eps');

subplot(1,1,1);
bar((1:5)',log(WK2mat(:,3:end)*1e3));
axis([0 6 9.2 10.4]);
xlabel('quantiles');
legend('No Qual','O Lev','A Lev','HE','Location','BO','Orientation','horizontal');
saveas(gcf, 'WbyK2Q', 'eps');

subplot(2,1,1);
WbyQFit=bar((1:4)',[log(Wmat(2:end,1,1)*1e3),log(WSmat(2:end,1,1)*1e3)]);
axis([0 5 9.2 10.4]);
legend('True Data','Simul Data','Location','NW') ;
set(gca,'XTickLabel',{'No Qual','O Level','A Level','HE'});
title 'True vs Simulated Wages';
set(WbyQFit(2),'FaceColor',[0 1 1]);
saveas(gcf, 'WbyQFit', 'eps');

subplot(2,1,2);
WbyQHetFit=bar((1:4)',[log(WSHmat*1e3)]);
axis([0 5 9.2 10.4]);
legend('Type 1','Type 2','Type 3','Location','NW') ;
set(gca,'XTickLabel',{'No Qual','O Level','A Level','HE'});
title 'Simulated Wages by Type';
set(WbyQHetFit(3),'FaceColor',[0.9412 0.9412 0.9412]);
saveas(gcf, 'WbyQHetFit', 'eps');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Wages by Experience
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(1,1,1);
for i=2:5
    a=find(WXmat(:,i)==0);
    WXmat(a,i)=NaN;
    WXmat2(:,i)=inpaint_nans(WXmat(:,i),3);
end
plot(WXmat(:,1),log(WXmat2(:,2:end)));
axis([0 22 1 5]);

subplot(1,1,1);
plot(WXSmat(:,1),log(WXSmat(:,2:end)));
axis([0 22 1 5]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Time Series O Levels
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load Series;
% subplot(1,1,1);
% plot(aa(:,2),aa(:,1),'LineWidth',2);
% axis([65 94 0.1 0.6]);
% saveas(gcf, 'OLbyAge', 'eps');
