function [THETA2,logL,logL1,logLE,THETAg,logLSCH,iter]=...
    TJMP_XVIII(THETA,bl,bu)

% VERSION XVI
% This file re-estimate a THETA_hat vector from a data set generated by the
% TSimulation function. 

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global scale
global beta tut rho

global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Q1 Q2 Q3 Ypr
global nn np ni no
global tollerance fhundle THETAF tWAG tLAM tDTA tPHI tSCH

% TData
global dTHETA Estimate Sequential 

% Unobserved Heterogeneity
global idh niter
global Prk

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load TversionXVI.mat

id=ids;
Ab2=Ab2s;
Ab0=Ab0s;
Prd=Prds;
Sta=Stas;
Sch=Schs;
Qua=Quas;
Typ=Typs;
Wag=Wags;
Exp=Exps;

clear Ab2s Ab0s Yprs Prds Stas Schs Quas Typs Wags Exps

a=tabulate(id);
ni=sum(a(:,2)~=0); % N = number of individuals
no=length(id); % number of observations

% Identify types
ind1    =find(Typ==1)   ; % W -> W
ind2    =find(Typ==2)   ; % U -> W
ind3    =find(Typ==3)   ; % U -> U
ind4    =find(Typ==4)   ; % W -> U
ind5    =find(Typ==5)   ; % S0 -> S1
ind6    =find(Typ==6)   ; % S0 -> U
ind7    =find(Typ==7)   ; % S1 -> S2 | Q1=1
ind8    =find(Typ==8)   ; % S1 -> W  | Q1=1
ind9    =find(Typ==9)   ; % S1 -> W  | Q1=0
ind10   =find(Typ==10)  ; % S1 -> U  | Q1=1
ind11   =find(Typ==11)  ; % S1 -> U  | Q1=0

ind13   =find(Typ==13)  ; % S2 -> S3 | Q2=1
ind14   =find(Typ==14)  ; % S2 -> W  | Q2=1
ind15   =find(Typ==15)  ; % S2 -> W  | Q2=0
ind16   =find(Typ==16)  ; % S2 -> U  | Q2=1
ind17   =find(Typ==17)  ; % S2 -> U  | Q2=0

ind19   =find(Typ==19)  ; % S3 -> W  | Q3=1
ind20   =find(Typ==20)  ; % S3 -> W  | Q3=1

indW    =find(Sta==2&Wag~=0)    ; %  -> W observed in Period 8, 19 or 27

Q1=(Qua==1); % Schooling Dummies
Q2=(Qua==2); % Schooling Dummies
Q3=(Qua==3); % Schooling Dummies

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% UNOBSERVED HETEROGENEITY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

idk=[1; cumsum(id(1:end-1)~=id(2:end))+1]; % id ordered 1,2,...,N
idh =(idk-1)*max(Prd)+Prd; % het location to be used in computing likelihood

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MINIMIZATION ROUTINE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

logL=f_logLk(THETA);

for i=1:2:length(THETA)-dimUc
    THETA(i)=THETA(i)/(1+dTHETA);
end
for i=2:2:length(THETA)-dimUc
    THETA(i)=THETA(i)*(1+dTHETA);
end

THETA(end-dimUc+1:end)=repmat(1/dimUc,[dimUc 1]);

logL1=f_logLk(THETA);

THETAg=THETA;

ThetaWAG=THETA(1                           :tWAG);
ThetaLAM=THETA(tWAG+1                      :tWAG+tLAM);
ThetaDTA=THETA(tWAG+tLAM+1                 :tWAG+tLAM+tDTA);
ThetaPHI=THETA(tWAG+tLAM+tDTA+1            :tWAG+tLAM+tDTA+tPHI);
ThetaSCH=THETA(tWAG+tLAM+tDTA+tPHI+1       :tWAG+tLAM+tDTA+tPHI+tSCH);

pk=THETA(end-dimUc+1:end);

blWAG=bl(1                           :tWAG);
blLAM=bl(tWAG+1                      :tWAG+tLAM);
blDTA=bl(tWAG+tLAM+1                 :tWAG+tLAM+tDTA);
blPHI=bl(tWAG+tLAM+tDTA+1            :tWAG+tLAM+tDTA+tPHI);
blSCH=bl(tWAG+tLAM+tDTA+tPHI+1       :tWAG+tLAM+tDTA+tPHI+tSCH);

buWAG=bu(1                           :tWAG);
buLAM=bu(tWAG+1                      :tWAG+tLAM);
buDTA=bu(tWAG+tLAM+1                 :tWAG+tLAM+tDTA);
buPHI=bu(tWAG+tLAM+tDTA+1            :tWAG+tLAM+tDTA+tPHI);
buSCH=bu(tWAG+tLAM+tDTA+tPHI+1       :tWAG+tLAM+tDTA+tPHI+tSCH);

tollerance=1e-3;
logLE0=logL1;
Res_t(:,1)=[THETA;logLE0*1.0e-03];  % vector of results [coefs, weights]

[0 pk' logLE0*1.0e-03]

for i=1:niter
    
    %%% E Step
    Prk=f_pcond(THETA);
    
    %%% M Step 1: find argmax Likelihood
    fhundle=@f_likelihoodWAG; [ThetaWAG,logLWAG]=f_mstep(ThetaWAG,blWAG,buWAG); 
    fhundle=@f_likelihoodLAM; [ThetaLAM,logLLAM]=f_mstep(ThetaLAM,blLAM,buLAM); 
    fhundle=@f_likelihoodDTA; [ThetaDTA,logLDTA]=f_mstep(ThetaDTA,blDTA,buDTA); 
    fhundle=@f_likelihoodPHI; [ThetaPHI,logLPHI]=f_mstep(ThetaPHI,blPHI,buPHI); 

    THETAF=[ThetaWAG;ThetaLAM;ThetaDTA;ThetaPHI];

    fhundle=@f_likelihoodSCH; [ThetaSCH,logLSCH]=f_mstep(ThetaSCH,blSCH,buSCH);
    
    %%% M Step 2:(update pk)
    pk=(sum(Prk,1)/ni)'; % new pk    

    THETA=[ThetaWAG; ThetaLAM; ThetaDTA; ThetaPHI; ThetaSCH; pk];
    logLE1=f_logLk(THETA);
    
    if i>1 & (logLE0>logLE1) & (logLE0-logLE1<1e-1)
        disp('end of iterations: convergence achieved')
        break
    elseif (logLE0<logLE1)
        disp('error: logLE0<logLE1')
        pause        
    else
        logLE0=logLE1;
        Res_t(:,i+1)=[THETA;logLE0*1.0e-03];
        save SresultsXVIt.mat Res_t;
        [i pk' logLE0*1.0e-01 THETA(2:dimUc+1)']
    end
    
end
        
iter=i;
THETA2=THETA;
logLE=logLE1;
