function y = MyTabulate2(x1,x2)

% The function MyTabulate2 takes as input two n by 1 vectors of random 
% variables and returns a 3 cells array: 
% cell 1 = crosstab frquencies table
% cell 2 = vector of x1 values 
% cell 3 = vector of x2 values
% 
% Inputs: x1 and x2
% 
% Example: MyTabulate2(x1,x2)

table = double(crosstab(x1,x2)); 
% aux1 = tabulate(x1); x1v = aux1(:,1);
% aux2 = tabulate(x2); x2v = aux2(:,1);
x1v = unique(x1);
x2v = unique(x2);

y = cell(1,3);
y{1} = table;
y{2} = x1v;
y{3} = x2v;