function  y=MyGrid(varargin)

% MyGrid.m computes the grid points, taking the mean value of each interval
% defined by the cut-off points.
% Inputs:
% x - variable to be discretized
% c - cut-off points (percentiles)
% optional - a string 'no' stating that want to keep original values
% Example
% y=MyGrid(x,[0 33 66 100]);

if nargin<2
    error('too few input arguments')
elseif nargin>3
    error('too many input arguments')
end

x=varargin{1};
c=varargin{2};

a=MyTabulate(x);

if ischar(varargin{end}) % just use variable original value for grid
    y=a(:,1);
else % start discretization process
    aux1=MyPrctile(x,c); % define cut-off points
    b=MyTabulate(aux1);
    if length(b(:,1))<length(c)
        aux1
        error('percentiles are not distinct values')
    end
        
    a1=find(x<=aux1(1)); % individuals within the first cut-off point
    y(1,1)=median(x(a1)); % replace with median value within interval
    
    for i=2:size(aux1,2) % loop over remaining intervales
        a1=find(x>aux1(i-1)&x<=aux1(i)); 
        y(i,1)=median(x(a1));
    end
        
    a1=find(x>aux1(size(aux1,2))); % last interval
    if size(a1,1)>0
        y(size(aux1,2)+1,1)=median(x(a1));
    else
        y(size(aux1,2)+1,1)=max(x); % correct if max is a grid point
    end
end
