CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCC
CCC  f77 code used in 
CCC
CCC  C. Fernandez, E.Ley & M.J.F. Steel (2001)
CCC  "Model Uncertainty in Cross-Country Growth Regressions"
CCC  Journal of Applied Econometrics
CCC
CCC
CCC  Version: January 22, 2001
CCC  WARNING ADDED 06/09/02: KREG CANNOT BE > 52!  
CCC                          USE UPDATED CODE IF YOU HAVE MORE 
CCC                          THAN 52 REGRESSORS!
CCC
CCC  Input: 
CCC           growth.par (first line contains name)
CCC           growth.dat
CCC
CCC  Output:  
CCC           name.out 
CCC           name.mma (contains pdf coordinates that can be read into 
CCC                     Mathematica for easy plotting using ListPlot.)
CCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCC        
CCC The parameters in growth.par (see setup below), are the following:
CCC
CCC                        
CCC growth00	  char8 namefile for output files
CCC -98170        integer random number seed
CCC 9	          integer (1-9) specifiying prior, see routine computefj
CCC 100000        integer warmup draws
CCC 500000        integer chain draws
CCC 72            integer nobs
CCC F             logical prediction?
CCC 1.0d0         real sample split for within sample pred
CCC F             logical wrpost?
CCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c
c-----------------------------------------------------------------------
c
      program bma
c
c-----------------------------------------------------------------------
c
      implicit real*8 (a-h,o-z)
      
      integer fout,fmma
      parameter (fout=16,fmma=17)
      parameter (kreg=41,maxn=75,maxm=350000,maxnf=50) 
      logical fail,wrpost,prediction,visited, allvis
      integer kj(maxm),mmodel(kreg),idx(maxm),ir(kreg)
      character*12 regname(kreg)
      real*8 z(maxn,kreg),y(maxn),ztz(kreg,kreg),yf(maxnf),
     & zf(kreg,maxnf),bhat(kreg),midx(maxm),
     & bayesf(maxm),freq(maxm),gj(maxm),dstar(maxm),bstar(kreg,maxm),
     & bayesf2(maxm),freq2(maxm),midx2(maxm)

c
c  NOTE: Kreg cannot be > 52; use fls060828.f instead!
c      
      if (kreg.gt.52) then
         write(fout,*) 'Error, kreg cannot be > 52!'
         write(fout,*) 'Use fls060828.f instead!!'
         write(*,*)    'Error, kreg cannot be > 52!'
         write(*,*)    'Use fls060828.f instead!!'
         close(fout)
         stop
       endif
c
c-----------------------------------------------------------------------
c  0. SETUP
c-----------------------------------------------------------------------

      call setup(fout,fmma,iprior,regname,
     &      wrpost,prediction,
     &      nf,yf,zf,bhat,
     &      idum,initrep,mnumrep,nobs,ztz,z,y,avey,ssqy,fail)
      

      if (fail) then
         write(fout,*) '!!! SetUp FAIL !!!'
	 close(fout)
         stop
      endif
     
      
      call wr_time(fout,.true.,.true.)

      write(fout,*) ' Set Up done! '
      write(*,*) '... Set Up done! '
c      
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Run chain
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      call runChain(iprior,idum,initrep,mnumrep,nobs,ztz,z,y,ssqy,
     &   freq,bayesf,gj,dstar,bstar,midx,kj,imax,nvout,fout,fail,fjout,
     &   mmodel,fjsum)
     
      write(*,*) '... Chain done! ',imax
      call wr_time(fout,.true.,.true.)
      if (fail) then
         write(fout,*) ' !!! Fail Running Chain!!'
         stop
      endif
      if (nvout.gt.0) then
         write(fout,*) ' !!! ',nvout,' Visits Out!!!'
         write(fout,*) ' !!! mass',fjout,' Visits Out!!!'
      endif
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  write chain info
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      call wrChaInfo(regname, bayesf,midx,bstar,gj,
     &      imax,nvout,ibm,icut,idx,fout,fail)
c      call barra('*',75,fout)
c      call wrtime(fout,time)
c      call barra('*',75,fout)
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  write post misc info to mma file
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      if (wrpost) then
         write(*,*) '... writing post chain info ...'
         call wrPostInfo(nobs,ztz,z,bhat,
     &         bayesf,gj,dstar,bstar,midx,
     &         imax,ibm,fmma,fail)
         call barra('*',75,fout)
         write(fout,*) '***  Post of Betas written to file'
c         call wrtime(fout,time)
         call barra('*',75,fout)
         if (fail) write(*,*) '>>> FAIL in wrChaInfo().1'
      endif
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  within-smaple prediction
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
         if (prediction) then
c
c write out z_f's
c      
         write(fout,*)
         call barra('+',75,fout)
         write(fout,*) 'Within-of-sample Prediction; nf =',nf
         write(fout,*)
c
         call lps(iprior,regname,imax,ibm,nobs,
     &         bayesf,gj,dstar,bstar,midx,
     &         avey,ssqy,ztz,z,y,nf,yf,zf,fout,fail,mmodel)

         if (fail) write(fout,*) '>>> FAIL in LPS()'
	 endif

c
cccccccccccccccccccccccccccccccccccccccccccc
c
c  G&M stuff (run short chain, pick best 75% models,
c  compute ML(A) and VIS(A) and
c  (vis(A)/ML(A))*ML(M)
c
ccccccccccccccccccccccccccccccccccccccccccccc
c
c      initrep=initrep/10
c      mnumrep=mnumrep/10
      initrep=100000
      mnumrep=200000

         write(fout,*)
         call barra('+',75,fout)
         write(fout,*) '2nd G&M chain: ',initrep,mnumrep
         write(fout,*)
c
c  Things we don't want to overwrite:
c
c     freq2, bayesf2, midx2, imax2, fjsum2
c
      call runChain(iprior,idum,initrep,mnumrep,nobs,ztz,z,y,ssqy,
     &   freq2,bayesf2,gj,dstar,bstar,midx2,kj,imax2,nvout,
     &   fout,fail,fjout,mmodel,fjsum2)

      call wrChaInfo(regname, bayesf2,midx2,bstar,gj,
     &      imax2,nvout,ibm,icut,idx,fout,fail)
c
c  icut will tell us how many models in this 2nd chain are needed
c  to account for 75% of posterior mass
c
c  idx contains the sorted array-indices of the top icut models
c
         write(fout,*)
         call barra('+',75,fout)
         write(fout,*) ' Will use: ',icut,' models (90% mass)'
         write(fout,*) ' of 2nd chain as A in the 1st chain.'
         write(fout,*)
     
      fja  = 0.0d0
      fjaa = 0.0d0
      fjaa1= 0.0d0
      visa = 0.0d0
c
c  now we just look at the icut best models (whose ind are the bottom
c  icut entries in idx()), so we loop from (imax2+1-icut) to imax2
c
         allvis =.true.
         do 100 i=imax2+1-icut,imax2
         visited = .false.
c
c  accumulate marginal likelihoods (need to multiply by ML(M) since 
c  bayesf are normalized numbers
c
          fja= fja + bayesf2(idx(i))*fjsum2
c
c  loop over visited models in chain #1, if it was visited there,
c  accumulate bayesf in fjaa and visits in visa
c
          do 8625 imod=1,imax                                           
            if (midx2(idx(i)).eq.midx(imod)) then                           
                fjaa= fjaa + bayesf2(idx(i))*fjsum2
                fjaa1= fjaa1 + bayesf(imod)*fjsum
                visa = visa + freq(imod)
                visited = .true.
                goto 8626
            endif
 8625    enddo
 8626    continue
         if (.not.visited) then
	  allvis = .false.
          call gmodel2(midx(imod),kreg,mmodel,kkjj,ir)
          write(fout,101) bayesf2(idx(i))*100.0d0   
          write(fout,*) (ir(j),j=1,kkjj)
          write(fout,*)
         endif
  100    enddo
  101    format('Model Not visited, mass: ',e12.4) 
         if (allvis) write(fout,*)'ALL VISITED !'
c.........................................................
c
c  write results
c
      write(fout,*)
      call barra('=',75,fout)
      write(fout,*)
      write(fout,*) 'George & McCulloch: Direct Estimation'
      write(fout,*) 'post model prob of all visited models'
      write(fout,*)
      write(fout,20) visa
  20  format(' Vis(A)................',e12.4)
      write(fout,30) fja
  30  format(' ML(A).................',e12.4)
c
c  we want fjsum of the 1st chain here!
c
      write(fout,40) fjsum
  40  format(' ML(M).................',e12.4)
      if (fja.ne.0) then
      write(fout,50) (visa*(fjsum/fja))*100.0d0
      else
      write(fout,50) -99.99
      endif
  50  format(' PMP(M)................',e12.4,' %') 
      if (fja.ne.0) then
      write(fout,60) (fjaa/fja)*100.0d0
      write(fout,61) (fjaa/fjaa1)*100.0d0
      else
      write(fout,50) -99.99
      endif
  60  format(' %A visited by chain...',e12.4,' %') 
  61  format(' This should be 100....',e12.4,' %') 
      write(fout,*)
      call barra('=',75,fout)
      write(fout,*)

c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      call wr_time(fout,.true.,.true.)
c          
      stop
      end
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%                                                                 %%%
c%%%  SUBROUTINES                                                    %%%
c%%%                                                                 %%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c
      subroutine setup(fout,fmma,iprior,name,
     &      wrpost,prediction,
     &      nf,yf,zf,betahat,
     &      idum,initrep,mnumrep,nobs,ztz,z,y,sumy,ssqy,fail)
c
c  reads parameters, writes stuff out
c
      implicit real*8(a-h,o-z)
      
      integer fout,fpar,fdat,fmma
      parameter(fpar=19,fdat=20)
      
      
      parameter (kreg=41, maxn=75,maxnf=50)
      
      logical fail,wrpost,prediction
      character*8 nombre
      character*12 name(kreg)
      integer initrep,mnumrep

      real*8 y(maxn),z(maxn,kreg),ztz(kreg,kreg),zsum(kreg),zssq(kreg),
     & yf(maxnf),zf(kreg,maxnf),ztemp(kreg),ytemp,
     & zy(kreg),betahat(kreg),betastd(kreg),zzi(kreg,kreg),p(kreg),split 
c
c  read paremeters
c
      fail = .false.
      open(unit=fpar,file='growth.par')

      read(fpar,10) nombre
 10   format(a8)
      open(unit=fout, file=nombre//'.out')
      open(unit=fdat, file='growth.dat')
      
      call wr_date(fout,.true.,.false.)
      
      call barra('=',55,fout)
      write(fout,15) nombre//'.out'
 15   format('this file is ',a12)
      write(fout,*)
      call barra('-',55,fout)
      read(fpar,*) idum
      if (idum.gt.0) idum=-idum
      write(fout,*) '.. random seed ......................',idum
      write(*,*)    '.. random seed ......................',idum
      read(fpar,*) iprior
      if ((iprior.lt.1).or.(iprior.gt.9)) then
      write(*,*)    'ERROR: iprior must be between 1 and 9!!!'
      write(fout,*) 'ERROR: iprior must be between 1 and 9!!!'
      close(fout)
      stop
      endif
      write(fout,*) '.. prior ............................',iprior
      write(*,*)    '.. prior ............................',iprior
      read(fpar,*) initrep
      write(fout,*) '.. burn-in draws ....................',initrep
      write(*,*)    '.. burn-in draws ....................',initrep
      read(fpar,*) mnumrep
      write(fout,*) '.. mc3 draws.........................',mnumrep
      write(*,*)    '.. mc3 draws.........................',mnumrep
      read(fpar,*) nobs
      write(fout,*) '.. Total nobs.........................',nobs
      write(*,*)    '.. Total nobs.........................',nobs
      read(fpar,18) prediction
      read(fpar,*) split
      write(fout,16) split*100.0d0,(1.0d0-split)*100.0d0
      write(*,16)    split*100.0d0,(1.0d0-split)*100.0d0
      
 16   format(' .. split.............................',f6.2,'/',f6.2,'%')
      read(fpar,18) wrpost
18    format(l1)

      if (wrpost) open(unit=fmma, file=nombre//'.mma')
          
      close(fpar)
c
c
      do 20 i=1,kreg
      read(fdat,'(a12)') name(i)
 20   enddo

c
c  init stuff
c 
      sumy = 0.0d0
      ssqy = 0.0d0
      do 50 j=1,kreg
         zsum(j) = 0.0d0
         zssq(j) = 0.0d0
 50   enddo
c
c  Read data
c   
      nnobs = 0
      nf = 0
      do 100 i=1,nobs
         read(fdat,'(7f14.6)') ytemp,(ztemp(j), j=1,kreg)
         if (ran2(idum).lt.split) then
            nnobs = nnobs + 1
            y(nnobs)   = ytemp
            do 91 j=1,kreg
               z(nnobs,j) = ztemp(j)
  91        enddo
            sumy = sumy + y(nnobs)
            ssqy = ssqy + y(nnobs)**2
            do 70 j=1,kreg
               zsum(j) = zsum(j) + z(nnobs,j)
               zssq(j) = zssq(j) + z(nnobs,j)**2
 70         enddo
         else
            nf = nf + 1
               yf(nf)   = ytemp
            do 95 j=1,kreg
               zf(j,nf) = ztemp(j)
 95         enddo
          endif
 100  enddo
      close(fdat)

      nobs = nnobs
      write(*,*) '.. nobs...............................',nobs
      write(*,*) '.. nf.................................',nf
      write(fout,*) '.. nobs...............................',nobs
      write(fout,*) '.. nf.................................',nf
      call barra('=',55,fout)
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  compute means
c
      sumy = sumy/dble(nobs)
      ssqy = ssqy - dble(nobs)*sumy**2
      do 110 j=1,kreg
         zsum(j) = zsum(j)/dble(nobs)
         zssq(j) = zssq(j)/dble(nobs) - zsum(j)**2
110   enddo
 
 
      write(fout,*)
      write(fout,114) 
 114  format(t35,'mean        std')
      call barra('_',55,fout)
      write(fout,120) sumy,dsqrt(ssqy/dble(nobs))
      write(fout,*)
      do 115 j=1,kreg
         write(fout,122) j,name(j),zsum(j),dsqrt(zssq(j))
 115  enddo
 120  format('dep variable..... growth',t31,2g12.4)
 122  format('beta(',i2,').. ',a12,t31,2g12.4)
      write(fout,*)
      call barra('_',55,fout)
      write(fout,*)
c
c  de-mean z's
c
      do 190 i=1,nobs
c      y(i) = y(i) - sumy
         do 190 j=1,kreg
 190  z(i,j) = (z(i,j) - zsum(j))
c                                /dsqrt(zssq(j))
      
c
c  De-mean Z_f's
c
      do 192 i=1,nf
         do 191 j=1,kreg
 191  zf(j,i) = zf(j,i) - zsum(j)
 192  enddo
      
c
c  construct z'z -> ztz
c      
      do 500 i=1,kreg
         do 400 j=1,kreg
            ztz(i,j) = 0.0d0
            do 300 k=1,nobs
               ztz(i,j) = ztz(i,j) + z(k,i)*z(k,j)
 300        enddo
 400     enddo
 500  enddo
c
c
c
      do 530 j=1,kreg
         zy(j) = 0.0d0
         do 530 i=1,nobs
 530   zy(j) = zy(j) + z(i,j)*y(i)
c
      call choldc(ztz,kreg,kreg,p,fail)
      if (fail) then
         write(fout,*) 'setup: Z''Z is singular!!'
         return
      endif
      call cholsl(ztz,kreg,kreg,p,zy,betahat)
      
      s2 = 0.0d0
      do 550 i=1,nobs
        zbeta = 0.0d0
        do 540 j=1,kreg
 540    zbeta = zbeta + z(i,j)*betahat(j)
        s2 = s2 + (y(i) - sumy - zbeta)**2
 550  enddo
      s2 = s2/dble(nobs-kreg)
            
      do 601 i=1,kreg
        do 600 j=1,kreg
 600    zzi(i,j) = 0.0d0
 601  zzi(i,i) = 1.0d0
 
      do 610 j=1,kreg
 610  call cholsl(ztz,kreg,kreg,p,zzi(1,j),zzi(1,j))
      
      write(fout,*)   
      write(fout,*) 'full-model ols estimates'
      write(fout,*) 
      write(fout,612)
 612  format(t33, 'estimate       s.e.')
      call barra('_',55,fout)
      write(fout,620) sumy, s2
      write(fout,*) 
      do 615 j=1,kreg
	    betastd(j) = dsqrt(s2*zzi(j,j))
            write(fout,622) j,name(j),betahat(j),betastd(j)
 615  enddo
 620  format('                  intercept',t31,2g12.4)
 622  format('beta(',i2,').. ',a12,t31,2g12.4)
      call barra('_',55,fout)
      
      return
      end
c
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c      
      subroutine wrChaInfo(regname, visits,midx,bstar,g0j,
     &      imax,nvout,ibm,icut,indx,fout,fail)

      implicit real*8(a-h,o-z)
      parameter(kreg=41,maxm=350000,thres=1.0d-1)
      
      logical fail

      integer model(kreg),indx(maxm),ir(kreg),fout
      real*8 visits(maxm),beta(kreg),bb(kreg),bbb(kreg),
     &      bstar(kreg,maxm),g0j(maxm),midx(maxm)
     
      character*12 regname(kreg)

      fail = .false.

      write(*,*) '...wrChaInfo: visited models ...'      
c     
c  Write chain info: Visited Models
c
      write(*,*) '...wrChaInfo:'
      write(fout,*)
      write(fout,*) 'MODELS'
      write(fout,*)
      write(*,410) imax
      write(fout,410) imax
  410 format('Number of Models Visited is: ', i8)
      write(fout,*)
      if (nvout.gt.0) write(fout,*) nvout,' Visits Out!!!'            
c
c  Sort according to number of visits w/ auxiliary array indx
c  
      write(*,*) '...wrChaInfo: sorting ...'      
      write(*,*) 'imax',imax
      call indexx(imax,visits,indx)
      tot=0.0d0      

      write(fout,*)
      call barra('-',70,fout)
      cumass_1 = 0.0d0
      do 420 i=1,imax
         cumass = cumass_1 + visits(indx(imax+1-i))
c         if ((cumass_1.lt.0.75).and.(cumass.ge.0.75)) then
c         endif
         if (mod(i,imax/10) .eq. 0) write(fout,421) i,cumass*100.0d0
	 if ((cumass_1.lt.0.9).and.(cumass.ge.0.9)) then
         icut=i
	 write(fout,422) i,cumass*100.0d0
	 endif
	 cumass_1=cumass
 420  enddo
      
      if (mod(imax,10).ne.0) write(fout,421) imax,cumass*100.0d0
 421  format('Best ',i6,' models account for ',f8.4,' % of mass')
 422  format('Best ',i6,' models account for ',f8.4,
     &             ' % of mass (=> 90%)')
      call barra('-',70,fout)
      write(fout,*)
                   
      write(fout,'(a33,t45,e12.4,x,a1)')
     &    'Prior Prob for a single model is',
     &     (1.0d0/dble(2.0d0**kreg))*100.0d0,'%'
         
      write(fout,'(a41,t45,f8.4,x,a1)') 
     &     'Models with Post Probability larger than',thres,'%'

      write(fout,*)
      call barra('-',70,fout)
      write(fout,*)
      write(fout,*) '   PostProb        Regressors'
      call barra('-',70,fout)
            
      do 455 i=1,kreg
 455  beta(i) = 0.0d0
      spanmass = 0.0d0
      polmass = 0.0d0
            
      j=0
      do 500 i=0,imax-1
         j=j+1
         percvisits = visits(indx(imax-i))*100.0d0
         call gmodel(midx(indx(imax-i)), kreg, model)
         call ireg2(kreg,model,ir,kj)
               
         do 460 ib=1,kj
 460        beta(ir(ib)) = beta(ir(ib)) + percvisits
               
         if (percvisits.ge.thres) then
            tot = tot + percvisits
            write(fout,467) j, percvisits,(ir(k),k=1,kj)
 467        format(i3,t5,f6.2,'%',x,'|',100(:i3))
         endif
c
c  (Span and LatAm)  & (PolRights and Civil Liberties)
c
         if ((model(16).eq.1).and.(model(38).eq.1)) then
           spanmass = spanmass+percvisits
         endif
         if ((model(22).eq.1).and.(model(23).eq.1)) then
           polmass = polmass+percvisits
         endif

 500  enddo
      
      write(fout,*)
      write(fout,510) tot
 510  format(t4,f6.2,'%')
      write(fout,*)
      call barra('-',70,fout)
c  
      write(*,*) '...Collinear Vars...' 
      write(fout,*)
      write(fout,520) spanmass
      write(fout,521) polmass
 520  format('Spanish Colony & LatAm...',e10.2,'%')
 521  format('PolRights & Civil Lib....',e10.2,'%')
      write(fout,*)

      call barra('-',70,fout)
c  
      write(*,*) '...wrChaInfo: best model ...'      

      indice = indx(imax)
      ibm = indice
      
      call gmodel(midx(indice), kreg, model)
      call ireg2(kreg,model,ir,kj)
      
      do 550 j=1,kreg
 550  bb(j) = 0.0d0
      do 555 j=1,kj
      bb(ir(j)) = bstar(j,indice)/(1.0d0 + g0j(indice) )
 555  continue
c
c store next best-model betas in bbb()
c  
      if (imax.gt.1) then
      indice = indx(imax-1)
      
      call gmodel(midx(indice), kreg, model)
      call ireg2(kreg,model,ir,kj)
      
      do 556 j=1,kreg
      bbb(j) = 0.0d0
 556  continue

      do 557 j=1,kj
 557  bbb(ir(j)) = bstar(j,indice)/(1.0d0 + g0j(indice) )
      endif
c
c  Post Probability of Incl: Regressors
c            
      write(fout,*)
      write(fout,590) 
 590  format('Post Prob of Incl and 2 Best Models m_j''s')
      call barra('_',70,fout)
      write(fout,*)
      do 600 i=1,kreg
 600  write(fout,610) i,regname(i),beta(i),bb(i),bbb(i)
 610  format(' Beta(',i2,')..',a12,2x,f7.2,' %',2x,2g14.4)
      write(fout,*)
      call barra('=',70,fout)
                         
      return
      end
c
c-----------------------------------------------------------------------
c
      subroutine wrPostInfo(nobs,ztz,z,bhat,
     &      visits,g0j,dstar,bstar,midx, 
     &      imax,ibm,fmma,fail)

      implicit real*8(a-h,o-z)
      parameter(kreg=41,maxm=350000,nbins=50,maxn=75)
      
      logical fail,boundsfixed

      integer model(kreg),ir(kreg),fmma,ir2(kreg)
      
      real*8 visits(maxm),beta(kreg),ztz(kreg,kreg),
     &      ztzj(kreg,kreg),z(maxn,kreg),zj(maxn,kreg),
     &      zj2(maxn,kreg),ztzj2(kreg,kreg),
     &      csj(maxn),csjx(kreg),csjx2(kreg),p(kreg),bc(nbins,kreg),
     &      bstar(kreg,maxm),dstar(maxm),midx(maxm),
     &      bmin(kreg),bmax(kreg),binc(kreg),height(kreg),
     &      varb(kreg,maxm),g0j(maxm),bmc(nbins,kreg),bhat(kreg)
           
      real*8 zst,bst,ast,studt1
      integer nust
      studt1(zst,nust,bst,ast) =
     & (dexp(gammln(0.5d0*(1.d0+nust))-gammln(0.5d0*nust))
     & /dsqrt(3.14159265358979d0*nust*ast))/
     & (1.d0+((zst-bst)**2)/(nust*ast))**(0.5d0*(1.d0+nust))

c
      fail = .false.
 
      do 20 j=1,kreg
        bmin(j) = bhat(j)
        bmax(j) = bhat(j)
	height(j) = 0.0d0
  20  enddo

            
      do 455 i=1,kreg
 455  beta(i) = 0.0d0
            
      do 500 imd=1,imax
         call gmodel(midx(imd), kreg, model)
         call ireg2(kreg,model,ir,kj)
         do 460 ib=1,kj
  460        beta(ir(ib)) = beta(ir(ib)) + visits(imd)
  500  enddo
  
       do 510 i=1,kreg
  510  write(fmma,512) i,beta(i)
  512  format('pbb[',i2,'] = ',f8.4,';')
c
c
      call wr_time(idummy,.false.,.true.)
      write(*,*) '... included betas ...'            
c
c  Posterior Distribution of the Betas
c  
      nu = nobs-1
          
      do 2000 imod=1,imax
      
         vb = dstar(imod)/(dble(nu)*(g0j(imod)+1.0d0))
         
         call gmodel(midx(imod), kreg, model)
         call ireg2(kreg,model,ir,kj)
c
c  for each model construct (Z_j'Z_j) and Z_j
c         
         do 720 j=1,kj
            do 710 i=1,j
 710        ztzj(i,j) = ztz(ir(i),ir(j))
            do 715 i=1,nobs
 715        zj(i,j) = z(i,ir(j))
 720     enddo
         
         k = kj-1
         
         do 1000 jreg=1,kj
	 
	    vvb = vb
                  
            do 805 j=1,jreg-1
 805        ir2(j) = j	    
            do 806 j=jreg,kj
 806        ir2(j) = j+1	    
 
            do 820 j=1,k
               do 810 i=1,j
 810           ztzj2(i,j) = ztzj(ir2(i),ir2(j))
               do 815 i=1,nobs
 815           zj2(i,j) = zj(i,ir2(j))
 820        enddo
 
            do 840 i=1,nobs
 840        csj(i) = zj(i,jreg)
 
            do 880 j=1,k
               csjx(j) = 0.0d0
               do 850 i=1,nobs
 850           csjx(j) = csjx(j) + csj(i)*zj2(i,j)
 880        enddo

            call choldc(ztzj2,k,kreg,p,fail)
            call cholsl(ztzj2,k,kreg,p,csjx,csjx2)
            
            x = 0.0d0
            do 900 j=1,k
 900        x = x + csjx(j)*csjx2(j)
            
	    vvb = vvb/x
	    varb(jreg,imod) = vvb
c
c update beta min and max for posterior plots
c
	       x = g0j(imod)+1.0d0

	       bbmin = bstar(jreg,imod)/x - 4.0d0*dsqrt(vvb)
	       bbmax = bstar(jreg,imod)/x + 4.0d0*dsqrt(vvb)
	       	    
	       if (bbmin.lt.bmin(ir(jreg))) bmin(ir(jreg)) = bbmin
	       if (bbmax.gt.bmax(ir(jreg))) bmax(ir(jreg)) = bbmax
         
 1000    enddo
 
 2000 enddo
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c

      write(*,*) '... posterior distribution of betas: coor 1 ...'      
      call wr_time(idummy,.false.,.true.)

c
c loop again over models and compute coordinates of 
c student's t
c first we do it over a conservative range, then we fix the 
c bounds and do it again
c

      boundsfixed = .false.
      
 2100 continue
       
       do 2110 j=1,kreg
       binc(j) =  (bmax(j) - bmin(j))/dble(nbins)
       if (binc(j).lt.0) write(fmma,*)j,bmin(j),bmax(j),boundsfixed
       do 2110 i=1,nbins
            bc(i,j) = 0.0d0
	    bmc(i,j) = 0.0d0
 2110   enddo

      if (boundsfixed) then
       write(*,*) '... posterior distribution of betas: coor 2 ...'      
      call wr_time(idummy,.false.,.true.)
      endif
c
c loop over models
c
      do 2700 imod=1,imax
	 x = g0j(imod)+1.0d0
         call gmodel(midx(imod), kreg, model)
         call ireg2(kreg,model,ir,kj)
c
c loop over regressors
c        
         do 2500 jreg=1,kj
c
c loop over nbins
c  
            b = bmin(ir(jreg)) + 0.5d0*binc(ir(jreg))
            do 2450 i=1,nbins
               bc(i,ir(jreg)) = bc(i,ir(jreg)) +
     &               studt1(b,nu,bstar(jreg,imod)/x,
     &                            varb(jreg,imod))*visits(imod)
               
 	       b = b + binc(ir(jreg))
 2450       enddo
c
c if the bounds are fixed do it for best model too
c
	    if (boundsfixed .and.(imod.eq.ibm)) then
              b = bmin(ir(jreg)) + 0.5d0*binc(ir(jreg))
	      do 2455 i=1,nbins
                 bmc(i,ir(jreg)) =
     &           studt1(b,nu,bstar(jreg,imod)/x,varb(jreg,imod))
                 b = b + binc(ir(jreg))
 2455           enddo
	    endif
 2500    enddo
 
 2700 enddo
 
      do 2760 j=1,kreg
      do 2760 i=1,nbins
 2760 if (bc(i,j).gt.height(j)) height(j) = bc(i,j)
 
      if (boundsfixed) goto 2999
c
c re-adjust the range for the plots
c 
c
c  start from above for min

      write(*,*) '... posterior distribution of betas: fixin ...'      
      call wr_time(idummy,.false.,.true.)
c
        do 2900 jreg=1,kreg
	
	 umbral =  1.d-5/(nbins*binc(jreg))
	 
         do 2850 i=1,nbins
            if (bc(i,jreg) .gt. umbral) then
               bmin(jreg) = bmin(jreg) + (i-1)*binc(jreg)
               goto 2851
            endif
 2850    enddo
 2851    continue
c
c  start from below for max
c 
         do 2860 i=nbins,1,-1
            if (bc(i,jreg) .gt. umbral) then
               bmax(jreg) = bmax(jreg) - (nbins-i)*binc(jreg)
               goto 2861
            endif
 2860    enddo
 2861    continue
 
 2900    enddo
 
         boundsfixed = .true.
         goto 2100

 2999    continue

      write(*,*) '... posterior distribution of betas: wr coor ...'      
      call wr_time(idummy,.false.,.true.)
c
c  output the coordinates
c 
      do 3000 jreg=1,kreg
      
         if (beta(jreg) .gt. 0) then
	 
            b = bmin(jreg) + 0.5d0*binc(jreg)
c
c  correct by dividing by mass
c
            write(fmma,3400) jreg
            do 2750 i=1,nbins-1
               write(fmma,3500) b,bc(i,jreg)/beta(jreg)
               b = b + binc(jreg)
 2750       enddo
            write(fmma,3501) b,bc(nbins,jreg)
c
c best-model coordinates
c
            b = bmin(jreg) + 0.5d0*binc(jreg)
         
            write(fmma,3401) jreg
            do 2755 i=1,nbins-1
               write(fmma,3500) b,bmc(i,jreg)
               b = b + binc(jreg)
 2755       enddo
            write(fmma,3501) b, bmc(nbins,jreg)
         else
            write(fmma,*) 'beta[',jreg,'] = {{0,0}};'
            write(fmma,*) 'bbeta[',jreg,'] = {{0,0}};'
         endif
 3000 enddo
 
 3400 format('beta[',i2,'] = {')
 3401 format('bbeta[',i2,'] = {')
 3500 format('{',f15.8,',',f15.8,'},')
 3501 format('{',f15.8,',',f15.8,'}};')
             
      return
      end

c
c-----------------------------------------------------------------------

c-----------------------------------------------------------------------

      subroutine lps(iprior,regname,imax,ibm,nobs,
     &      visits,g0j,dstar,bstar,midx, 
     &      ymean,ssqy,ztz,z,y,nf,yf,zf,fout,fail,mmodel)

c
c This subroutine computes LPS
c      
      implicit real*8(a-h,o-z)
      
      integer fout
     
      parameter(kreg=41,maxm=350000,nbins=50,maxnf=50,maxn=75)
      
      real*8 yf(maxnf),zf(kreg,maxnf),zfj(kreg,maxnf),
     & zfdummy(kreg),yvarfull(maxnf),ymfull(maxnf),
     & z(maxn,kreg),ztz(kreg,kreg), ztzj(kreg,kreg),p(kreg),
     & visits(maxm),y(maxn),g0j(maxm),dstar(maxm),bstar(kreg,maxm),
     & ym(maxnf,maxm),yvar(maxnf,maxm),bstarfull(kreg),fulllps,
     & simlps,yvarsim(maxnf),ymsim(maxnf),midx(maxm),nulllps,yvar2,
     & bstarsim(kreg)

      integer ir(kreg), model(kreg),mmodel(kreg) 
      character*12 regname(kreg)
             
      logical fail
      
      real*8 zst,bst,ast,studt1
      integer nust

      studt1(zst,nust,bst,ast) =
     & (dexp(gammln(0.5d0*(1.d0+nust))-gammln(0.5d0*nust))
     & /dsqrt(3.14159265358979d0*nust*ast))/
     & (1.d0+((zst-bst)**2)/(nust*ast))**(0.5d0*(1.d0+nust))
     
      fail = .false.
           
      nu = nobs-1
      yvar2=ssqy/dble(nu)
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  full model 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c FULL
c
      do 100 j=1,kreg
 100  model(j) = 1
       
      call computefj(iprior,model,nobs,ztz,z,y,ssqy,
     &      kjfull,gjfull,dstarfull,bstarfull,fjfull,fail)
        if (fail) then
          write(fout,*) 'Fail in LPS()...Full...computefj'
          return
        endif
      call ireg(kreg,model,ir)
      call choldc(ztz,kreg,kreg,p,fail)
      if (fail) then
        write(fout,*) 'Fail in LPS()...Full...choldc'
        return
      endif
c     
c loop over observations to be predicted: i_f=1..nf
c
      do 150 i_f=1,nf
         call cholsl(ztz,kreg,kreg,p,zf(1,i_f),zfdummy)
         zzz = 0.0d0
         do 125 j=1,kreg
 125     zzz = zzz + zf(j,i_f)*zfdummy(j)
         zzz = 1.d0+1.d0/nobs+ zzz/(1.d0+gjfull)
         yvarfull(i_f) = zzz*dstarfull/(nobs-1.d0)

         yyy = 0.0d0
         do 140 j=1,kreg
 140     yyy = yyy + zf(j,i_f)*bstarfull(j)
         ymfull(i_f) = ymean + yyy/(1.d0+gjfull)
 150  enddo
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c Best Among SiM
c
      do 101 j=1,kreg
 101  model(j) = mmodel(j)
c
c  Obtain bstar, dstar, etc.  
c
      call computefj(iprior,model,nobs,ztz,z,y,ssqy,
     &      kjsim,gjsim,dstarsim,bstarsim,fjsim,fail)
      if (fail) then
        write(fout,*) 'Fail in LPS()...SiM...computefj'
        return
      endif
c
c Obtain, ir() for this model:
c      
      call ireg(kreg,model,ir)
c
c  Select the kj regressors specified in ir() from Z'Z and Z_f
c  Also substract sample averages of Z_j's to the Z_{f,j}'s.
c
         do 120 j=1,kjsim
            do 115 i=1,j
               ztzj(i,j) = ztz(ir(i),ir(j))
 115         enddo
c
c remember that zf is transposed
c
            do 117 i=1,nf
 117         zfj(j,i)  = zf(ir(j),i)
 120      enddo
c
      call choldc(ztzj,kjsim,kreg,p,fail)
      if (fail) then
        write(fout,*) 'Fail in LPS()...SiM...choldc'
        return
      endif
c     
c loop over observations to be predicted: i_f=1..nf
c
      do 151 i_f=1,nf
         call cholsl(ztzj,kjsim,kreg,p,zfj(1,i_f),zfdummy)
         zzz = 0.0d0
         do 126 j=1,kreg
 126     zzz = zzz + zfj(j,i_f)*zfdummy(j)
         zzz = 1.d0+1.d0/nobs+ zzz/(1.d0+gjsim)
         yvarsim(i_f) = zzz*dstarsim/(nobs-1.d0)

         yyy = 0.0d0
         do 141 j=1,kreg
 141     yyy = yyy + zfj(j,i_f)*bstarsim(j)
         ymsim(i_f) = ymean + yyy/(1.d0+gjsim)
 151  enddo
 
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      write(*,*) '... looping over models ...',imax
      
      do 1000 imd = 1,imax
      
c
c First, generate model, get kj and ir()
c            
         call gmodel2(midx(imd),kreg,model,kj,ir)
c
c  Select the kj regressors specified in ir() from Z'Z and Z_f
c  Also substract sample averages of Z_j's to the Z_{f,j}'s.
c
         do 20 j=1,kj
            do 15 i=1,j
               ztzj(i,j) = ztz(ir(i),ir(j))
 15         enddo
            do 17 i=1,nf
c
c  zmean must be substracted from zf() if not done above
c
 17         zfj(j,i)  = zf(ir(j),i)
 20      enddo
c
c  Compute Cholesky dcmp of (Z_j'Z_j)
c 
         call choldc(ztzj,kj,kreg,p,fail)
         if (fail) then
            write(fout,*) (ir(j),j=1,kj)
            do 21 i=1,kj
 21         write(fout,22) (ztzj(i,j),j=1,i)
 22         format(29(:f10.2))
            write(16,*) '...fail choldc @ PREDICT...'
            return
         endif
c      
c  Loop over columns of Z'_{f,j} w/ cholsl to obtain
c  (Z'_j Z_j)^{-1} Z'_{f,j}
c
c
c loop over observations to be predicted: i_f=1..nf
c
         do 200 i_f=1,nf
            call cholsl(ztzj,kj,kreg,p,zfj(1,i_f),zfdummy)
            zzz = 0.0d0
            do 25 j=1,kj
 25         zzz = zzz + zfj(j,i_f)*zfdummy(j)
c
c  Premultiply by  Z_{f,j} to get
c  zzz <-- Z_{f,j} (Z'_j Z_j)^{-1} Z'_{f,j}
c
            zzz = 1.d0+1.d0/nobs+ zzz/(1.d0+g0j(imd))
            yvar(i_f,imd) = zzz*dstar(imd)/(nobs-1.d0)

            yyy = 0.0d0
            do 40 j=1,kj
 40         yyy = yyy + zfj(j,i_f)*bstar(j,imd)
            ym(i_f,imd) = ymean + yyy/(1.d0+g0j(imd))
	 
  
 200     enddo
 1000 continue
c     
c loop over yf's for BMA and Best Model's predictive densities
c

      call wr_time(fout,.false.,.true.)
      write(*,*) '... looping over nf: ',nf
      
      avelps = 0.0d0
      bestlps = 0.0d0
      fulllps = 0.0d0
      simlps = 0.0d0
      nulllps=0.0d0
      
      do 3400 i_f = 1,nf
         	 
         xlps = 0.0d0
      
 1100    continue 
  
         do 1200 imd=1,imax
      
c
c  Compute LPS ---only on first pass----
c                
           xlps = xlps +  visits(imd)*
     &            studt1(yf(i_f),nu,ym(i_f,imd),yvar(i_f,imd))

 1200    enddo
 
	 bestlps = bestlps - 
     &            dlog(studt1(yf(i_f),nu,ym(i_f,ibm),yvar(i_f,ibm)))  
	 fulllps =fulllps-
     &   	   dlog(studt1(yf(i_f),nu,ymfull(i_f),yvarfull(i_f)))  
	 simlps =simlps-
     &   	   dlog(studt1(yf(i_f),nu,ymsim(i_f),yvarsim(i_f))) 

       nulllps = nulllps - dlog(studt1(yf(i_f),nu,ymean,yvar2)) 
        
	 avelps = avelps - dlog(xlps)
          
 3000    continue
 
 3400 enddo

      avelps  = avelps/dble(nf)
      bestlps = bestlps/dble(nf)
      fulllps = fulllps/dble(nf)
      nulllps = nulllps/dble(nf)

      simlps  = simlps/dble(nf)
      
      write(fout,*)
      write(fout,*) 'LPS with ',nf,' observations'
      write(fout,*)
      write(fout,3410) avelps
      write(fout,3411) bestlps
      write(fout,3412) simlps
      write(fout,3413) fulllps
      write(fout,3414) nulllps
      write(fout,*)
 3410 format('BMA LPS............',g18.8)
 3411 format('Best-Model LPS.....',g18.8)
 3412 format('Best-SiM-Model LPS.',g18.8)
 3413 format('Full-Model LPS.....',g18.8)
 3414 format('Null-Model LPS.....',g18.8)
c
      call wr_time(fout,.false.,.true.)
c      
      return
      end
c
c
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c
      subroutine computefj(iprior,model,nobs,ztz,z,y,ssqy,
     &      kj,g0j,dstar,bstar,fj,fail)
c
c
c  For the choice of prior (1-9), see:
c   
c  C. Fernandez, E. Ley and Mark F.J. Steel (2001):
c "Benchmark priors for Bayesian Model Averaging" 
c  Journal of Econometrics, 100:2 (February), 381-427.
c
c
c
      implicit real*8(a-h,o-z)
     
      parameter(kreg=41,maxn=75)
	  
      real*8 p(kreg),ztz(kreg,kreg),z(maxn,kreg),y(maxn)
      real*8 ztzj(kreg,kreg),zj(maxn,kreg),zy(kreg), bstar(kreg)
      integer iprior,model(kreg),ir(kreg)
      logical fail
c      
      fail = .false.

      dn  = dble(nobs)
      
      kj = icard(kreg,model)
      if (kj.eq.0) then
         fj =  - 0.5d0*(dn-1.d0)*dlog(ssqy)
         g0j = 1.d250
         return
      endif
      call ireg(kreg,model,ir)
c
c  kj is the total number of regressors included (excl intercept)
c  ir() contains the list of regressors (excluding intercept)
c
c  Select the kj regressors specified in ir()
c  We only need the upper part of ztzj
c
      do 20 j=1,kj
         do 10 i=1,j
 10      ztzj(i,j) = ztz(ir(i),ir(j))
         do 15 i=1,nobs
 15      zj(i,j) = z(i,ir(j))
 20   enddo

c since the Z's have mean 0: 
c
c y'X (X'X)^{-1} X'y = ((\sum y)^2)/n + y'Z bstar
c
c  Compute y'Z_j (Z_j'Z_j)^{-1} Z_j'y by computing the Cholesky
c  decomposition of (Z'_{(j)} Z'_{(j)}) and solving 
c  bstar = (Z_j'Z_j)^{-1} Z_j'y         by backsubstitution
c
      call choldc(ztzj,kj,kreg,p,fail) 
      if (fail) return

      do 30 j=1,kj
         zy(j) = 0.0d0
         do 30 i=1,nobs
 30   zy(j) = zy(j) + zj(i,j)*y(i)
c
c       (X_j'X_j)^{-1} X'_j y
c       = (\bar y, (Z_j'Z_j)^{-1} Z'_j y) =
c       = (\bar y, \beta^*_j)'
c 
      call cholsl(ztzj,kj,kreg,p,zy,bstar)
c
c ssqy = nobs * var(y) = y'y - ((y'1)**2)/nobs
c      
      ymzjy = ssqy
      do 40 j=1,kj
 40   ymzjy = ymzjy - zy(j)*bstar(j)
c
c Different priors and stuff...
c
      dkj = dble(kj)
      
      if (iprior.eq.1) then
         g0j = 1.0d0/dn
       elseif (iprior.eq.2) then
         g0j = dkj/dn
       elseif (iprior.eq.3) then
         g0j = (dble(kreg)**(1.0d0/dkj))/dn
       elseif (iprior.eq.4) then
          g0j = dsqrt(dkj/dn)	 
       elseif (iprior.eq.5) then
         g0j = (dlog(dn))**(-3)
       elseif (iprior.eq.6) then
         g0j = dlog(kj+1.0d0)/dlog(dn)
       elseif (iprior.eq.7) then
         aux = 0.15411d0*0.64889d0**(1.0d0/dkj)
         g0j = aux/(1.0d0 - aux)
       elseif (iprior.eq.8) then
         g0j = 1.0d0/dsqrt(dn)
       elseif (iprior.eq.9) then
         g0j = 1.0d0/dble(kreg**2)
      endif
      
      aux1 = 1.0d0/(1.0d0 + g0j)
      aux2 = 1.0d0 - aux1
      aux3 = 0.5d0*dkj*dlog(aux2)
         
      dstar = aux1*ymzjy + aux2*ssqy
c
c finally log(F(j))
c
      fj = aux3 - 0.5d0*(dn-1.d0)*dlog(dstar)
            
      return
      end
c
c-----------------------------------------------------------------------
c
      subroutine runChain(iprior,idum,initrep,mnumrep,nobs,
     &      ztz,z,y,ssqy,
     &      visits,fjlog,g0j,dstar,bstar,midx,kj,
     &      imax,nvout,fout,fail,fjout,mmodel,fjsum)

c
      implicit real*8(a-h,o-z)
      integer fout
      parameter(kreg=41,maxn=75,maxm=350000,maxm2=5000)

      logical fail, move, visited, evaluated
      
      real*8 midx(maxm),idxstack(maxm2),idxold,idxnew
      
      integer model(kreg), mc(kreg),kj(maxm),kjstack(maxm2),
     & mmodel(kreg)

      real*8 z(maxn,kreg), y(maxn), ztz(kreg,kreg),
     &      visits(maxm),fjlog(maxm),g0j(maxm),dstar(maxm),
     &      bstar(kreg,maxm),bstarfj(kreg),bstarfjold(kreg),
     &      fjstack(maxm2),g0jstack(maxm2),dstarstack(maxm2),
     &      bstarstack(kreg,maxm2)
       
      fail = .false.
      fjout = 0.0d0
      nvout = 0
c     
c-----------------------------------------------------------------------
c  RUN MC3
c-----------------------------------------------------------------------
c 1. START THE CHAIN
c-----------------------------------------------------------------------
c
c  Generate one model at random
c 
      idxold =  (ran2(idum)*(2.0d0**kreg) + 1.0d0)
      
      call gmodel(idxold,kreg,model)
      write(fout,*) 
      write(fout,10) idxold
 10   format('Starting Model is:',i15)
      write(fout,*) 
      do 15 i=1,kreg
 15   write(fout,16) i,model(i)
 16   format(2i5)
      write(fout,*)
      call computefj(iprior,model,nobs,ztz,z,y,ssqy,
     & kjfjold,g0jfjold,dstarfjold,bstarfjold,fjold,fail)
      if (fail) then
      write(fout,*) 'start of chain: Fail in computefj!'
      return
      endif
c
c start storing from the bottom of the stack
c     
      idxstack(maxm2) = idxold
      fjstack(maxm2) = fjold
      kjstack(maxm2) = kjfjold
      g0jstack(maxm2) = g0jfjold
      dstarstack(maxm2) = dstarfjold
      do 260 j=1,kjstack(maxm2)
 260  bstarstack(j,maxm2) = bstarfjold(j)
c
c  Initialize the chain ---run for initrep repetitions---
c 
      write(*,*) '... initializing Chain ... '
c      
c  flush all values in stack!
c		  
      nmv2 = 1

      do 8090 init=1,initrep
                  
         call mcand(kreg,model,mc,idum)
c     
c   get model index
c 
         evaluated = .false.
         
         idxnew = getmodidx(kreg,mc)
         if (idxnew.eq.idxold) goto 8090
c
c  see if it is stored in the stack
c
          imin = maxm2-(nmv2-1)
          do 7010 i = imin, maxm2
               if (idxnew.eq.idxstack(i)) then
                  evaluated = .true.
                  fjnew = fjstack(i)
                  index = i
                  goto 7299
               endif
 7010     enddo
 
 7299    continue
c
c  if it was not stored, then compute fj and other stuff
c
         if (.not. evaluated) then
	   
            call computefj(iprior,mc,nobs,ztz,z,y,ssqy,
     &            kjfj,g0jfj,dstarfj,bstarfj,fjnew,fail)
     
      if (fail) then
      write(fout,*) init,'warm-up: Fail in computefj!'
      return
      endif
c     
c  store it for future use.  
c  start storing from the bottom of stack to the top,
c  when full, flush the bottom
c
            if (nmv2.lt.maxm2) then
               nmv2 = nmv2+1
               index = maxm2-(nmv2-1)
            else
               do 7350 i=maxm2,2,-1
                  idxstack(i) = idxstack(i-1)
                  fjstack(i) = fjstack(i-1)
                  kjstack(i) = kjstack(i-1)
                  g0jstack(i) = g0jstack(i-1)
                  dstarstack(i) = dstarstack(i-1)
                  do 7340 j=1,kjstack(i-1)
 7340             bstarstack(j,i) = bstarstack(j,i-1)
 7350          continue
               index = 1
            endif
	    
            idxstack(index) = idxnew
            fjstack(index) = fjnew
            kjstack(index) = kjfj
            g0jstack(index) = g0jfj
            dstarstack(index) = dstarfj
            do 7360 j=1,kjstack(index)
 7360       bstarstack(j,index) = bstarfj(j)
         endif
c     
c end of stuff when evaluated was false
c

c
c  see if chain moves to new model
c
         dif = fjnew-fjold
	 
         if (dif .ge. 0.d0) then
            move = .true.
         elseif (dif.ge.dlog(ran2(idum)))  then
            move = .true.
         else
            move = .false.
         endif
	 
         if (move) then
	    do 8000 i=1,kreg
 8000       model(i) = mc(i)
            fjold = fjnew
            idxold = idxnew
            indexstack = index
         endif
	 
 8090 continue              
c
c Here is the first model visited:
c
      nmv  = 1
      imod = 1

      visits(imod) = 1.0d0
      midx(imod) = idxold
      fjlog(imod) = fjold
      kj(imod) = kjstack(indexstack)
      g0j(imod) = g0jstack(indexstack)
      dstar(imod) = dstarstack(indexstack)
      do 8092 j=1,kj(imod)
 8092 bstar(j,imod) = bstarstack(j,indexstack)
      
      do 8095 i=2,maxm
 8095 visits(i) = 0.0d0

      call wr_time(fout,.true.,.true.)
c
c-----------------------------------------------------------------------
c  2. RUN THE CHAIN
c-----------------------------------------------------------------------
c             
      write(*,*) '... running Chain ... '

      numrep = 1
      fjlogmean = fjold
      
 8100 numrep = numrep + 1
c     
c     pick candidate
c 
      call mcand(kreg,model,mc,idum)
c     
c   get model index
c 
      idxnew = getmodidx(kreg,mc)
      if (idxnew.eq.idxold) goto 8500
      
      visited   = .false.
      evaluated = .false.
c     
c see if it is an already _visited_ model 
c                  
      do 8200 i=1, min(nmv,maxm)
         if (idxnew.eq.midx(i)) then
            visited = .true.
            evaluated = .true.
            fjnew = fjlog(i)
            index = i
            goto 8299
         endif
 8200 enddo
c     
c otherwise see if it is an already _evaluated_ model
c
      if (nmv2.ge.1) then
         do 8210 i = maxm2-(nmv2-1), maxm2
            if (idxnew.eq.idxstack(i)) then
               evaluated =.true.
               fjnew = fjstack(i)
               index = i
               goto 8299
            endif
 8210    enddo
      endif
            
 8299 continue
c     
c  if we don't have logFj stored, then compute it
c
      if (.not. evaluated) then
         call computefj(iprior,mc,nobs,ztz,z,y,ssqy,
     &         kjfj,g0jfj,dstarfj,bstarfj,fjnew,fail)
      if (fail) then
      write(fout,*) numrep,'Chain: Fail in computefj!'
      return
      endif
      endif
c     
c     move?
c
      dif = fjnew-fjold
      
      if (dif .ge. 0.0d0) then
         move = .true.
      elseif (dif.ge.dlog(ran2(idum)))  then
         move = .true.
      else
         move = .false.
      endif
c
c
c
      if (move) then
               
         do 8300 i=1,kreg
 8300    model(i) = mc(i)
         fjold  = fjnew
         idxold = idxnew

         if (visited) then
            imod = index
            goto 8500
         else
            nmv = nmv+1
            if (nmv.le.maxm) then
               imod = nmv
               midx(imod) = idxnew
               fjlog(imod) = fjnew
               fjlogmean = fjlogmean + fjnew
            else
               nvout = nvout + 1
               fjout =fjout + dexp(fjnew)
	       goto 8501
            endif
         endif
c
c  we get to the next IF when we wanna move _and_ there is 'room'
c  to move
c
         if (evaluated) then
c
c   move stuff from "evaluated" stack to "visited" stack
c      
            kj(imod) = kjstack(index)
            g0j(imod) = g0jstack(index)
            dstar(imod) = dstarstack(index)
            do 8310 j=1,kj(imod)
 8310       bstar(j,imod) = bstarstack(j,index)
         else
c
c   if (.not. evaluated) computeFj was called above and now
c   we can store stuff in "visited" stack
c 
            kj(imod) = kjfj
            g0j(imod) = g0jfj
            dstar(imod) = dstarfj
            do 8312 j=1,kj(imod)
 8312       bstar(j,imod) = bstarfj(j)
         endif
c
c  don't move and model not evaluated before
c            
      elseif (.not. evaluated) then
c
c  store in "evaluated" stack
c 
         if (nmv2.lt.maxm2) then
            nmv2 = nmv2+1
            index = maxm2-(nmv2-1)
         else
c     
c when stack is full, disregard value at bottom, move everyone
c 1 position downwards and store new value at top
c
            do 8350 i=maxm2,2,-1
               idxstack(i) = idxstack(i-1)
               fjstack(i) = fjstack(i-1)
               kjstack(i) = kjstack(i-1)
               g0jstack(i) = g0jstack(i-1)
               dstarstack(i) = dstarstack(i-1)
               do 8340 j=1,kjstack(i-1)
 8340          bstarstack(j,i) = bstarstack(j,i-1)
 8350       continue
            index = 1
         endif
         idxstack(index) = idxnew
         fjstack(index) = fjnew
         kjstack(index) = kjfj
         g0jstack(index) = g0jfj
         dstarstack(index) = dstarfj
         do 8360 j=1,kjstack(index)
 8360    bstarstack(j,index) = bstarfj(j)
      endif
c     
 8500 visits(imod) = visits(imod) + 1.0d0
c
c we get directly to 8501 when the visited-models stack was full
c
 8501 continue
      if (numrep.lt.mnumrep) goto 8100
c
c-----------------------------------------------------------------------
c  end of chain loop
c-----------------------------------------------------------------------
c                                 
      imax = min(maxm,nmv)
      fjlogmean = fjlogmean/dble(imax)
c
c-----------------------------------------------------------------------
c  let's get the BayesF of SiM's models
c-----------------------------------------------------------------------

      call SalaModels(fout,fjlogmean,imax,midx,
     &         iprior,nobs,ztz,z,y,ssqy,bstarfj,
     &         jsim,fjsimmax,fjsim,dblecount,mmodel)

c-----------------------------------------------------------------------
c  let's do the accounting...
c-----------------------------------------------------------------------
c
      
      fjsum = 0.0d0
c
c  when we visit models for which we have no room in the
c  visited-models stack we still want [sum fjlog(i)] = 1;
c  we thus comment out the following line
c
c      if (nvout.gt.0) fjsum = fjout/dexp(fjlogmean)
c
c fjout = sum dexp() already
c
      fjout = fjout/exp(fjlogmean)

      do 9000 i=1,imax
         fjlog(i) = dexp(fjlog(i) - fjlogmean)
         fjsum = fjsum + fjlog(i)
         visits(i) = visits(i)/dble(mnumrep-nvout)
 9000 enddo
      
       fjsimmax=dexp(fjsimmax-fjlogmean)/(fjsum-dblecount+fjsim)                                            
       fjsim = fjsim                    /(fjsum-dblecount+fjsim)
       
       write(fout,*) '*---------------------------------------------*'
       write(fout,*)                                                        
       write(fout,*) 'Post Prob of the ',jsim,' SiM AER Models:'              
       write(fout,'(g24.6,a2)') fjsim*100.0d0, '%'
       write(fout,*)
       write(fout,*) 'Max Post Prob among them is:'                                                        
       write(fout,'(g24.6,a2)') fjsimmax*100.0d0,'%'
       write(fout,*)
       write(fout,*) 'Model is:'
       do 9001 i=1,kreg
       write(fout,'(2i4)') i,mmodel(i)
 9001  enddo
       write(fout,*)
       write(fout,*) '*---------------------------------------------*'


      do 9010 i=1,imax
 9010 fjlog(i) = fjlog(i)/fjsum 
      fjout = fjout/(fjsum+fjout)
      
      if (nvout .gt. 0) write(fout,9020) maxm,fjout*100.0d0
 9020 format(' Mass not in the stored ',i7,' models is ',g6.4,' %')
c
c  compute corr coefficient
c 
      sumb = 0.0d0
      sumf = 0.0d0
      ssqb = 0.0d0
      ssqf = 0.0d0
      corr = 0.0d0
      
      do 9100 i=1,imax
         sumb = sumb +  fjlog(i)
         ssqb = ssqb +  fjlog(i)**2
         sumf = sumf + visits(i)
         ssqf = ssqf + visits(i)**2
 9100 enddo
 
      sumb = sumb/dble(imax)
      sumf = sumf/dble(imax)
      ssqb = sqrt(ssqb/dble(imax) - sumb**2)
      ssqf = sqrt(ssqf/dble(imax) - sumf**2)
      
      do 9200 i=1,imax
 9200 corr = corr+(fjlog(i)-sumb)*(visits(i)-sumf)
      corr = corr/(ssqb*ssqf*dble(imax))
      
      write(fout,*)
      write(fout,9209) sumb,sumf
 9209 format(2x,'Means of BayesF and Freq are    ',2e15.4)
      write(fout,9210) ssqb,ssqf
 9210 format(2x,' STDs of BayesF and Freq are    ',2e15.4)
      write(fout,9215) corr
 9215 format(2x,' Corr Coef of BayesF w/ Freq is ',e15.4)
      write(fout,*)

c      do 9910 i=1,imax
c 9910 write(fmod,9920) i,midx(i),fjlog(i),visits(i)
c 9920 format(i9,i25,2e24.10)

      fjsum = fjsum*dexp(fjlogmean)

      
      return
      end
c
c-----------------------------------------------------------------------
c
c      real*8 function studt1(z,nu,b,a)
c
c  computes the pdf of a univariate Student's t
c  (version 7/30/97)
cc
c  nu....degrees of freedom
c  b.....location
c  A.....Inv of Prec  
c
c     implicit real*8 (a-h,o-z)
c      integer nu
c      real*8 b,a,z
c       
c      data dpi/3.14159265358979d0/
c           
c      studt1 = dexp(gammln(0.5d0*(1.d0+nu))-gammln(0.5d0*nu))
c      studt1 = studt1/dsqrt(3.14159265358979d0*nu*a)
c      studt1 = studt1/(1.d0+((z-b)**2)/(nu*a))**(0.5d0*(1.d0+nu))
c       
c      return
c      end
c
c-----------------------------------------------------------------------

c
c-----------------------------------------------------------------------
c          function: gammln
c-----------------------------------------------------------------------
c
c This function computes ln(gamma(x)) for x > 0.
c Taken from Pascal Numerical Recipes p 177
c
c Modified to improve accuracy when x<1 using:
c
c                     pi*e
c Gamma(1-e) = ---------------------
c               Gamma(1+e)*sin(pi*e)
c
      real*8 function gammln(xx)
c
      real*8 xx
      real*8 cof(6),stp,half,one,fpf,x,y,tmp,ser,g,dpi
c
      data cof/76.18009173d0,-86.50532033d0,24.01409822d0, 
     &         -1.231739516d0,0.120858003d-2,-.536382d-5/
      data stp/2.50662827465d0/
      data dpi/3.14159265358979d0/
      data half,one,fpf/0.5d0,1.0d0,5.5d0/
c                 
      if (xx.lt.1) then
         x = one - xx
         tmp =  x + fpf
         tmp = (x + half)*dlog(tmp)-tmp
         ser = one
         do 1000 j=1,6
            x=x+one
            ser = ser+cof(j)/x
 1000    continue
         g = tmp + dlog(stp*ser)
         y = dpi*(one-xx)
         gammln = dlog(y/sin(y)) - g
c
       else
c
         x = xx - one
         tmp =  x + fpf
         tmp = (x + half)*dlog(tmp)-tmp
         ser = one
         do 1100 j=1,6
            x=x+one
            ser = ser+cof(j)/x
 1100    continue
         gammln = tmp + dlog(stp*ser)
      endif
c
      return
      end
c
c
c-----------------------------------------------------------------------

c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Basic mc3m stuff
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
      subroutine ireg(n,m,ir)
c      
c INPUTS:
c     n.......is the number of all possible regressors
c     m(n)...m(i) contains 0s or 1s in each coordinate
c OUTPUT:
c     ir.....is a kj-dim vector with the indeces of the included regressors
c
      integer  n,m(n),ir(n)
c
      ii=1
      do 10 i=1,n
         if (m(i).eq.1) then
            ir(ii)=i
            ii=ii+1
         endif
 10   continue
      return
      end
c
c
      subroutine ireg2(n,m,ir,kj)
c      
c INPUTS:
c     n.......is the number of all possible regressors
c     m(n)...m(i) contains 0s or 1s in each coordinate
c OUTPUT:
c     ir.....is a kj-dim vector with the indeces of the included regressors
c
      integer  n,m(n),ir(n)
c
      ii=1
      do 10 i=1,n
         if (m(i).eq.1) then
            ir(ii)=i
            ii=ii+1
         endif
 10   continue
      kj = ii -1
      return
      end
c
c-----------------------------------------------------------------------
c
      real*8 function getmodidx(n,m)
c      
c INPUTS:
c     n.......is the number of all possible regressors
c     m(n)...m(i) contains 0s or 1s in each coordinate
c OUTPUT:
c     l.......is the real*8 associated with the state vector
c
      implicit real*8 (a-h,o-z)
      integer  n, m(n)
	  
	  z = 2.0d0**(n-1)
      x = m(n)+1
      
      do 10 i=1,n-1
         x = x + (z*(m(i)+1.0d0)-z)
 10   z = z/2.0d0
      getmodidx = x
      return
      end
c
c-----------------------------------------------------------------------
c
      subroutine gmodel(j,n,m)
c
c  Given the model index j (and the number of all possible regressors n) 
c  it returns a binary array of dimension n.  If the kth coordinate is 1
c  the kth regressor is included in the model.  Otherwise it is excluded.
c      
c INPUTS:
c     j.......is the Model index (real*8)
c     n.......is the number of all possible regressors
c
c OUTPUT:
c     m(n)...m(i) contains 0s or 1s in each coordinate
c
      integer  n, m(n)
      real*8 j,ni, k

      ni = 2.0d0**(n-1)
      k = j
 
      do 20 i=1,n
         if (k.gt.ni) then
            m(i) = 1
            k = k-ni
         else
            m(i) = 0
         endif
         ni = ni/2.0d0
 20   continue
      return
      end
c
c-----------------------------------------------------------------------
c
      subroutine gmodel2(j,n,m,kj,ir)
c
c  Given the model index j (and the number of all possible regressors n) 
c  it returns a binary array of dimension n.  If the kth coordinate is 1
c  the kth regressor is included in the model.  Otherwise it is excluded.
c      
c INPUTS:
c     j.......is the Model index 
c     n.......is the number of all possible regressors
c
c OUTPUT:
c     m(n)...m(i) contains 0s or 1s in each coordinate
c     kj.....number of included regressors
c     ir(n)..array w/ indexes of incl regressors
c
      integer  n,m(n),ir(n)
      real*8 j,ni, k

      ni = 2.0d0**(n-1)
      k = j
      kj = 0
      ii = 1
 
      do 20 i=1,n
         if (k.gt.ni) then
            m(i) = 1
	    kj = kj + 1
            k = k-ni
	    ir(ii) = i
	    ii = ii + 1
         else
            m(i) = 0
         endif
         ni = ni/2.0d0
 20   continue
      return
      end
c
c
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c
      integer function icard(n,m)
c
c  returns the number of 1's in binary array m(n)
c
      integer i,j,n,m(n)
      j=0
      do 10 i=1,n
 10   j=j+m(i)
      icard=j
      return
      end
c     
c-----------------------------------------------------------------------
c
c
c-----------------------------------------------------------------------
c
      subroutine mcand(n,m,mc,idum)
c
c  Given the model represented by the binary array m(n)
c  randomly choose candidate model, mc, in nbd(m)
c
      implicit real*8 (a-h,o-z)
      integer n, m(n), mc(n), idum
	        
      do 100 i=1,n
 100  mc(i) = m(i)
c
c
c |--|----------|
c 0  1          n
c     
c draw from 0,1,...,n
c
      i1 = int(ran2(idum)*(n+1.0d0))
c
c if we get 0 we stay w/ same model
c otherwise we just switch the value of the i1th coordinate
c
      if (i1.gt.0) mc(i1) = abs(mc(i1)-1)
	  return
      end
c
c-----------------------------------------------------------------------
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Misc Aux routines
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c-----------------------------------------------------------------------
c
      subroutine barra(car,n,fout)
c
c-----------------------------------------------------------------------
c
      implicit real*8 (a-h,o-z)
c
c
      integer i, n, fout
      character*1 car
      character*1 bar(80)
      do 1000 i=1,n
 1000 bar(i) = car
      write(fout,*) (bar(i),i=1,n)
      return
      end
c-----------------------------------------------------------------------
c

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc
ccc  Random 
ccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

c
c
c-----------------------------------------------------------------------
c
      real*8 function ran2(idum)
c
c   this function contains a portable random number generator 
c   uniform [0,1]
c   (numerical recipes p. 273)
c
      implicit real*8 (a-h,o-z)
      integer idum,im1,im2,imm1,ia1,ia2,iq1,iq2,ir1,ir2,ntab,ndiv
      real*8 am,eps,rnmx
      parameter (im1=2147483563,im2=2147483399,am=1.d0/im1,imm1=im1-1,
     &      ia1=40014,ia2=40692,iq1=53668,iq2=52774,ir1=12211,ir2=3791,
     &      ntab=32,ndiv=1+imm1/ntab,eps=1.2d-7,rnmx=1.0d0-eps)
      integer idum2,j,k,iv(ntab),iy
      save iv,iy,idum2
      data idum2/123456789/, iv/ntab*0/, iy/0/
      if (idum.le.0) then
         idum=max(-idum,1)
         idum2=idum
         do 11 j=ntab+8,1,-1
            k=idum/iq1
            idum=ia1*(idum-k*iq1)-k*ir1
            if (idum.lt.0) idum=idum+im1
            if (j.le.ntab) iv(j)=idum
 11      continue
         iy=iv(1)
      endif
      k=idum/iq1
      idum=ia1*(idum-k*iq1)-k*ir1
      if (idum.lt.0) idum=idum+im1
      k=idum2/iq2
      idum2=ia2*(idum2-k*iq2)-k*ir2
      if (idum2.lt.0) idum2=idum2+im2
      j=1+iy/ndiv
      iy=iv(j)-idum2
      iv(j)=idum
      if(iy.lt.1)iy=iy+imm1
      ran2=dmin1(am*iy,rnmx)
      return
      end
c
c-----------------------------------------------------------------------

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc
ccc  MATRIX inversion, determinant, etc routines
ccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      SUBROUTINE choldc(a,n,np,p,fail)
      logical fail
      INTEGER n,np
      REAL*8 a(np,np),p(n)
      INTEGER i,j,k
      REAL*8 sum
      fail = .false.
      do 13 i=1,n
         do 12 j=i,n
           sum=a(i,j)
          do 11 k=i-1,1,-1
             sum=sum-a(i,k)*a(j,k)
 11       continue
          if(i.eq.j)then
             if(sum.le.0.d0) then
                fail = .true.
                return
             endif
             p(i)=sqrt(sum)
         else
             a(j,i)=sum/p(i)
         endif
 12     continue
 13   continue
 100  continue
      return
      END

      SUBROUTINE cholsl(a,n,np,p,b,x)
      INTEGER n,np
      REAL*8 a(np,np),b(n),p(n),x(n)
      INTEGER i,k
      REAL*8 sum
      do 12 i=1,n
        sum=b(i)
        do 11 k=i-1,1,-1
          sum=sum-a(i,k)*x(k)
11      continue
        x(i)=sum/p(i)
12    continue
      do 14 i=n,1,-1
        sum=x(i)
        do 13 k=i+1,n
          sum=sum-a(k,i)*x(k)
13      continue
        x(i)=sum/p(i)
14    continue
      return
      END
c
c-----------------------------------------------------------------------
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

c-----------------------------------------------------------------------
c
      SUBROUTINE indexx(n,arr,indx)
      INTEGER n,indx(n),M,NSTACK
      REAL*8 arr(n)
      PARAMETER (M=7,NSTACK=50)
      INTEGER i,indxt,ir,itemp,j,jstack,k,l,istack(NSTACK)
      REAL*8 a
      do 11 j=1,n
         indx(j)=j
 11   continue
      jstack=0
      l=1
      ir=n
 1    if(ir-l.lt.M)then
         do 13 j=l+1,ir
            indxt=indx(j)
            a=arr(indxt)
            do 12 i=j-1,1,-1
               if(arr(indx(i)).le.a)goto 2
               indx(i+1)=indx(i)
 12         continue
            i=0
 2          indx(i+1)=indxt
 13      continue
         if(jstack.eq.0)return
         ir=istack(jstack)
         l=istack(jstack-1)
         jstack=jstack-2
      else
         k=(l+ir)/2
         itemp=indx(k)
         indx(k)=indx(l+1)
         indx(l+1)=itemp
         if(arr(indx(l+1)).gt.arr(indx(ir)))then
            itemp=indx(l+1)
            indx(l+1)=indx(ir)
            indx(ir)=itemp
         endif
         if(arr(indx(l)).gt.arr(indx(ir)))then
            itemp=indx(l)
            indx(l)=indx(ir)
            indx(ir)=itemp
         endif
         if(arr(indx(l+1)).gt.arr(indx(l)))then
            itemp=indx(l+1)
            indx(l+1)=indx(l)
            indx(l)=itemp
         endif
         i=l+1
         j=ir
         indxt=indx(l)
         a=arr(indxt)
 3       continue
         i=i+1
         if(arr(indx(i)).lt.a)goto 3
 4       continue
         j=j-1
         if(arr(indx(j)).gt.a)goto 4
         if(j.lt.i)goto 5
         itemp=indx(i)
         indx(i)=indx(j)
         indx(j)=itemp
         goto 3
 5       indx(l)=indx(j)
         indx(j)=indxt
         jstack=jstack+2
         if(jstack.gt.NSTACK)pause 'NSTACK too small in indexx'
         if(ir-i+1.ge.j-l)then
            istack(jstack)=ir
            istack(jstack-1)=i
            ir=j-1
         else
            istack(jstack)=j-1
            istack(jstack-1)=l
            l=i
         endif
      endif
      goto 1
      END
c
      subroutine compmodel(icount,funit,
     &         fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      
      implicit real*8 (a-h,o-z)
      parameter(kreg=41,maxn=75,maxm=350000)

      integer icount,funit
      integer model(kreg),mmodel(kreg)
      real*8 z(maxn,kreg), y(maxn), ztz(kreg,kreg),bstarfj(kreg),
     &  indice,midx(maxm)
      logical fail
      
      fail =.false.
      
      icount = icount + 1

      call computefj(iprior,model,nobs,ztz,z,y,ssqy,
     &         kjfj,g0jfj,dstarfj,bstarfj,fjnew,fail)
     
         if (icount.eq.1) then 
	   fjsimmax = fjnew
	   do 10 i=1,kreg
	    mmodel(i)=model(i)
10	   enddo
         endif
         if (fail) then 
           write(funit,*) '...Fail -- SiM!...'
           return
         else
           if (fjnew.gt.fjsimmax) then
	     fjsimmax = fjnew
	     do 20 i=1,kreg
	       mmodel(i)=model(i)
20	     enddo
	   endif
           fjsim = fjsim + dexp(fjnew - fjlogmean)
         endif
c
c We must be careful since some of these models might have been
c visited by the chain and its mass might already be part of fjsum below!
c
         indice = getmodidx(kreg,model)                         
                                                                           
         do 8625 imod=1,imax                                           
            if (indice.eq.midx(imod)) then                           
                dblecount = dblecount + dexp(fjnew - fjlogmean)
                goto 8626
            endif
 8625    enddo
 8626 continue
      return
      end
c
c
c--------------------------------------------------------------------
c      
      subroutine fillzeroes(array,n)
      integer array(41),n
      do 10 i=n,41
         array(i) = 0
 10   enddo
      return
      end
      
      subroutine fillones(array,n)
      integer array(41),n
      do 20 i=n,41
         array(i) = 1
 20   enddo
      return
      end 
     
      integer function icompsum(array,n)
      integer isum,n,array(41),i
      isum=0
      do 10 i=4,n
      isum=isum+array(i)
  10  enddo
      icompsum=isum
      return 
      end
c-----------------------------------------------------------------------
c
      subroutine SalaModels(fout,
     &         fjlogmean,imax,midx,
     &         iprior,nobs,ztz,z,y,ssqy,bstarfj,
     &         jsim,fjsimmax,fjsim,dblecount,mmodel)
                  
      implicit real*8(a-h,o-z)
      parameter(kreg=41,maxn=75,maxm=350000)
     
      integer iprior,fout,imax,nobs,model(kreg),mmodel(kreg)
      
      real*8 z(maxn,kreg), y(maxn), ztz(kreg,kreg),midx(maxm),
     & bstarfj(kreg)

      
      fjsim = 0.0d0
      jsim=0
      dblecount=0.0d0
      model(1) =1
      model(2) =1
      model(3) =1
      
      do 1010 i4=0,1
      model(4) = i4
      do 1020  i5=0,1
      model(5) = i5
      do 1030  i6=0,1
      model(6) = i6      
      do 1040  i7=0,1
      model(7) = i7
      if (icompsum(model,7).eq.4) then
      call fillzeroes(model,8)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1050  i8=0,1
      model(8) = i8
      if (icompsum(model,8).eq.4) then
      call fillzeroes(model,9)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1060  i9=0,1
      model(9) = i9
      if (icompsum(model,9).eq.4) then
      call fillzeroes(model,10)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1070  i10=0,1
      model(10) = i10
      if (icompsum(model,10).eq.4) then
      call fillzeroes(model,11)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1080  i11=0,1
      model(11) = i11
      if (icompsum(model,11).eq.4) then
      call fillzeroes(model,12)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1090  i12=0,1
      model(12) = i12
      if (icompsum(model,12).eq.4) then
      call fillzeroes(model,13)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1100  i13=0,1
      model(13) = i13
      if (icompsum(model,13).eq.4) then
      call fillzeroes(model,14)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1110  i14=0,1
      model(14) = i14
      if (icompsum(model,14).eq.4) then
      call fillzeroes(model,15)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1120  i15=0,1
      model(15) = i15
      if (icompsum(model,15).eq.4) then
      call fillzeroes(model,16)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1130  i16=0,1
      model(16) = i16
      if (icompsum(model,16).eq.4) then
      call fillzeroes(model,17)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1140  i17=0,1
      model(17) = i17
      if (icompsum(model,17).eq.4) then
      call fillzeroes(model,18)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1150  i18=0,1
      model(18) = i18
      if (icompsum(model,18).eq.4) then
      call fillzeroes(model,19)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1160  i19=0,1
      model(19) = i19
      if (icompsum(model,19).eq.4) then
      call fillzeroes(model,20)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1170  i20=0,1
      model(20) = i20
      if (icompsum(model,20).eq.4) then
      call fillzeroes(model,21)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6021  i21=0,1
      model(21) = i21
      if (icompsum(model,21).eq.4) then
      call fillzeroes(model,22)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6022  i22=0,1
      model(22) = i22
      if (icompsum(model,22).eq.4) then
      call fillzeroes(model,23)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6023  i23=0,1
      model(23) = i23
      if (icompsum(model,23).eq.4) then
      call fillzeroes(model,24)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6024  i24=0,1
      model(24) = i24
      if (icompsum(model,24).eq.4) then
      call fillzeroes(model,25)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6025 i25=0,1
      model(25) = i25
      if (icompsum(model,25).eq.4) then
      call fillzeroes(model,26)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6026  i26=0,1
      model(26) = i26
      if (icompsum(model,26).eq.4) then
      call fillzeroes(model,27)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6027  i27=0,1
      model(27) = i27
      if (icompsum(model,27).eq.4) then
      call fillzeroes(model,28)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6028  i28=0,1
      model(28) = i28
      if (icompsum(model,28).eq.4) then
      call fillzeroes(model,29)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6029  i29=0,1
      model(29) = i29
      if (icompsum(model,29).eq.4) then
      call fillzeroes(model,30)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6030 i30=0,1
      model(30) = i30
      if (icompsum(model,30).eq.4) then
      call fillzeroes(model,31)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6031 i31=0,1
      model(31) = i31
      if (icompsum(model,31).eq.4) then
      call fillzeroes(model,32)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6032 i32=0,1
      model(32) = i32
      if (icompsum(model,32).eq.4) then
      call fillzeroes(model,33)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6033  i33=0,1
      model(33) = i33
      if (icompsum(model,33).eq.4) then
      call fillzeroes(model,34)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6034   i34=0,1
      model(34) = i34
      if (icompsum(model,34).eq.4) then
      call fillzeroes(model,35)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6035   i35=0,1
      model(35) = i35
      if (icompsum(model,35).eq.4) then
      call fillzeroes(model,36)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 6036   i36=0,1
      model(36) = i36
      if (icompsum(model,36).eq.4) then
      call fillzeroes(model,37)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1180 i37=0,1
      model(37) = i37
      if (icompsum(model,37).eq.4) then
      call fillzeroes(model,38)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      elseif (icompsum(model,37).eq.0) then
      call fillones(model,38)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      do 1190  i38=0,1
      model(38) = i38
      if (icompsum(model,38).eq.4) then
      call fillzeroes(model,39)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      elseif (icompsum(model,38).eq.1) then
      call fillones(model,39)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      
      do 1200  i39=0,1
      model(39) = i39
      if (icompsum(model,39).eq.4) then
      call fillzeroes(model,40)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      elseif (icompsum(model,39).eq.2) then
      call fillones(model,40)
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      else
      
      do 1210 i40=0,1
       model(40) = i40
       if (model(40).eq.0) then
        model(41)=1
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
        else
        model(41)=0
      call compmodel(jsim,fout,fjlogmean,imax,midx,
     &         iprior,model,nobs,ztz,z,y,ssqy,bstarfj,
     &         fjsimmax,fjsim,dblecount,mmodel)
      endif
 1210 enddo
      
      endif
 1200 enddo
      endif
 1190 enddo
      endif
 1180 enddo
 
      endif
 6036 enddo
      endif
 6035 enddo
      endif
 6034 enddo
      endif
 6033 enddo
      endif
 6032 enddo
      endif
 6031 enddo
      endif
 6030 enddo
      endif
 6029 enddo
      endif
 6028 enddo
      endif
 6027 enddo
      endif
 6026 enddo
      endif
 6025 enddo
      endif
 6024 enddo
      endif
 6023 enddo
      endif
 6022 enddo
      endif
 6021 enddo
      endif
  
 1170 enddo
 1171 endif
 1160 enddo
 1161 endif
 1150 enddo
 1151 endif
 1140 enddo
 1141 endif
 1130 enddo
 1131 endif
 1120 enddo
 1121 endif
 1110 enddo
 1111 endif
 1100 enddo
 1101 endif
 1090 enddo
 1091 endif
 1080 enddo
 1081 endif
 1070 enddo
 1071 endif
 1060 enddo
 1061 endif
 1050 enddo
 1051 endif
 1040 enddo
 1030 enddo
 1020 enddo
 1010 enddo
 
c
c  To keep changes at minimum we won't sort BayesF here so we still
c  don't know which model is best.  However we'll be able to recover
c  odds ratios later:
c
c     SiM                   Best                SiM        x
c  -------------  = x,     --------- = z  ===>  ------- = --- (1-x) 
c  SiM + Visited            Visited             Best       z
c
      return
      end


c-----------------------------------------------------------------------
c
c
c  SetDirectory "Calvin:Apps:MPW:Libraries:MyLibraries:"
c  f77 "{MyLibraries}"timelib.f  "{AbsoftLibraries}"unixlib.o -c   "{Worksheet}"
c  Lnk  -xm library timelib.f.o "{AbsoftLibraries}"unixlib.o  "{Worksheet}" -o timelib.o
c
c
c-----------------------------------------------------------------------
c
      SUBROUTINE wr_time(FILENAME,WFILE,WSCREEN)
C
C-----------------------------------------------------------------------
C
      INTEGER FILENAME, HOURS(2), MINUTES(2), SECONDS(2), I
      REAL TARRAY(2,2), SECS(2),USER(2),SYST(2)
      REAL DTIME, ETIME
      LOGICAL WSCREEN,WFILE
C
C TIME
C
      SECS(1) = DTIME(TARRAY(1,1))
      SECS(2) = ETIME(TARRAY(1,2))
      DO 10 I=1,2
         IF (SECS(I).NE.0) THEN
              USER(I) = (TARRAY(1,I)*100.0)/SECS(I)
              SYST(I) = (TARRAY(2,I)*100.0)/SECS(I)
            ELSE
               USER(I) = 0.0
               SYST(I) = 0.0
          ENDIF
 10   ENDDO
      
      SECONDS(1) = NINT(SECS(1))
      SECONDS(2) = NINT(SECS(2))
      MINUTES(1) = SECONDS(1)/60
      HOURS(1)   = MINUTES(1)/60
      MINUTES(2) = SECONDS(2)/60
      HOURS(2)   = MINUTES(2)/60
C      
      MINUTES(1) = MINUTES(1) - HOURS(1)*60
      SECONDS(1) = SECONDS(1) - MINUTES(1)*60 - HOURS(1)*60*60
      MINUTES(2) = MINUTES(2) - HOURS(2)*60
      SECONDS(2) = SECONDS(2) - MINUTES(2)*60 - HOURS(2)*60*60
C 
      IF (WFILE) THEN
      WRITE(FILENAME,200)
      WRITE(FILENAME,150)
      WRITE(FILENAME,100)HOURS(1),MINUTES(1),SECONDS(1),USER(1),SYST(1)
      WRITE(FILENAME,101)HOURS(2),MINUTES(2),SECONDS(2),USER(2),SYST(2)
      WRITE(FILENAME,200)
      ENDIF
      
      IF (WSCREEN) THEN
      WRITE(*,200)
      WRITE(*,150)
      WRITE(*,100)HOURS(1),MINUTES(1),SECONDS(1),USER(1),SYST(1)
      WRITE(*,101)HOURS(2),MINUTES(2),SECONDS(2),USER(2),SYST(2)
      WRITE(*,200)
      ENDIF
      
C
 100  FORMAT('ELAPSED TIME:',3I10,4X,F10.2,'%',F10.2,'%')
 101  FORMAT('CUMULATIVE:  ',3I10,4X,F10.2,'%',F10.2,'%')
 150  FORMAT(20X,'HOURS    MINUTES    SECNDS      USER       SYSTEM')
 200  FORMAT('----------------------------------------------------------
     &-----------')
C     
      RETURN
      END
C-----------------------------------------------------------------------
C
      SUBROUTINE wr_date(FILENAME,WFILE,WSCREEN)
C
C-----------------------------------------------------------------------
C
      INTEGER FILENAME
      CHARACTER*24 THE_DATE
      LOGICAL WFILE,WSCREEN

      CALL FDATE(THE_DATE)
      
      IF (WFILE) THEN
         WRITE(FILENAME,101)
         WRITE(FILENAME,100) THE_DATE
         WRITE(FILENAME,101)
       ENDIF
         
      IF (WSCREEN) THEN
          WRITE(*,101)
          WRITE(*,100) THE_DATE
          WRITE(*,101)
      ENDIF
          
  100 FORMAT('|   DATE:',2X,A24,4X,'|')
  101 FORMAT('----------------------------------------')
      RETURN
      END
C
C-----------------------------------------------------------------------
c
c EOF
