/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/

clear all
set mem 5000m
set more off, perm

cd "T:\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1990.dta, clear


//merge bcertificates information
merge 1:1 id using  bcertificates_1991.dta
keep if _m==3
drop _merge



* generate variables
gen lfp=(lincome1990>0) 		

* income
gen income=lincome1990 
gen lincome=log(lincome1990)

* kids indicator
gen morethanone=kids_in_1991>1 if kids_in_1991!=.
gen morethantwo=kids_in_1991>2 if kids_in_1991!=.


//generate covariates:
//////////////////////

gen mage=1991-motheryob 
gen age1st=1991-born1_yob 

gen mage1st=born1_yob-motheryob
gen mage1st2=mage1st^2

gen mage2nd=born2_yob-motheryob
gen mage2nd2=mage2nd^2

gen mage3rd=born3_yob-motheryob
gen mage3rd2=mage3rd^2

label var mage1st "mothers age at first birth"
label var mage1st2 "squared mothers age at first birth"

label var mage2nd "mothers age at second birth"
label var mage2nd2 "squared mothers age at second birth"

label var mage3rd "mothers age at third birth"
label var mage3rd2 "squared mothers age at third birth"

rename educ1990 educ

label var educ "mothers education at first birth"

//generate instruments:
///////////////////////

gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st


gen Zddot2nd=twin2nd
gen eddot2nd=(sexcomp_twins2nd==3)
replace eddot2nd=. if Zddot2nd==.
gen Zdot2nd=Zddot2nd-eddot2nd
gen Zbar2nd=Zdot2nd-eddot2nd

compress

keep id samesex educ age1st lfp* kids_in_1991 morethan* lincome income motheryob twin* Z* female* edd* mage*  born*_yob

save analysis_sweden_1990, replace
