/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/

clear all
set mem 5000m
set more off, perm
cd "\\Elektra2\dnr2012-218\new 2014_12_09"
use analysis_sweden_1990.dta

* sample restrictions as in AE98:

keep if mage<=35 & mage>=21
keep if age1st<=18
keep if kids_in_1991>=2

* Zbar(0)

gen Zbar=Zdot2nd-eddot2nd

gen mage2=mage*mage
* control variables we keep
global con = "mage mage2 mage1st female1 female2"

* controls:
global xs = "c.mage##c.mage mage1st i.female1 i.female2"

rename Zddot2nd Zddot
rename Zdot2nd Zdot
rename eddot2nd eddot

keep $con Zddot Zdot Zbar eddot lfp morethantwo lincome income
compress
set seed 10101
save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\BS samples\Sweden_1990.dta", replace


/// BS for Zbarmin:

global R=1000						//number of replications

////////////
// create storage file for bootstrap results
preserve
clear all

set obs $R
gen b_income=.
gen b_worked=.
gen theta=.
gen fselobs_min=.
gen f1st=.
gen b_lincome=.
gen theta_wm=.
gen fselobs_min_wm=.
gen f1st_wm=.
save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\Sweden_bs_results.dta", replace
restore

qui forvalues j=1(1)$R {

 use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\BS samples\Sweden_1990.dta", clear


	// create bootstrap sample
		bsample 
	// find theta_min
	// full sample
	preserve
	drop _all
	set obs 210
	gen theta=.
	gen F=.
	save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs.dta", replace
	restore
	sum Zdot
	local piZdot=r(mean)
	sum eddot
	local pieddot=r(mean)
	local line=0
	forvalues theta=-1(0.01)1.01 { // grid search	
		preserve
		local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
		gen Zwdot=Zdot-`lambda'*eddot
		reg Zwdot $xs, robust
		use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs.dta", clear
		local line=`line'+1
		replace theta=`theta' in `line'
		replace F=e(F) in `line'
		save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs.dta", replace
		restore
	}
	preserve
	// pick theta
	use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs.dta", clear
	sum F, d
	sum theta if F==r(min)
	local theta_min=r(mean)
	sum F, d
	sum F if F==r(min)
	local Fmin=r(mean)
	restore 
	
	//theta_min for working mothers only
	preserve
	drop _all
	set obs 210
	gen theta=.
	gen F=.
	save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs_workmothers.dta", replace
	restore
	sum Zdot if lincome!=.
	local piZdot=r(mean)
	sum eddot if lincome!=.
	local pieddot=r(mean)
	local line=0
	forvalues theta=-1(0.01)1.01 {	
		preserve
		local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
		gen Zwdot=Zdot-`lambda'*eddot
		reg Zwdot $xs if lincome!=., robust
		use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs_workmothers.dta", clear
		local line=`line'+1
		replace theta=`theta' in `line'
		replace F=e(F) in `line'
		save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs_workmothers.dta", replace
		restore
	}
	preserve
	use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\res_sos_bs_workmothers.dta", clear
	sum F, d
	sum theta if F==r(min)
	local theta_min_workmothers=r(mean)
	sum F, d
	sum F if F==r(min)
	local Fmin_workmothers=r(mean)
	restore 
	
	// create Zbarmin variables
	//full sample
	sum Zdot
	local piZdot=r(mean)
	sum eddot
	local pieddot=r(mean)
	local theta=`theta_min'
	local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
	gen Zbarmin=Zdot-`lambda'*eddot
	//working mothers only
	sum Zdot if lincome!=. 
	local piZdot=r(mean)
	sum eddot if lincome!=.
	local pieddot=r(mean)
	local theta=`theta_min_workmothers'
	local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
	gen Zbarmin_working=Zdot-`lambda'*eddot if lincome!=.
	
	//regressions
	reg morethantwo Zbarmin $xs, robust
	test Zbarmin
	local F1st=r(F) // first stage F-statistic (full sample)
	reg morethantwo Zbarmin_working $xs if lincome!=., robust
	test Zbarmin_working
	local F1st_wm=r(F) // first stage F-statistic (log(wage) sample)
	ivregress 2sls lfp (morethantwo=Zbarmin) $xs, robust 
	local b_worked=_b[morethantwo]
	ivregress 2sls lincome (morethantwo=Zbarmin_working) $xs, robust
	local b_lincome=_b[morethantwo]
	ivregress 2sls income (morethantwo=Zbarmin) $xs, robust
	local b_income=_b[morethantwo]
	
	preserve
	use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\Sweden_bs_results.dta", clear
	replace theta=`theta_min' in `j'
	replace theta_wm=`theta_min_workmothers' in `j'
	replace fselobs_min=`Fmin' in `j'
	replace fselobs_min_wm=`Fmin_workmothers' in `j'
	replace f1st=`F1st' in `j'
	replace f1st_wm=`F1st_wm' in `j'
	replace b_worked=`b_worked' in `j'
	replace b_lincome=`b_lincome' in `j'
	replace b_income=`b_income' in `j'
	save "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\Sweden_bs_results.dta", replace
	restore
	
}		//end main loop

// bootstrapped standard errors:
use "\\Elektra2\dnr2012-218\Labour do-files\after JAE Revision\Sweden_bs_results.dta", clear

sum b_worked if abs(b_worked)<1,
sum b_lincome if abs(b_lincome)<1,
sum b_income if abs(b_income)<30000,

