/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 5000m
set more off, perm
cd "\\Elektra2\dnr2012-218\new 2014_12_09"
use analysis_sweden_1990.dta

* sample restrictions as in AE98:

keep if mage<=35 & mage>=21
keep if age1st<=18
keep if kids_in_1991>=2

* Zbar(0)
gen Zbar=Zdot2nd-eddot2nd

global con = "c.mage##c.mage mage1st i.female1 i.female2"


*** generate Zbarmin
* for full sample
preserve
gen theta=.
gen F=.

sum Zdot2nd
local piZdot=r(mean)
sum eddot2nd
local pieddot=r(mean)
local line=0
qui forvalues theta=-1(0.01)1.01 {	
	cap drop Zwdot
	local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
	gen Zwdot=Zdot2nd-`lambda'*eddot2nd
	reg Zwdot $con, robust
	local line=`line'+1
	replace theta=`theta' in `line'
	replace F=e(F) in `line'
	noi dis `line'
}

sum F, d
sum theta if F==r(min)
local theta=r(mean)

sum Zdot2nd
local piZdot=r(mean)
sum eddot2nd
local pieddot=r(mean)

local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
restore

gen Zbarmin=Zdot2nd-`lambda'*eddot2nd

*for log-income sample
preserve
keep if lincome!=.
gen theta=.
gen F=.

sum Zdot2nd
local piZdot=r(mean)
sum eddot2nd
local pieddot=r(mean)
local line=0
qui forvalues theta=-1(0.01)1.01 {	
	cap drop Zwdot
	local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
	gen Zwdot=Zdot2nd-`lambda'*eddot2nd
	reg Zwdot $con, robust
	local line=`line'+1
	replace theta=`theta' in `line'
	replace F=e(F) in `line'
	noi dis `line'
}

sum F, d
sum theta if F==r(min)
local theta=r(mean)

sum Zdot2nd
local piZdot=r(mean)
sum eddot2nd
local pieddot=r(mean)

local lambda=1+`theta'*((`piZdot'-`pieddot')/`pieddot')
restore

gen Zbarmin_w=Zdot2nd-`lambda'*eddot2nd

* controls
global con = "i.mage i.mage1st i.female1 i.female2"

*** Panel 1: Yearly Labor Income
* row 1: coefficients
reg income morethantwo $con, r
ivregress 2sls income (morethantwo=Zddot2nd) $con, r
ivregress 2sls income (morethantwo=Zdot2nd) $con, r
ivregress 2sls income (morethantwo=Zbar) $con, r
ivregress 2sls income (morethantwo=Zbarmin) $con, r
ivregress 2sls income (morethantwo=samesex) $con, r

* row 2: First stage F-stat

qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg morethantwo `var' $con, r
noi test `var'
}

* row 3: Selection on observables (overall F-stat)
qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg `var' $con, r
noi dis e(F)
}

*** Panel 2: Labor Force Participation
* row 1: coefficients
reg lfp morethantwo $con, r
ivregress 2sls lfp (morethantwo=Zddot2nd) $con, r
ivregress 2sls lfp (morethantwo=Zdot2nd) $con, r
ivregress 2sls lfp (morethantwo=Zbar) $con, r
ivregress 2sls lfp (morethantwo=Zbarmin) $con, r
ivregress 2sls lfp (morethantwo=samesex) $con, r

* row 2: First stage F-stat

qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg morethantwo `var' $con, r
noi test `var'
}

* row 3: Selection on observables (overall F-stat)
qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg `var' $con, r
noi dis e(F)
}


*** Panel 3: log(Yearly Labor Income)
* row 1: coefficients
reg lincome morethantwo $con, r
ivregress 2sls lincome (morethantwo=Zddot2nd) $con, r
ivregress 2sls lincome (morethantwo=Zdot2nd) $con, r
ivregress 2sls lincome (morethantwo=Zbar) $con, r
ivregress 2sls lincome (morethantwo=Zbarmin_w) $con, r
ivregress 2sls lincome (morethantwo=samesex) $con, r

* row 2: First stage F-stat

qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg morethantwo `var' $con if lincome!=., r
noi test `var'
}

* row 3: Selection on observables (overall F-stat)
qui foreach var of varlist Zddot2nd Zdot2nd Zbar Zbarmin samesex {
reg `var' $con if lincome!=., r
noi dis e(F)
}



