/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/

clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_2004.dta, clear						
merge 1:1 id using lab1_2005.dta
drop _merge
merge 1:1 id using lab1_2006.dta
drop _merge
merge 1:1 id using lab1_2007.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					//contains infomation about children!!!!
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<2003			
drop if born1_yob>2006

//Generate outcomes 
//////////////////////////////////////////////////////////

//labor outcomes
drop employed*

gen lfp=(lincome2004>0) if born1_yob==2003				
replace lfp=(lincome2005>0) if born1_yob==2004
replace lfp=(lincome2006>0) if born1_yob==2005
replace lfp=(lincome2007>0) if born1_yob==2006
replace lfp=. if lincome2004==. & born1_yob==2003
replace lfp=. if lincome2005==. & born1_yob==2004
replace lfp=. if lincome2006==. & born1_yob==2005
replace lfp=. if lincome2007==. & born1_yob==2006

gen income=lincome2004 if born1_yob==2003				
replace income=lincome2005 if born1_yob==2004
replace income=lincome2006 if born1_yob==2005
replace income=lincome2007 if born1_yob==2006
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=2004-motheryob if born1_yob==2003				
replace mage=2005-motheryob if born1_yob==2004
replace mage=2006-motheryob if born1_yob==2005
replace mage=2007-motheryob if born1_yob==2006
gen mage2=mage^2
assert mage!=.

gen meduc=educ2004 if born1_yob==2003					
replace meduc=educ2005 if born1_yob==2004
replace meduc=educ2006 if born1_yob==2005
replace meduc=educ2007 if born1_yob==2006
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st


//exposure
assert kids_in_2004!=.
assert kids_in_2005!=.
assert kids_in_2006!=.
assert kids_in_2007!=.
gen morethanone=kids_in_2004>1 if born1_yob==2003
replace morethanone=kids_in_2005>1 if born1_yob==2004
replace morethanone=kids_in_2006>1 if born1_yob==2005
replace morethanone=kids_in_2007>1 if born1_yob==2006

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m

gen mage100=mage/100
gen mage100_2=mage2/100



*** Table 2
reg lfp morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

***  Table C.2
reg income morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

*** Table C.3
reg lincome morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

** 1st stage F-statistics:
* full sampple

reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zbar1st

* log(income) sample
reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zbar1st




