/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/

clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_2000.dta, clear						
merge 1:1 id using lab1_2001.dta
drop _merge
merge 1:1 id using lab1_2002.dta
drop _merge
merge 1:1 id using lab1_2003.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					//contains infomation about children!!!!
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1999			
drop if born1_yob>2002

//Generate outcomes 
//////////////////////////////////////////////////////////

//labor outcomes
drop employed*

gen lfp=(lincome2000>0) if born1_yob==1999				
replace lfp=(lincome2001>0) if born1_yob==2000
replace lfp=(lincome2002>0) if born1_yob==2001
replace lfp=(lincome2003>0) if born1_yob==2002
replace lfp=. if lincome2000==. & born1_yob==1999
replace lfp=. if lincome2001==. & born1_yob==2000
replace lfp=. if lincome2002==. & born1_yob==2001
replace lfp=. if lincome2003==. & born1_yob==2002

gen income=lincome2000 if born1_yob==1999				
replace income=lincome2001 if born1_yob==2000
replace income=lincome2002 if born1_yob==2001
replace income=lincome2003 if born1_yob==2002
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=2000-motheryob if born1_yob==1999				
replace mage=2001-motheryob if born1_yob==2000
replace mage=2002-motheryob if born1_yob==2001
replace mage=2003-motheryob if born1_yob==2002
gen mage2=mage^2
assert mage!=.

gen meduc=educ2000 if born1_yob==1999					
replace meduc=educ2001 if born1_yob==2000
replace meduc=educ2002 if born1_yob==2001
replace meduc=educ2003 if born1_yob==2002
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st


//exposure
assert kids_in_2000!=.
assert kids_in_2001!=.
assert kids_in_2002!=.
assert kids_in_2003!=.
gen morethanone=kids_in_2000>1 if born1_yob==1999
replace morethanone=kids_in_2001>1 if born1_yob==2000
replace morethanone=kids_in_2002>1 if born1_yob==2001
replace morethanone=kids_in_2003>1 if born1_yob==2002

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m

gen mage100=mage/100
gen mage100_2=mage2/100



*** Table 2
reg lfp morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

***  Table C.2
reg income morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

*** Table C.3
reg lincome morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

** 1st stage F-statistics:
* full sampple

reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zbar1st

* log(income) sample
reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zbar1st




