/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/

clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1996.dta, clear						
merge 1:1 id using lab1_1997.dta
drop _merge
merge 1:1 id using lab1_1998.dta
drop _merge
merge 1:1 id using lab1_1999.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					//contains infomation about children!!!!
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1995			
drop if born1_yob>1998

//Generate outcomes 
//////////////////////////////////////////////////////////

//labor outcomes
drop employed*

gen lfp=(lincome1996>0) if born1_yob==1995				
replace lfp=(lincome1997>0) if born1_yob==1996
replace lfp=(lincome1998>0) if born1_yob==1997
replace lfp=(lincome1999>0) if born1_yob==1998
replace lfp=. if lincome1996==. & born1_yob==1995
replace lfp=. if lincome1997==. & born1_yob==1996
replace lfp=. if lincome1998==. & born1_yob==1997
replace lfp=. if lincome1999==. & born1_yob==1998

gen income=lincome1996 if born1_yob==1995				
replace income=lincome1997 if born1_yob==1996
replace income=lincome1998 if born1_yob==1997
replace income=lincome1999 if born1_yob==1998
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=1996-motheryob if born1_yob==1995				
replace mage=1997-motheryob if born1_yob==1996
replace mage=1998-motheryob if born1_yob==1997
replace mage=1999-motheryob if born1_yob==1998
gen mage2=mage^2
assert mage!=.

gen meduc=educ1996 if born1_yob==1995					
replace meduc=educ1997 if born1_yob==1996
replace meduc=educ1998 if born1_yob==1997
replace meduc=educ1999 if born1_yob==1998
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st

//exposure
assert kids_in_1996!=.
assert kids_in_1997!=.
assert kids_in_1998!=.
assert kids_in_1999!=.
gen morethanone=kids_in_1996>1 if born1_yob==1995
replace morethanone=kids_in_1997>1 if born1_yob==1996
replace morethanone=kids_in_1998>1 if born1_yob==1997
replace morethanone=kids_in_1999>1 if born1_yob==1998

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m

gen mage100=mage/100
gen mage100_2=mage2/100



*** Table 2
reg lfp morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

***  Table C.2
reg income morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

*** Table C.3
reg lincome morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

** 1st stage F-statistics:
* full sampple

reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zbar1st

* log(income) sample
reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zbar1st




