/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1992.dta, clear						
merge 1:1 id using lab1_1993.dta
drop _merge
merge 1:1 id using lab1_1994.dta
drop _merge
merge 1:1 id using lab1_1995.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					//contains infomation about children!!!!
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1991			
drop if born1_yob>1994

//labor outcomes
drop employed*

gen lfp=(lincome1992>0) if born1_yob==1991				
replace lfp=(lincome1993>0) if born1_yob==1992
replace lfp=(lincome1994>0) if born1_yob==1993
replace lfp=(lincome1995>0) if born1_yob==1994
replace lfp=. if lincome1992==. & born1_yob==1991
replace lfp=. if lincome1993==. & born1_yob==1992
replace lfp=. if lincome1994==. & born1_yob==1993
replace lfp=. if lincome1995==. & born1_yob==1994

gen income=lincome1992 if born1_yob==1991				
replace income=lincome1993 if born1_yob==1992
replace income=lincome1994 if born1_yob==1993
replace income=lincome1995 if born1_yob==1994
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=1992-motheryob if born1_yob==1991				
replace mage=1993-motheryob if born1_yob==1992
replace mage=1994-motheryob if born1_yob==1993
replace mage=1995-motheryob if born1_yob==1994
gen mage2=mage^2
assert mage!=.

gen meduc=educ1992 if born1_yob==1991					
replace meduc=educ1993 if born1_yob==1992
replace meduc=educ1994 if born1_yob==1993
replace meduc=educ1995 if born1_yob==1994
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st

//exposure
assert kids_in_1992!=.
assert kids_in_1993!=.
assert kids_in_1994!=.
assert kids_in_1995!=.
gen morethanone=kids_in_1992>1 if born1_yob==1991
replace morethanone=kids_in_1993>1 if born1_yob==1992
replace morethanone=kids_in_1994>1 if born1_yob==1993
replace morethanone=kids_in_1995>1 if born1_yob==1994

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m


gen mage100=mage/100
gen mage100_2=mage2/100



*** Table 2
reg lfp morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

***  Table C.2
reg income morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

*** Table C.3
reg lincome morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

** 1st stage F-statistics:
* full sampple

reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zbar1st

* log(income) sample
reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zbar1st

