/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1988.dta, clear
merge 1:1 id using lab1_1989.dta
drop _merge
merge 1:1 id using lab1_1990.dta
drop _merge
merge 1:1 id using lab1_1991.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					//contains infomation about children
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1987
drop if born1_yob>1990

//Generate outcomes (one year after giving birth)
////////////////////////////////////////////////////////

//labor outcomes
gen lfp=(lincome1988>0) if born1_yob==1987
replace lfp=(lincome1989>0) if born1_yob==1988
replace lfp=(lincome1990>0) if born1_yob==1989
replace lfp=(lincome1991>0) if born1_yob==1990
replace lfp=. if lincome1988==. & born1_yob==1987
replace lfp=. if lincome1989==. & born1_yob==1988
replace lfp=. if lincome1990==. & born1_yob==1989
replace lfp=. if lincome1991==. & born1_yob==1990

gen income=lincome1988 if born1_yob==1987
replace income=lincome1989 if born1_yob==1988
replace income=lincome1990 if born1_yob==1989
replace income=lincome1991 if born1_yob==1990
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=1988-motheryob if born1_yob==1987
replace mage=1989-motheryob if born1_yob==1988
replace mage=1990-motheryob if born1_yob==1989
replace mage=1991-motheryob if born1_yob==1990
gen mage2=mage^2
assert mage!=.

gen meduc=educ1988 if born1_yob==1987
replace meduc=educ1989 if born1_yob==1988
replace meduc=educ1990 if born1_yob==1989
replace meduc=educ1991 if born1_yob==1990
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st

//exposure
assert kids_in_1988!=.
assert kids_in_1989!=.
assert kids_in_1990!=.
assert kids_in_1991!=.
gen morethanone=kids_in_1988>1 if born1_yob==1987
replace morethanone=kids_in_1989>1 if born1_yob==1988
replace morethanone=kids_in_1990>1 if born1_yob==1989
replace morethanone=kids_in_1991>1 if born1_yob==1990

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m

gen mage100=mage/100
gen mage100_2=mage2/100



*** Table 2
reg lfp morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

***  Table C.2
reg income morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls income (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

*** Table C.3
reg lincome morethanone mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zdot1st) mage100 mage100_2 i.educ i.born1_yob, robust
ivregress 2sls lincome (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust

** 1st stage F-statistics:
* full sampple

reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
test Zbar1st

* log(income) sample
reg morethanone Zddot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zddot1st

reg morethanone Zdot1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zdot1st

reg morethanone Zbar1st mage100 mage100_2 i.educ i.born1_yob if lincome!=., robust
test Zbar1st




