/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


* Please note that this do file only produces the left graph in Appendix Figure
* B1. The right graph is produced in the AngristEvans1980_jae.do do file

clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1996.dta, clear						
merge 1:1 id using lab1_1997.dta
drop _merge
merge 1:1 id using lab1_1998.dta
drop _merge
merge 1:1 id using lab1_1999.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificatesRall.dta, clear					
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1995			
drop if born1_yob>1998


//labor outcomes
drop employed*

gen lfp=(lincome1996>0) if born1_yob==1995				
replace lfp=(lincome1997>0) if born1_yob==1996
replace lfp=(lincome1998>0) if born1_yob==1997
replace lfp=(lincome1999>0) if born1_yob==1998
replace lfp=. if lincome1996==. & born1_yob==1995
replace lfp=. if lincome1997==. & born1_yob==1996
replace lfp=. if lincome1998==. & born1_yob==1997
replace lfp=. if lincome1999==. & born1_yob==1998

gen income=lincome1996 if born1_yob==1995				
replace income=lincome1997 if born1_yob==1996
replace income=lincome1998 if born1_yob==1997
replace income=lincome1999 if born1_yob==1998
drop lincome*
gen lincome=log(income)

//generate covariates:
//////////////////////
gen mage=1996-motheryob if born1_yob==1995				
replace mage=1997-motheryob if born1_yob==1996
replace mage=1998-motheryob if born1_yob==1997
replace mage=1999-motheryob if born1_yob==1998
gen mage2=mage^2
assert mage!=.

gen meduc=educ1996 if born1_yob==1995					
replace meduc=educ1997 if born1_yob==1996
replace meduc=educ1998 if born1_yob==1997
replace meduc=educ1999 if born1_yob==1998
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st

//exposure
assert kids_in_1996!=.
assert kids_in_1997!=.
assert kids_in_1998!=.
assert kids_in_1999!=.
gen morethanone=kids_in_1996>1 if born1_yob==1995
replace morethanone=kids_in_1997>1 if born1_yob==1996
replace morethanone=kids_in_1998>1 if born1_yob==1997
replace morethanone=kids_in_1999>1 if born1_yob==1998

compress

sum born1_yob morethanone mage lfp lincome Zddot1st Zdot1st if lfp!=.
tab educ if lfp!=.,m



gen mage100=mage/100
gen mage100_2=mage2/100


//Begin Bootstrap
set seed 10101
global B 1000

gen beta_zddot=.
gen beta_zdot=.
gen beta_zbar0=.

qui forvalues b=1/$B {
	preserve
	bsample
	
	foreach iv of varlist Zddot1st Zdot1st Zbar1st {
		ivregress 2sls lfp (morethanone=`iv') mage100 mage100_2 i.educ i.born1_yob, robust
		local beta_`iv' = _b[morethanone]
	}
	restore
	
	replace beta_zddot=`beta_Zddot1st' in `b'
	replace beta_zdot=`beta_Zdot1st' in `b'
	replace beta_zbar0=`beta_Zbar1st' in `b'
}

//regressions using full sample
ivregress 2sls lfp (morethanone=Zddot1st) mage100 mage100_2 i.educ i.born1_yob, robust
local bhat_zddot=_b[morethanone]
ivregress 2sls lfp (morethanone=Zbar1st) mage100 mage100_2 i.educ i.born1_yob, robust
local bhat_zbar=_b[morethanone]

gen diff=beta_zbar0-beta_zddot
sum beta_zddot beta_zbar0 if diff<0

sum beta_zddot beta_zdot beta_zbar0

corr beta_zddot beta_zbar0, cov
local Var_zddot=r(Var_1)
local Var_zbar0=r(Var_2)
local Cov=r(cov_12)

dis `bhat_zddot'
dis `bhat_zbar'
local numerator=`bhat_zddot'-`bhat_zbar'
local denominator2=`Var_zddot'+`Var_zbar0'-2*`Cov'
local ttest=`numerator'/sqrt(`denominator2')

count if abs(beta_zbar0)>abs(beta_zddot)

* t-statistic
dis `ttest'

* p-value
dis 2*(1-normal(`ttest'))

* Figure B.1, left graph
twoway kdensity beta_zddot, lp(solid) lc(black) || kdensity beta_zbar0, lp(dash) lc(black)


