/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1993.dta, clear						
merge 1:1 id using lab1_1994.dta
drop _merge
merge 1:1 id using lab1_1995.dta
drop _merge
merge 1:1 id using lab1_1996.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificates.dta, clear
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//merge health information to bcertificates information
merge 1:1 id using "\\Elektra2\dnr2012-218\hospital_1987_2005.dta"
drop _merge

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1995			
drop if born1_yob>1998

//Generate lagged outcomes (two years before giving birth)
//////////////////////////////////////////////////////////

//labor outcomes
drop employed*

gen lfp=(lincome1993>0) if born1_yob==1995				
replace lfp=(lincome1994>0) if born1_yob==1996
replace lfp=(lincome1995>0) if born1_yob==1997
replace lfp=(lincome1996>0) if born1_yob==1998
replace lfp=. if lincome1993==. & born1_yob==1995
replace lfp=. if lincome1994==. & born1_yob==1996
replace lfp=. if lincome1995==. & born1_yob==1997
replace lfp=. if lincome1996==. & born1_yob==1998

gen income=lincome1993 if born1_yob==1995				
replace income=lincome1994 if born1_yob==1996
replace income=lincome1995 if born1_yob==1997
replace income=lincome1996 if born1_yob==1998
drop lincome*
gen lincome=log(income)

//health outcomes
gen hosp=nuvisits1993 if born1_yob==1995				
replace hosp=nuvisits1994 if born1_yob==1996
replace hosp=nuvisits1995 if born1_yob==1997
replace hosp=nuvisits1996 if born1_yob==1998
drop nuvisits*

//generate covariates:
//////////////////////
gen mage=1993-motheryob if born1_yob==1995				
replace mage=1994-motheryob if born1_yob==1996
replace mage=1995-motheryob if born1_yob==1997
replace mage=1996-motheryob if born1_yob==1998
gen mage2=mage^2
assert mage!=.

gen meduc=educ1993 if born1_yob==1995					
replace meduc=educ1994 if born1_yob==1996
replace meduc=educ1995 if born1_yob==1997
replace meduc=educ1996 if born1_yob==1998
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st


compress

gen mage100=mage/100
gen mage100_2=mage2/100


*** Table 1
gen agefb=born1_yob-motheryob
qui tab educ, gen(educ_tab)
tabstat agefb educ_tab* lfp lincome hosp Zddot1st Zdot1st if educ_tab1!=., c(s) s(mean sd) format


** Figure 2 and Table C.1
* F-stats are depicted in Figure 2 and point estimates of covariates in Table
* C.1

qui{
reg Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zddot


reg Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zdot

reg Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zbar
}

est table sobs_*, b star(0.1 0.05 0.01) stats(F N)




** Figure 3

* quadratic qolynomial in age at first birth (in paper)
* hospitalization (1st panel)
qui {
reg hosp Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zddot
reg hosp Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zdot
reg hosp Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zbar
}
est table hosp_*, b se keep(Z*)

* Labor force participation (2nd panel)
qui {
reg lfp Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zddot
reg lfp Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zdot
reg lfp Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zbar
}
est table lfp_*, b se keep(Z*)

* Log-labor income (3rd panel)
qui {
reg lincome Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zddot
reg lincome Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zdot
reg lincome Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zbar
}
est table linc_*, b se keep(Z*)

* Labor income (4th panel)
qui {
reg income Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zddot
reg income Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zdot
reg income Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zbar
}
est table inc_*, b  keep(Z*)





// most flexible specification using maternal age dummies(for referees)
* hospitalization 
qui {
reg hosp Zddot1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zddot
reg hosp Zdot1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zdot
reg hosp Zbar1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zbar
}
est table hosp_*, b se keep(Z*)

* Labor force participation 
qui {
reg lfp Zddot1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zddot
reg lfp Zdot1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zdot
reg lfp Zbar1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zbar
}
est table lfp_*, b se keep(Z*)

* Log-labor income 
qui {
reg lincome Zddot1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zddot
reg lincome Zdot1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zdot
reg lincome Zbar1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zbar
}
est table linc_*, b se keep(Z*)

* Labor income 
qui {
reg income Zddot1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zddot
reg income Zdot1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zdot
reg income Zbar1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zbar
}
est table inc_*, b  keep(Z*)


