/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 5000m
set more off, perm

cd "\\Elektra2\dnr2012-218\new 2014_12_09"

//prepare data:
///////////////

//merge all years with labour information
use lab1_1985.dta, clear
merge 1:1 id using lab1_1986.dta
drop _merge
merge 1:1 id using lab1_1987.dta
drop _merge
merge 1:1 id using lab1_1988.dta
drop _merge
save temp1987.dta, replace

//merge labor information to bcertificates information
use bcertificates.dta, clear
merge 1:1 id using temp1987.dta
drop _merge
erase temp1987.dta

//merge health information to bcertificates information
merge 1:1 id using "\\Elektra2\dnr2012-218\hospital_1987_2005.dta"
drop _merge

//sample restriction
////////////////////
drop if born1_yob==.
drop if born1_yob<1987
drop if born1_yob>1990

//some descriptives
///////////////////
tab nukids,m
sum nukids					//number of children at the end of the birth register data!!!!
assert lincome1985==. if employed_nov1985==.
assert lincome1986==. if employed_nov1986==.
assert lincome1987==. if employed_nov1987==.
assert lincome1988==. if employed_nov1988==.

//Generate lagged outcomes (two years before giving birth)
//////////////////////////////////////////////////////////

//labor outcomes
gen lfp=(lincome1985>0) if born1_yob==1987
replace lfp=(lincome1986>0) if born1_yob==1988
replace lfp=(lincome1987>0) if born1_yob==1989
replace lfp=(lincome1988>0) if born1_yob==1990
replace lfp=. if lincome1985==. & born1_yob==1987
replace lfp=. if lincome1986==. & born1_yob==1988
replace lfp=. if lincome1987==. & born1_yob==1989
replace lfp=. if lincome1988==. & born1_yob==1990

gen income=lincome1985 if born1_yob==1987
replace income=lincome1986 if born1_yob==1988
replace income=lincome1987 if born1_yob==1989
replace income=lincome1988 if born1_yob==1990
drop lincome*
gen lincome=log(income)

//health outcomes (no hospital data before 1987; so just two years here)
gen hosp=nuvisits1987 if born1_yob==1989
replace hosp=nuvisits1988 if born1_yob==1990
drop nuvisits*

//generate covariates:
//////////////////////
gen mage=1985-motheryob if born1_yob==1987
replace mage=1986-motheryob if born1_yob==1988
replace mage=1987-motheryob if born1_yob==1989
replace mage=1988-motheryob if born1_yob==1990
gen mage2=mage^2
assert mage!=.

gen meduc=educ1985 if born1_yob==1987
replace meduc=educ1986 if born1_yob==1988
replace meduc=educ1987 if born1_yob==1989
replace meduc=educ1988 if born1_yob==1990
drop educ*
rename meduc educ

//generate instruments:
///////////////////////
gen Zddot1st=twin1st
gen eddot1st=(sexcomp_twins1st==3)
replace eddot1st=. if Zddot1st==.
gen Zdot1st=Zddot1st-eddot1st
gen Zbar1st=Zdot1st-eddot1st


compress

gen mage100=mage/100
gen mage100_2=mage2/100


*** Table 1
gen agefb=born1_yob-motheryob
qui tab educ, gen(educ_tab)
tabstat agefb educ_tab* lfp lincome hosp Zddot1st Zdot1st if educ_tab1!=., c(s) s(mean sd) format


** Figure 2 and Table C.1
* F-stats are depicted in Figure 2 and point estimates of covariates in Table
* C.1

qui{
reg Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zddot


reg Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zdot

reg Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store sobs_Zbar
}

est table sobs_*, b star(0.1 0.05 0.01) stats(F N)




** Figure 3

* quadratic qolynomial in age at first birth (in paper)
* hospitalization (1st panel)
qui {
reg hosp Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zddot
reg hosp Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zdot
reg hosp Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store hosp_Zbar
}
est table hosp_*, b se keep(Z*)

* Labor force participation (2nd panel)
qui {
reg lfp Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zddot
reg lfp Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zdot
reg lfp Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store lfp_Zbar
}
est table lfp_*, b se keep(Z*)

* Log-labor income (3rd panel)
qui {
reg lincome Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zddot
reg lincome Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zdot
reg lincome Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store linc_Zbar
}
est table linc_*, b se keep(Z*)

* Labor income (4th panel)
qui {
reg income Zddot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zddot
reg income Zdot1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zdot
reg income Zbar1st mage100 mage100_2 i.educ i.born1_yob, robust
est store inc_Zbar
}
est table inc_*, b  keep(Z*)





// most flexible specification using maternal age dummies(for referees)
* hospitalization 
qui {
reg hosp Zddot1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zddot
reg hosp Zdot1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zdot
reg hosp Zbar1st i.motheryob i.educ i.born1_yob, robust
est store hosp_Zbar
}
est table hosp_*, b se keep(Z*)

* Labor force participation 
qui {
reg lfp Zddot1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zddot
reg lfp Zdot1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zdot
reg lfp Zbar1st i.motheryob i.educ i.born1_yob, robust
est store lfp_Zbar
}
est table lfp_*, b se keep(Z*)

* Log-labor income 
qui {
reg lincome Zddot1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zddot
reg lincome Zdot1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zdot
reg lincome Zbar1st i.motheryob i.educ i.born1_yob, robust
est store linc_Zbar
}
est table linc_*, b se keep(Z*)

* Labor income 
qui {
reg income Zddot1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zddot
reg income Zdot1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zdot
reg income Zbar1st i.motheryob i.educ i.born1_yob, robust
est store inc_Zbar
}
est table inc_*, b  keep(Z*)




