/****************************************************************/
/* Farbmacher et al, 2017; Increasing the credibility of the twin birth instrument */
/****************************************************************/


clear all
set mem 15000m
set more off

cd "T:\new 2014_12_09"

* Clean, select and re-label variables in the multi-generational register
use flergen_2007, clear
dis _N
keep moder_lopnrfk fader_lopnrfk barn_lopnrfk kon fodelsear fodelseman fodelsearfar fodelsearmor ordnrmor	
destring moder_lopnrfk, replace
destring fodelsearmor, replace
destring fader_lopnrfk, replace
destring fodelsearfar, replace
destring barn_lopnrfk, replace
destring fodelsear, replace
destring fodelseman, replace

gen parentsunknown=(moder_lopnrfk ==. & fader_lopnrfk ==.)
	
drop if moder_lopnrfk ==. & fader_lopnrfk == . 
drop parentsunknown
recode kon (2 = 0)
rename kon boy
rename moder_lopnrfk motherid
rename fader_lopnrfk fatherid
rename barn_lopnrfk id								
rename fodelsear yob
rename fodelseman mob
rename ordnrmor birthorder

gen fatheryob=fodelsearfar
gen motheryob=fodelsearmor
		
gen female=1-boy
drop boy
	
foreach x in motherid fatherid id yob mob female fatheryob motheryob birthorder {
	label variable `x' ""
}
compress
drop birthorder

* Dataset with mothers only (wide format)
dis _N
drop if motherid == .
gen multi_yob =  fodelsearmor	
drop fodelsearfar fodelsearmor
rename id child_id
bysort motherid child_id: drop if _n>1 & child_id != .	// remove duplicates 
drop fatherid 
rename motherid id
sort id yob									
bysort id: gen nr = _n 
save _tt, replace										// remove observations with incorrect birthyearinformation
bysort id: keep if multi_yob != multi_yob[1] 			
keep id
bysort id: keep if _n == 1
merge 1:m id using _tt	
drop if _merge == 3
drop _merge
drop fatheryob multi_yob
compress
reshape wide child_id yob mob female, i(id) j(nr)			// Wide format
tab yob1,m		

//generate indicator for more than twins (twin birth at first birth)
gen morethantwins1st=0
local j=1
local k=`j'+1
local m=`j'+2
replace morethantwins1st=1 if yob`j'==yob`k' & yob`k'==yob`m' & mob`j'==mob`k' & mob`k'==mob`m' & yob`j'!=.	

//generate twin indicator (twin birth at first birth)
gen twin1st=0
gen samesex_twin1st=0
gen sexcomp_twins1st=.
local j=1
local k=`j'+1 
replace twin1st=1 if yob`j'==yob`k' & mob`j'==mob`k' & yob`j'!=.
replace samesex_twin1st=1 if yob`j'==yob`k' & mob`j'==mob`k' & yob`j'!=. & female`j'==female`k'
replace sexcomp_twins1st=1 if yob`j'==yob`k' & mob`j'==mob`k' & yob`j'!=. & female`j'==female`k' & female`j'==0		//two boys
replace sexcomp_twins1st=2 if yob`j'==yob`k' & mob`j'==mob`k' & yob`j'!=. & female`j'==female`k' & female`j'==1		//two girls
replace sexcomp_twins1st=3 if yob`j'==yob`k' & mob`j'==mob`k' & yob`j'!=. & female`j'!=female`k'						//mixed

cap label def sexcomp_twins 1 "two boys" 2 "two girls" 3 "mixed"
label val sexcomp_twins1st sexcomp_twins 

assert yob1!=.
assert yob1<=yob2 if yob2!=.
assert yob2<=yob3 if yob2!=. & yob3!=.			
assert yob1<=yob2
assert yob1<=yob3
assert yob1<=yob4
assert yob1<=yob5

rename yob1 born1_yob
rename yob2 born2_yob

set more off
drop yob*

drop female* mob* child_id*



//Analysis:
drop if  born1_yob<1940


gen momage=born1_yob-motheryob
recode momage (13/25= 1 "13-25") (26/60= 2 "26-60") ///
, gen(momagecat)

gen dizygotic=2*(twin1st-samesex_twin1st)
gen monozygotic=twin1st-dizygotic


save sweden_graphs_data, replace

 * Figure 1
collapse (mean) twin1st  dizygotic monozygotic , by(momagecat born1_yob)

rename twin1st twinrate
rename born1_yob year

tw line  twinrate  dizygotic monozygotic year if momagecat==1, xt(First Child Year of Birth) yt(Twinning rate) t(Mothers aged 13 to 25)   /// 
leg(lab(1 "First born twins") lab(2 "Dizygotic") lab(3 "Monozygotic"))  ///
 lp(solid dash top) lw(thick) xsca(noext) scheme(s2mono) t("Maternal Age <=25")
graph save "T:\Labour do-files\twinrate_overtime_13to25.gph", replace

tw line  twinrate  dizygotic monozygotic year if momagecat==2, xt(First Child Year of Birth) yt(Twinning rate) t(Mothers aged 13 to 25)   /// 
leg(lab(1 "First born twins") lab(2 "Dizygotic") lab(3 "Monozygotic"))  ///
 lp(solid dash top) lw(thick) xsca(noext) scheme(s2mono) t("Maternal Age >=26")
graph save "T:\Labour do-files\twinrate_overtime_26to60.gph", replace

cd "T:\Labour do-files\"
graph combine twinrate_overtime_13to25.gph twinrate_overtime_26to60.gph, r(1) ycom xcom

 * Figure 4
 cd "T:\new 2014_12_09"
use sweden_graphs_data, clear
 collapse (mean) twin1st dizygotic monozygotic , by(momage)

rename twin1st twinrate

* over mothersage at first birth:
tw line  twinrate  dizygotic monozygotic momage if momage>20 & momage<45, xt(Mother's age at first birth) yt(Twinning rate)    /// 
leg(lab(1 "First born twins") lab(2 "Dizygotic") lab(3 "Monozygotic"))  ///
 lp(solid dash top) lw(thick) xsca(noext) scheme(s2mono)
graph save "T:\Labour do-files\twinrate_maternalage.gph", replace




