
program define mc_jive2, rclass
	syntax, beta(real) obs(real) rho(real) ivs(real)
qui {
drop _all
set obs `obs'
forvalues i=1/`ivs' {
	gen z`i'=rnormal()
}

sca rho=`rho'

gen v=rnormal()
gen u=rho*v+sqrt(1-rho^2)*rnormal()

gen xvar=0
forvalues i=1/`ivs' {
	replace xvar = xvar + `beta'*z`i'
}

gen x = xvar + v

gen xb = 0*x
gen y = xb + u
}

*** estimation ***

jive y (x=z*),ujive2 robust

end
