
program define mc_ivreg_2sls, rclass
	syntax, beta(real) obs(real) rho(real) ivs(real)
qui {
drop _all
set obs `obs'
forvalues i=1/`ivs' {
	gen z`i'=rnormal()
}

sca rho=`rho'

gen v=rnormal()
gen u=rho*v+sqrt(1-rho^2)*rnormal()

gen xvar=0
forvalues i=1/`ivs' {
	replace xvar = xvar + `beta'*z`i'
}

gen x = xvar + v

gen xb = 0*x
gen y = xb + u
}

*** estimation ***

ivregress 2sls y (x=z*), robust

end
