*!version 1.2 Helmut Farbmacher (November 2010)

prog ivreg3, eclass
version 10

syntax varlist [if] [in], [endog(varlist) exog(varlist) nwind NOCONstant overid hybrid first from(string)]
marksample touse
markout `touse' `exog' `endog'
gettoken lhs varlist : varlist
loc rhs: list varlist | endog
loc z: list varlist | exog
loc z: list z-endog
qui sum `lhs' if `touse'
tempname obs
sca `obs'=r(N)

//remove collinearity
if "`noconstant'"!="" { 
	local constan "noconstant" 
}
local coll `s(collinear)'
	_rmcoll `rhs' if `touse', ///
		`constan' `coll' 
	local rhs `r(varlist)'
	
local coll `s(collinear)'
	_rmcoll `z' if `touse', ///
		`constan' `coll' 
	local z `r(varlist)'

//initial values
qui regress `lhs' `rhs' if `touse', `noconstant'
mat bstart=e(b)

//from() option overrides other initial values
local np : word count `rhs'	
if "`from'" != "" {
	capture confirm matrix `from'
	if _rc {
		di as error "matrix `from' not found"
		exit 480
	}
	if "`noconstant'"=="" {
		if `=colsof(`from')' != `np'+1 {
			di as error "from() matrix must have as many columns as parameters in model"
			exit 480
		}
	}
	else {
		if `=colsof(`from')' != `np' {
			di as error "from() matrix must have as many columns as parameters in model"
			exit 480
		}
	}
	matrix bstart = `from'
	matrix colnames bstart = `rhs'
}

if "`noconstant'"!="" {
	mat b=J(1,`:word count `rhs'',0)
	mat V=J(`:word count `rhs'',`:word count `rhs'',0)
	matname b `rhs',c(.)
	matname V `rhs',c(.)
	matname V `rhs',r(.)
	tempname nu_rhs nu_moments
	scalar `nu_rhs'=`:word count `rhs''
	scalar `nu_moments'=`:word count `z''
	mat Hes123=J(`:word count `rhs'',`:word count `rhs'',0)
}
else {
	mat b=J(1,`:word count `rhs' _cons',0)
	mat V=J(`:word count `rhs' _cons',`:word count `rhs' _cons',0)
	matname b `rhs' _cons,c(.)
	matname V `rhs' _cons,c(.)
	matname V `rhs' _cons,r(.)
	tempname nu_rhs nu_moments
	scalar `nu_rhs'=`:word count `rhs' _cons'
	scalar `nu_moments'=`:word count `z' _cons'
	mat Hes123=J(`:word count `rhs' _cons',`:word count `rhs' _cons',0)
}

//Model is not identified
if `nu_rhs'>`nu_moments' {
	dis in red "There are more parameters than instruments. Model is not identified."
	exit 481
}

//Check whether endog() is specified
if "`endog'"=="" {
	dis "{txt}note: endog()-option not used. All variables of the model are used to construct moment conditions."
}

//nocons
mat nocons123=0
if "`noconstant'"!="" {
	mat nocons123=1
}

//hybrid
mat hybrid123=0
if "`hybrid'"!="" {
	mat hybrid123=1
}

dis ""
dis "{txt}Continuous updating estimator"

if "`first'"!="" {
//call first step
	dis ""
	dis "{txt}Step {res}1"
	mata: ivp_first("`lhs'","`rhs'","`z'","`touse'")
}

//call second step
	mat nwind = 0
	if "`nwind'"!=""{
		mat nwind = 1
	}
	dis ""
if "`first'"!="" {
	dis "{txt}Step {res}2"
	mat bstart=b
}
	mata: ivp2_cue("`lhs'","`rhs'","`z'","`b'","`touse'","V")

if "`nwind'"!="" {
	mat beta123=b
}

//output
eret post b V, e(`touse') depname(`lhs')
eret scalar Q = scalar(Qfincrit)
eret scalar converged=scalar(Qconverged)
eret scalar N = `obs'
eret scalar par = `nu_rhs'
eret scalar moments = `nu_moments'
eret di

if "`nwind'"!="" {
	dis "Calculating Newey and Windmeijer's (2009) standard errors..."

	tempvar touse
	gen `touse'=e(sample)

	if "`noconstant'"!="" {
		mat Vnew=J(`:word count `rhs'',`:word count `rhs'',0)
		matname Vnew `rhs',c(.)
		matname Vnew `rhs',r(.)
	}
	else {
		mat Vnew=J(`:word count `rhs' _cons',`:word count `rhs' _cons',0)
		matname Vnew `rhs' _cons,c(.)
		matname Vnew `rhs' _cons,r(.)
	}

	mata: ivp2_nwind("`lhs'","`rhs'","`z'","`touse'")
	eret repost V=Vnew
	eret di
}

if "`overid'"!="" {
	eret scalar J_df = `nu_moments'-`nu_rhs'
	if e(J_df)!=0 {
		eret scalar J = 2*e(Q)*`obs'
		eret scalar J_p = chi2tail(e(J_df),e(J))
	}
}
if "`noconstant'"!="" {
	dis "{txt}Instruments{txt}: {res}`z'"
}
else {
	dis "{txt}Instruments{txt}: {res}`z' _cons"
}
dis "{txt}Number of obs{txt} = " as result e(N)
if "`overid'"!="" & e(J_df)!=0 {
	dis ""
	dis "{txt}Test of overidentifying restriction:"
	dis ""
	dis "{txt}Hansen's J chi2(" as res e(J_df) "{txt}) = " as res %5.4f e(J) as txt " (p = " as res %5.4f e(J_p) "{txt})"
}
end

//MATA//
//first step
mata:
void civp_first(todo,b,crit,g,H)
{
external y,X,Z,W
m=(1/rows(Z))*quadcross(Z,((y :- X*b')))
crit=quadcross(quadcross(m,W)',m)
g=(2/rows(Z))*quadcross(m,W)*quadcross(Z,(-X))
C=(1/rows(Z))*quadcross(Z,(-X))		
H=quadcross(C,W)*C
}
void ivp_first(string scalar lhs,string scalar rhs,string scalar z,string scalar ok)
{
external y,X,Z,W
y=st_data(.,tokens(lhs),ok)
nocons=st_matrix("nocons123")
if (nocons==1) {
	X=st_data(.,tokens(rhs),ok)
	Z=st_data(.,tokens(z),ok)
}
if (nocons==0) {
	cons=J(rows(y),1,1)
	X=st_data(.,tokens(rhs),ok),cons
	Z=st_data(.,tokens(z),ok),cons
}
W=rows(Z)*luinv(quadcross(Z,Z))
init=st_matrix("bstart")
S=optimize_init()
optimize_init_evaluator(S,&civp_first())
optimize_init_which(S,"min")
optimize_init_evaluatortype(S,"d2")
optimize_init_params(S,init)
p=optimize(S)
st_replacematrix("b",p)
}
end

//second step of CUE
mata:
void civp2_cue(todo,b,crit,g,H)
{
external y,X,Z,W
external scalar par
m=(1/rows(Z))*quadcross(Z,((y :- X*b')))
l=(quadcross(Z,(((y :- X*b'):*(y :- X*b')):*Z)))
W=rows(Z)*luinv(l)
crit=0.5*quadcross(quadcross(m,W)',m)
g=J(1,par,.)		
for (i=1; i<=par; i++) {
	//fill gradient vector	
	G_i=(1/rows(Z))*quadcross(Z,((-X[.,i])))
	first_i=quadcross(quadcross(G_i,W)',m)
	xu=((-X[.,i])):*(y :- X*b')	
	Gm_i=(1/rows(Z))*(quadcross(Z,(xu:*Z)))
	lambda_i=Gm_i
	second_i=quadcross(quadcross(quadcross(quadcross(m,W)',lambda_i)',W)',m)
	f_i=(first_i-second_i)
	g[i]=f_i
	}
}

void ivp2_cue(string scalar lhs,string scalar rhs,string scalar z,string scalar beta, string scalar ok,string scalar V)
{
external y,X,Z,W
external scalar par
y=st_data(.,tokens(lhs),ok)
nocons=st_matrix("nocons123")
if (nocons==1) {
	X=st_data(.,tokens(rhs),ok)
	Z=st_data(.,tokens(z),ok)
}
if (nocons==0) {
	cons=J(rows(y),1,1)
	X=st_data(.,tokens(rhs),ok),cons
	Z=st_data(.,tokens(z),ok),cons
}
par=cols(X)
init=st_matrix("bstart")
W2=Z:*(y:-X*init')
W=luinv((1/rows(Z))*(W2'*W2))
S=optimize_init()
optimize_init_evaluator(S,&civp2_cue())
optimize_init_which(S,"min")
optimize_init_evaluatortype(S,"d1")
optimize_init_params(S,init)
hybrid=st_matrix("hybrid123")
if (hybrid==1) { 
	optimize_init_singularHmethod(S, "hybrid")
}
p=optimize(S)
fincrit=optimize_result_value(S)
converged=optimize_result_converged(S)

//calculate standard VCE
Hes=optimize_result_Hessian(S)		
W2=Z:*(y:-X*init')
D = (1/rows(Z))*quadcross(Z,(-X))
W2=Z:*(y :- X*p')			
W=luinv((1/rows(Z))*(quadcross(W2,W2))) 
G = quadcross(quadcross(D,W)',D)
vce=(1/rows(Z))*luinv(G)

st_replacematrix("Hes123",Hes)
st_replacematrix("b",p)
st_replacematrix(V,vce)
st_numscalar("Qfincrit",fincrit)
st_numscalar("Qconverged",converged)
}

//calculate Newey and Windmeijer's (2009) SE
void ivp2_nwind(string scalar lhs,string scalar rhs,string scalar z, string scalar ok)
{
external y,X,Z,W
external scalar par
y=st_data(.,tokens(lhs),ok)
nocons=st_matrix("nocons123")
if (nocons==1) {
	X=st_data(.,tokens(rhs),ok)
	Z=st_data(.,tokens(z),ok)
}
if (nocons==0) {
	cons=J(rows(y),1,1)
	X=st_data(.,tokens(rhs),ok),cons
	Z=st_data(.,tokens(z),ok),cons
}

p=st_matrix("beta123")
Hes=st_matrix("Hes123")	
mvar=(1/rows(Z))*quadcross(Z,((y :- X*p')))
W2var=Z:*((y :- X*p'))
Wvar=luinv((1/rows(Z))*(quadcross(W2var,W2var)))
S=J(cols(Z),par,.)		
for (i=1; i<=par; i++) {
	//fill S		
	s1_i=(1/rows(Z))*quadcross(Z,((-X[.,i])))		
	xu=((-X[.,i])):*(y :- X*p')	
	Gm_i=(1/rows(Z))*(quadcross(Z,(xu:*Z)))	
	lambda_i=Gm_i
	s2_i=quadcross(quadcross(lambda_i',Wvar)',mvar)
	s_i=s1_i-s2_i
	S[.,i]=s_i
	}
middle=quadcross(quadcross(S,Wvar)',S)
vce=(1/rows(Z))*(quadcross(quadcross(luinv(Hes)',middle)',luinv(Hes)))
_makesymmetric(vce)

st_replacematrix("Vnew",vce)
}
end
