clear all
set mem 50m
set more off
prog drop _all
cap log close
set logtype text
set maxiter 50
cd "C:\Helmut_Farbmacher\JAE ivreg3\Graphs\Results" //directory has to be changed

*** prepare dataset
set obs 1000
foreach i in 2sls jive2 cuec cuec_conv cue cue_conv {
	gen med_bias_`i'=.
	gen rej_`i'=.
}
gen obs=.
gen rho=.
save "Simulation_rho.dta", replace

log using "Simulation_rho", replace

*** set seed
local seed 9090

local row=0
foreach n in 25 50 100 200 400 800 {
forvalues rho=0.01(0.02)0.991 {
local row=`row'+1

local rep 10000			//no. of replications
local N `n'				//no. of obs.
local ivs 5				//no. of instruments
local r `rho'			//rho
local CP 10				//concentration parameter
local b=sqrt(`CP'/(`ivs'*`N'))
local r10=round(`r'*10,1)

*******************************************************

use "Simulation_rho.dta", clear
replace rho=`r' in `row'
save "Simulation_rho.dta", replace

dis ""
dis "************************"
dis ""
dis "{txt}Seed: " as res `seed'
dis "{txt}No. of replications: " as res `rep'
dis "{txt}No. of obs.: " as res `N'
dis "{txt}No. of instruments: " as res `ivs'
dis "{txt}Rho: " as res `r'
dis "{txt}CP: " as res `CP'
dis "{txt}b:" as res `b' 

clear all
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_ivreg_2sls, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)
sum _b_x,d 
sca med_bias=r(p50)
sum rej
sca rej=r(mean)
***
use "Simulation_rho.dta", clear
replace obs=`N' in `row'
replace med_bias_2sls=scalar(med_bias) in `row'
replace rej_2sls=scalar(rej) in `row'
save "Simulation_rho.dta", replace
*************************************
clear all 
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_jive2, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)  
sum _b_x,d 
sca med_bias=r(p50)
sum rej
sca rej=r(mean)
***
use "Simulation_rho.dta", clear
replace obs=`N' in `row'
replace med_bias_jive2=scalar(med_bias) in `row'
replace rej_jive2=scalar(rej) in `row'
save "Simulation_rho.dta", replace
*************************************
clear all
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_ivreg3_nwind, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)  
sum _b_x,d 
sca med_bias=r(p50)
sum rej
sca rej=r(mean)
sum _b_x if _b_x<10000,d 
sca med_bias_conv=r(p50)
sum rej if _b_x<10000
sca rej_conv=r(mean)
***
use "Simulation_rho.dta", clear
replace obs=`N' in `row'
replace med_bias_cuec=scalar(med_bias) in `row'
replace rej_cuec=scalar(rej) in `row'
replace med_bias_cuec_conv=scalar(med_bias_conv) in `row'
replace rej_cuec_conv=scalar(rej_conv) in `row'
save "Simulation_rho.dta", replace
*************************************
clear all
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_ivreg3, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)  
sum _b_x,d 
sca med_bias=r(p50)
sum rej
sca rej=r(mean)
sum _b_x if _b_x<10000,d 
sca med_bias_conv=r(p50)
sum rej if _b_x<10000
sca rej_conv=r(mean)
***
use "Simulation_rho.dta", clear
replace obs=`N' in `row'
replace med_bias_cue=scalar(med_bias) in `row'
replace rej_cue=scalar(rej) in `row'
replace med_bias_cue_conv=scalar(med_bias_conv) in `row'
replace rej_cue_conv=scalar(rej_conv) in `row'
save "Simulation_rho.dta", replace
}
}

***

log close


