clear all
set mem 50m
set more off
prog drop _all
cap log close
set logtype text
set maxiter 50
cd "C:\Helmut_Farbmacher\JAE ivreg3\Table 1 2 - CUEC\Results" //directory has to be changed

log using "NW2009_cuec", replace

*** set seed
local seed 9090

foreach iv in 3 15 {
foreach rho in 0.3 0.5 0.9 {
foreach c in 10 20 35 {	

local rep 10000			//no. of replications
local N 200				//no. of obs.
local ivs `iv'			//no. of instruments
local r `rho'			//rho
local CP `c'			//concentration parameter
local b=sqrt(`CP'/(`ivs'*`N'))
local r10=round(`r'*10,1)

*******************************************************

dis ""
dis "************************"
dis ""
dis "{txt}Seed: " as res `seed'
dis "{txt}No. of replications: " as res `rep'
dis "{txt}No. of obs.: " as res `N'
dis "{txt}No. of instruments: " as res `ivs'
dis "{txt}Rho: " as res `r'
dis "{txt}CP: " as res `CP'
dis "{txt}b:" as res `b' 

local bstart=-2
dis "{txt}starting value of beta is " as res `bstart'
clear all
mat b1=(`bstart',0)
simulate _b _se Q_1=e(Q), reps(`rep') seed(`seed') nodots: mc_ivreg3_sim, beta(`b') obs(`N') rho(`r') ivs(`ivs') start(b1)
gen rej_1=(abs(_b_x/_se_x) > 1.96) 
rename _b_x _b_x_1
gen id=_n
keep id _b_x_? rej_? _eq2_Q_?
sort id
qui save "sim_minus2.dta", replace

***

local bstart=-1
dis "{txt}starting value of beta is " as res `bstart'
clear all
mat b1=(`bstart',0)
simulate _b _se Q_2=e(Q), reps(`rep') seed(`seed') nodots: mc_ivreg3_sim, beta(`b') obs(`N') rho(`r') ivs(`ivs') start(b1)
gen rej_2=(abs(_b_x/_se_x) > 1.96) 
rename _b_x _b_x_2
gen id=_n
keep id _b_x_? rej_? _eq2_Q_?
sort id
qui save "sim_minus1.dta", replace

***

local bstart=0
dis "{txt}starting value of beta is " as res `bstart'
clear all
mat b1=(`bstart',0)
simulate _b _se Q_3=e(Q), reps(`rep') seed(`seed') nodots: mc_ivreg3_sim, beta(`b') obs(`N') rho(`r') ivs(`ivs') start(b1)
gen rej_3=(abs(_b_x/_se_x) > 1.96) 
rename _b_x _b_x_3
gen id=_n
keep id _b_x_? rej_? _eq2_Q_?
sort id
qui save "sim_0.dta", replace

***

local bstart=1
dis "{txt}starting value of beta is " as res `bstart'
clear all
mat b1=(`bstart',0)
simulate _b _se Q_4=e(Q), reps(`rep') seed(`seed') nodots: mc_ivreg3_sim, beta(`b') obs(`N') rho(`r') ivs(`ivs') start(b1)
gen rej_4=(abs(_b_x/_se_x) > 1.96) 
rename _b_x _b_x_4
gen id=_n
keep id _b_x_? rej_? _eq2_Q_?
sort id
qui save "sim_1.dta", replace

***

local bstart=2
dis "{txt}starting value of beta is " as res `bstart'
clear all
mat b1=(`bstart',0)
simulate _b _se Q_5=e(Q), reps(`rep') seed(`seed') nodots: mc_ivreg3_sim, beta(`b') obs(`N') rho(`r') ivs(`ivs') start(b1)
gen rej_5=(abs(_b_x/_se_x) > 1.96) 
rename _b_x _b_x_5
gen id=_n
keep id _b_x_? rej_? _eq2_Q_?
sort id
qui save "sim_2.dta", replace

***
 
qui merge 1:1 id using "sim_1.dta"
assert _merge==3
drop _merge
qui merge 1:1 id using "sim_0.dta"
assert _merge==3
drop _merge
qui merge 1:1 id using "sim_minus1.dta"
assert _merge==3
drop _merge
qui merge 1:1 id using "sim_minus2.dta"
assert _merge==3
drop _merge

qui reshape long _b_x_ rej_ _eq2_Q_, i(id) j(sim)
rename _eq2_Q_ Q
rename _b_x_ b
rename rej_ rej

sort id Q
qui by id: gen smallest=(_n==1)
qui keep if smallest==1

dis "{txt}sum b if abs(b)<100000,d"
sum b if abs(b)<100000,d 
dis ""
dis "{txt}sum rej if abs(b)<100000"
sum rej if abs(b)<100000
dis ""
dis "{txt}sum b,d "
sum b,d 
dis ""
dis "{txt}sum rej"
sum rej
}
}
}

***

log close
