clear all
set mem 50m
set more off
prog drop _all
cap log close
set logtype text
set maxiter 50
cd "C:\Helmut_Farbmacher\JAE ivreg3\Table 1 2 - 2SLS JIVE2\Results" //directory has to be changed

log using "NW2009_2sls_jive", replace

*** set seed
local seed 9090

foreach iv in 3 15 {
foreach rho in 0.3 0.5 0.9 {
foreach c in 10 20 35 {		

local rep 10000			//no. of replications
local N 200				//no. of obs.
local ivs `iv'			//no. of instruments
local r `rho'			//rho
local CP `c'			//concentration parameter
local b=sqrt(`CP'/(`ivs'*`N'))
local r10=round(`r'*10,1)

*******************************************************

dis ""
dis "************************"
dis ""
dis "{txt}Seed: " as res `seed'
dis "{txt}No. of replications: " as res `rep'
dis "{txt}No. of obs.: " as res `N'
dis "{txt}No. of instruments: " as res `ivs'
dis "{txt}Rho: " as res `r'
dis "{txt}CP: " as res `CP'
dis "{txt}b:" as res `b' 

clear all
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_ivreg_2sls, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)
dis "sum _b_x,d"
sum _b_x,d 
dis ""
dis "sum rej"
sum rej

clear all 
simulate _b _se, reps(`rep') seed(`seed') nodots: mc_jive2, beta(`b') obs(`N') rho(`r') ivs(`ivs')
gen rej=(abs(_b_x/_se_x) > 1.96)  
dis "sum _b_x,d"
sum _b_x,d 
dis ""
dis "sum rej"
sum rej
}
}
}

***

log close
