new;
cls;

/*  Cem Ertur and Antonio Musolesi, 
"Weak and Strong Cross-Sectional Dependence: a Panel Data Analysis of International Technology Diffusion", 
Journal of Applied Econometrics, forthcoming. */	


/** This GAUSS program allows the estimation of the bias-corrected version of alpha given by equation (13) 
in Bailey et al. (2015) for the main variables under study: ltfp, lrd, lhc and lwerd1. 
It uses the program code_ord_holm.src which were made available by Natalia Bailey, George Kapetanios, and M. Hashem Pesaran 
in the Journal of Applied Econometrics Data Archive at:  http://qed.econ.queensu.ca/jae/forthcoming/bailey-kapetanios-pesaran/
The files ltfp_res.txt, lrd_res.txt, lhc_res.txt and lwerd1_res.txt contain the (reshaped) data in a matrix form N*T.  *******/


											   
#include code_ord_holm.src;

/*********** Input Data *******************/
load x_ltfp[34,24]="ltfp_res.txt"; /* ltfp */
load x_lrd[34,24]="lrd_res.txt"; /* lrd */
load x_lhc[34,24]="lhc_res.txt"; /* lhc */
load x_lwerd1[34,24]="lwerd1_res.txt"; /* lwerd1 */






/*********** Data Preparation *******************/
a_size=0.1;

/* Standardise data. The required procedure is below at the end of this document. Please run it first. */
x_ltfpst=standx(x_ltfp);
x_lrdst=standx(x_lrd);
x_lhcst=standx(x_lhc);
x_lwerd1st=standx(x_lwerd1);







/*********** CD test. The required procedure is below at the end of this document. Please run it first. *************/
{t_ltfp,n_ltfp,cd_ltfp}=CD(x_ltfp);
{t_lrd,n_lrd,cd_lrd}=CD(x_lrd);
{t_lhc,n_lhc,cd_lhc}=CD(x_lhc);
{t_lwerd1,n_lwerd1,cd_lwerd1}=CD(x_lwerd1);










/********** Exponent of cross-sectional lwerd1endence (bias-corrected version) ************/

{rej,a_ltfp,v_f_ltfp,rej,rej,ggg_ltfp,s_ltfp,rej}=atilde(x_ltfpst,a_size);
{rej,a_lrd,v_f_lrd,rej,rej,ggg_lrd,s_lrd,rej}=atilde(x_lrdst,a_size);
{rej,a_lhc,v_f_lhc,rej,rej,ggg_lhc,s_lhc,rej}=atilde(x_lhcst,a_size);
{rej,a_lwerd1,v_f_lwerd1,rej,rej,ggg_lwerd1,s_lwerd1,rej}=atilde(x_lwerd1st,a_size);





om_ltfp=1.65*((1/t_ltfp)*(v_f_ltfp)+(4/n_ltfp)*(n_ltfp^(1-a_ltfp)*s_ltfp/(ggg_ltfp-1)))^(1/2)/(2*ln(n_ltfp)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_lrd=1.65*((1/t_lrd)*(v_f_lrd)+(4/n_lrd)*(n_lrd^(1-a_lrd)*s_lrd/(ggg_lrd-1)))^(1/2)/(2*ln(n_lrd)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_lhc=1.65*((1/t_lhc)*(v_f_lhc)+(4/n_lhc)*(n_lhc^(1-a_lhc)*s_lhc/(ggg_lhc-1)))^(1/2)/(2*ln(n_lhc)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_lwerd1=1.65*((1/t_lwerd1)*(v_f_lwerd1)+(4/n_lwerd1)*(n_lwerd1^(1-a_lwerd1)*s_lwerd1/(ggg_lwerd1-1)))^(1/2)/(2*ln(n_lwerd1)); /* 90% CI: 1.65, 95% CI: 1.96 */



/* ***************************** Output ******************************* */

"";"";
"Table 3 :: CD statistics, Exponents of CSD (alpha) and s.e. ";
"n_ltfp";n_ltfp;
"t_ltfp";t_ltfp;
"cd_ltfp";cd_ltfp;
"a_ltfp"; (a_ltfp-om_ltfp)~a_ltfp~(a_ltfp+om_ltfp);
"";"";
"n_lrd";n_lrd;
"t_lrd";t_lrd;
"cd_lrd";cd_lrd;
"a_lrd"; (a_lrd-om_lrd)~a_lrd~(a_lrd+om_lrd);
"";"";
"n_lhc";n_lhc;
"t_lhc";t_lhc;
"cd_lhc";cd_lhc;
"a_lhc"; (a_lhc-om_lhc)~a_lhc~(a_lhc+om_lhc);
"";"";
"n_lwerd1";n_lwerd1;
"t_lwerd1";t_lwerd1;
"cd_lwerd1";cd_lwerd1;
"a_lwerd1"; (a_lwerd1-om_lwerd1)~a_lwerd1~(a_lwerd1+om_lwerd1);





/* ******************************************************** Procedures ******************************************************* */
/* Standardise data */
proc standx(x);
local n,t,m_x,std_x,x_stand;
t=rows(x);
n=cols(x);
m_x=meanc(x)';
std_x=stdc(x)';
x_stand=zeros(t,n);
for i(1,n,1);
x_stand[.,i]=(x[.,i]-m_x[1,i])/std_x[1,i];
endfor;
retp(x_stand);
endp;

/* Pesaran, M.H. (2015). Testing Weak Cross-sectional Dependence in Large Panels*/
/* CD test */
proc (3)=CD(x);
local n,t,interc,coef,x_prel,m_x,std_x,little_x,rho_var_bar,cd;
t=rows(x);
n=cols(x);
interc=ones(t,1);
coef=inv(interc'*interc)*interc'*x;
x_prel=x-interc*coef; 
m_x=meanc(x_prel)';
std_x=stdc(x_prel)';
little_x=zeros(t,n); 
for j(1,n,1);
little_x[.,j]=x_prel[.,j]/std_x[1,j];
endfor;
rho_var_bar=(meanc(sumc(little_x').^2)-n)/(n*(n-1));
cd=sqrt((t)/2)*sqrt(n*(n-1))*rho_var_bar;
retp(t,n,cd);
endp;
