
% Cem Ertur and Antonio Musolesi, 
% "Weak and Strong Cross-Sectional Dependence: a Panel Data Analysis of International Technology Diffusion", 
% Journal of Applied Econometrics, forthcoming.




% This MATLAB program allows the estimation of the spatial error model for all the specifications 
% with the results presented in table 6. It uses the following MATLAB codes
%       distarc.m and distarc.m  generate the weight matrix
%	sem_panel_FE_LY.m   computes the spatial error model estimates 
%	prt.m and prt_fe.m allow printing the results of estimation

% The file longlat24.txt contains longitudes and latitudes.


%The file spatialti24.txt contains the data sorted by time first and then by country.
% T=34 (1971-2004), N=24 
%  variables:
% col 1: country					
% col 2: year
% col 3: ltfp
% col 4: lrdg7
% col 5: lrdnog7
% col 6: lwerd1g7
% col 7: lwerd1nog7
% col 8: lhcg7
% col 9: lhcnog7
% col 10: lsflpg7
% col 11: lsflpnog7
% col 12: mlsflpg7
% col 13: mlsflpnog7
% col 14: mlwerd1g7
% col 15: mlwerd1nog7



											

clear all;
load longlat24.txt;

lat=longlat24(:,2); long=longlat24(:,1);




load spatialti24.txt;

ltfp=spatialti24(:,3);
lrdg7=spatialti24(:,4);
lrdnog7=spatialti24(:,5);
lwerd1g7=spatialti24(:,6);
lwerd1nog7=spatialti24(:,7);
lhcg7=spatialti24(:,8);
lhcnog7=spatialti24(:,9);
lsflpg7=spatialti24(:,10);
lsflpnog7=spatialti24(:,11);
mlsflpg7=spatialti24(:,12);
mlsflpnog7=spatialti24(:,13);
mlwerd1g7=spatialti24(:,14);
mlwerd1nog7=spatialti24(:,15);









%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% create W exp(1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% k=1
we=dexparc(lat,long,1);
wep=kron(eye(34,34),we);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Estimation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%







x1=[lrdg7,lrdnog7, lwerd1g7, lwerd1nog7, lhcg7, lhcnog7 ];
vnames=strvcat('ltfp', 'lrdg7','lrdnog7', 'lwerd1g7', 'lwerd1nog7', 'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM1 = sem_panel_FE_LY(ltfp,x1,we,24,info);
prt(SEM1,vnames);





x2=[lrdg7,lrdnog7, lsflpg7, lsflpnog7, lhcg7, lhcnog7 ];
vnames=strvcat('ltfp','lrdg7', 'lrdnog7', 'lsflpg7', 'lsflpnog7',  'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM2 = sem_panel_FE_LY(ltfp,x2,we,24,info);
prt(SEM2,vnames);


x3=[lrdg7,lrdnog7, mlwerd1g7, mlwerd1nog7, lhcg7, lhcnog7 ];
vnames=strvcat('ltfp','lrdg7','lrdnog7',  'mlwerd1g7', 'mlwerd1nog7',  'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM3 = sem_panel_FE_LY(ltfp,x3,we,24,info);
prt(SEM3,vnames);





x4=[lrdg7,lrdnog7, mlsflpg7, mlsflpnog7, lhcg7, lhcnog7 ];
vnames=strvcat('ltfp','lrdg7','lrdnog7',  'mlsflpg7', 'mlsflpnog7',  'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM4 = sem_panel_FE_LY(ltfp,x4,we,24,info);
prt(SEM4,vnames);



x5=[lrdg7,lrdnog7, lwerd1g7, lwerd1nog7, lsflpg7, lsflpnog7,  lhcg7, lhcnog7 ];
vnames=strvcat('ltfp', 'lrdg7','lrdnog7',  'lwerd1g7', 'lwerd1nog7', 'lsflpg7', 'lsflpnog7', 'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM5 = sem_panel_FE_LY(ltfp,x5,we,24,info);
prt(SEM5,vnames);




x6=[lrdg7,lrdnog7, mlwerd1g7, mlwerd1nog7, lhcg7, mlsflpg7, mlsflpnog7,  lhcnog7 ];
vnames=strvcat('ltfp','lrdg7','lrdnog7',  'mlwerd1g7', 'mlwerd1nog7', 'mlsflpg7', 'mlsflpnog7', 'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM6 = sem_panel_FE_LY(ltfp,x6,we,24,info);
prt(SEM6,vnames);



x7=[lrdg7,lrdnog7, lwerd1g7, lwerd1nog7, mlwerd1g7, mlwerd1nog7,  lhcg7, lhcnog7 ];
vnames=strvcat('ltfp', 'lrdg7','lrdnog7',  'lwerd1g7', 'lwerd1nog7', 'mlwerd1g7', 'mlwerd1nog7', 'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM7 = sem_panel_FE_LY(ltfp,x7,we,24,info);
prt(SEM7,vnames);



x8=[lrdg7,lrdnog7, lsflpg7, lsflpnog7, mlsflpg7, mlsflpnog7,  lhcg7, lhcnog7 ];
vnames=strvcat('ltfp','lrdg7','lrdnog7',  'lsflpg7', 'lsflpnog7', 'mlsflpg7', 'mlsflpnog7', 'lhcg7', 'lhcnog7');
info.lflag = 0;
info.model = 1;
SEM8 = sem_panel_FE_LY(ltfp,x8,we,24,info);
prt(SEM8,vnames);









