c
c       this program extracts data from the national personal 
c       transportation survey (npts) for 1995.
c
      parameter(nvars=47,nchars=4,nvehs=9,nhhmoms=9,npmoms=4,nvmoms=6,
     & nmisss=12,nmodels=26,nages=20)
      implicit real*8(a-h,o-z)
      character*1 aivar,aurban(5)
      character*8 ahname(nhhmoms),amiss(nmisss),amodel(nmodels),
     & aodo(13),aorder(10),apname(npmoms),avname(nvmoms)
      dimension agemodkmom(nmodels,nages,3),agemodmom(nmodels,nages,3),
     & agew(3),amfsmh(10,3),dmfsmh(10,20),hhmom(2,nhhmoms,5),
     & ihchar(10,nchars),ihousetr(18),imiss(2,nmisss),ivar(nvars),
     & jveh(nvehs),jvehtr(nvehs),mfszkp(10),mfszvh(10,20),
     & modyrct(nages,200),modyrfrq(55),mveh(30,nvehs),odrfrq(13),
     & odyrmn(nages,2),pmom(2,npmoms,5),rmfsmh(10,10,2),rmiles(10),
     & vmodel(2,nmodels),vmom(2,nvmoms,5)
      data agew/.4d0,.2d0,.1d0/
      data ahname/'weight','hhinc','busavl','pbtravl','urban1','urban2',
     & 'nhchar','ihco','ihcar'/
      data amiss/'hhinc','busavl','pbtravl','urban1','urban2',
     & 'annmiles','mod year','od mon','od year','od read','veh age',
     & 'truck'/
      data amodel/'isuzu','chrysler','dodge','plymouth','ford',
     & 'mercury','buick','chevrolt','oldsmobl','pontiac','saturn',
     & 'luxamer','luxjapan','luxeurop','honda','mitsubi','mazda',
     & 'nissan','subaru','toyota','volkswg','volvo','geo','hyundai',
     & 'other','truck'/
      data aodo/'< 10','10-20','20-30','30-40','40-50','50-60','60-70',
     & '70-80','80-90','90-100','100-150','150-200','>200'/
      data aorder/'first','second','third','fourth','fifth','sixth',
     & 'seventh','eigth','ninth','tenth'/
      data apname/'age','driver','sex','worker'/
      data avname/'annmiles','model','mod year','od month','od year',
     & 'od read'/
      data aurban/'C','R','S','T','U'/
      data ihousetr/25,75,125,175,225,275,325,375,425,475,525,575,625,
     & 675,725,775,900,1200/
c
c       initialize.
c
      open(unit=8,file='household95.txt')
      open(unit=9,file='vehicle95.txt')
      open(unit=10,file='npts.d')
      nvar=47
      nchar=4
      nveh=9
      nvehm3=nveh-3
      ihco=0
      ihcar=0
      nhhmom=9
      do 14 i=1,2
         do 14 j=1,nhhmom
            do 15 k=1,3
  15           hhmom(i,j,k)=0.d0
            hhmom(i,j,4)=1.d10
  14        hhmom(i,j,5)=-1.d10
      npmom=4
      do 24 i=1,2
         do 24 j=1,npmom
            do 25 k=1,3
  25           pmom(i,j,k)=0.d0
            pmom(i,j,4)=1.d10
  24        pmom(i,j,5)=-1.d10
      nvmom=6
      do 29 i=1,2
         do 29 j=1,nvmom
            do 30 k=1,3
  30           vmom(i,j,k)=0.d0
            vmom(i,j,4)=1.d10
  29        vmom(i,j,5)=-1.d0
      nmodel=26
      do 36 i=1,2
         do 36 j=1,nmodel
  36        vmodel(i,j)=0.d0
      nmiss=12
      do 16 i=1,2
         do 16 j=1,nmiss
  16        imiss(i,j)=0
      do 42 i=1,13
  42     odrfrq(i)=0.d0
      do 45 i=1,55
  45     modyrfrq(i)=0
      do 48 i=1,nages
         odyrmn(i,1)=0.d0
         odyrmn(i,2)=0.d0
         do 48 j=1,200
  48        modyrct(i,j)=0
      do 58 i=1,nmodels
         do 58 j=1,nages
            do 58 k=1,3
               agemodmom(i,j,k)=0.d0
  58           agemodkmom(i,j,k)=0.d0
      do 60 i=1,10
         do 71 j=1,10
            do 71 k=1,2
  71           rmfsmh(i,j,k)=0.d0
         do 65 j=1,3
  65        amfsmh(i,j)=0.d0
         do 60 j=1,20
            dmfsmh(i,j)=0.d0
  60        mfszvh(i,j)=0
      istart=1
      jhouseid=0
      ihhco=0
      ivco=0
c
c       read household data record.
c
   8  read(8,100,end=10)(ivar(i),i=1,46),weight,ivar(47),aivar
 100  format(22x,i2,14x,i8,8x,i2,44x,i4,6x,i2,4(i4,i2,2(2x,i2)),i4,i2,
     & 2x,2(2x,i2),5(i4,i2,2(2x,i2)),125x,i4,f10.2,4x,i2,140x,a1)
c
c       transform data.
c       household id:
c
      ihouseid=ivar(2)
      ihhco=ihhco+1
      if(((ihhco/5000)*5000).eq.ihhco)write(6,122)ihhco,ihouseid,
     & jhouseid
 122  format(1x,'ihhco = ',i6,' ihouseid: ',i8,' jhouseid: ',i8)
      if((ihouseid.ne.jhouseid).and.(istart.ne.1))goto 8
      istart=0
      ifhmiss=0
      if(ivar(46).ne.0)then
         write(6,124)ivar(46),weight
 124     format(1x,'big weight: ',i4,2x,g15.8)
         stop
         endif
c
c       household income:
c
      ihousinc=-999
      if(ivar(3).le.18)ihousinc=ihousetr(ivar(3))
c
c       household member characteristics:
c       1) age
c       2) driver
c       3) sex
c       4) worker
c
      do 2 i=1,nchar
   2     ihchar(10,i)=0
      if((ivar(6).gt.0).and.(ivar(6).le.75))then
         ihchar(10,1)=ivar(6)
         if(ivar(7).eq.1)ihchar(10,2)=1
         if(ivar(8).eq.1)ihchar(10,3)=1
         if(ivar(9).eq.1)ihchar(10,4)=1
         endif
      do 3 i=1,9
         do 4 j=1,nchar
   4        ihchar(i,j)=0
         i1=9+((i-1)*4)
         i1p1=i1+1
         if((ivar(i1p1).gt.0).and.(ivar(i1p1).le.75))then
            ihchar(i,1)=ivar(i1p1)
            if(ivar(i1+2).eq.1)ihchar(i,2)=1
            if(ivar(i1+3).eq.1)ihchar(i,3)=1
            if(ivar(i1+4).eq.1)ihchar(i,4)=1
            endif
   3     continue
      nhchar=0
      do 11 i=1,10
         if((ihchar(i,1).gt.0).and.(ihchar(i,1).lt.75))nhchar=nhchar+1
  11     continue
c
c       public transportation available:
c
      ibusavl=0
      if(ivar(1).eq.1)ibusavl=1
      if(ivar(1).gt.2)ibusavl=-9
      ipbtravl=0
      if(ivar(5).eq.1)ipbtravl=1
      if(ivar(5).gt.2)ipbtravl=-9
c
c       urban:
c
      if(ivar(47).eq.2)iurban1=0
      if(ivar(47).eq.1)iurban1=1
      if((ivar(47).ne.1).and.(ivar(47).ne.2))then
         iurban=-9
         imiss(1,4)=imiss(1,4)+1
         if(ifhmiss.eq.0)then
            ifhmiss=1
            imiss(2,4)=imiss(2,4)+1
            endif
         endif
      do 44 i=1,5
         if(aivar.eq.aurban(i))then
            iurban2=i
            goto 43
            endif
  44     continue
      iurban2=0
      imiss(1,5)=imiss(1,5)+1
      if(ifhmiss.eq.0)then
         ifhmiss=1
         imiss(2,5)=imiss(2,5)+1
         endif
  43  continue
c
c       read vehicle record.
c
   9  read(9,121,end=10)(jveh(i),i=1,2),annm,(jveh(i),i=3,nveh)
 121  format(i8,30x,i6,f8.2,6x,i2,2x,i3,14x,i2,i4,82x,2i4,12x,i6)
c
c       transform variables.
c       household id:
c
      jhouseid=jveh(1)
      ivco=ivco+1
      ifvmiss=0
c
c       annualized miles:
c
      jvehtr(1)=(((jveh(2)*10000)+annm)/100)+1
      if((jvehtr(1).lt.1).or.(jvehtr(1).gt.1151))then
         imiss(1,6)=imiss(1,6)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,6)=imiss(2,6)+1
            endif
         endif
c
c       make/model:
c
      jveh3=jveh(3)
      jveh4=jveh(4)
      jveh5=jveh(5)
      call maketr(jvehtrt,jveh3,jveh4,jveh5)
      if(jvehtrt.eq.26)then
         imiss(1,12)=imiss(1,12)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,12)=imiss(2,12)+1
            endif
         endif
      jvehtr(2)=jvehtrt
c
c       model year:
c
      jvehtr(3)=jveh(6)
      if(jvehtr(3).gt.2010)then
         imiss(1,7)=imiss(1,7)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,7)=imiss(2,7)+1
            endif
         endif
      if(jvehtr(3).le.2010)then
         jvehtrt=jvehtr(3)-1954
         if(jvehtr(2).ne.26)modyrfrq(jvehtrt)=modyrfrq(jvehtrt)+1
         iage=ivar(4)+1901-jvehtr(3)
         if(iage.le.0)then
            if(iage.eq.0)iage=1
            if(iage.lt.0)then
               imiss(1,11)=imiss(1,11)+1
               if(ifvmiss.eq.0)then
                  ifvmiss=1
                  imiss(2,11)=imiss(2,11)+1
                  endif
               endif
            endif
         if(iage.gt.20)iage=20
         if(iage.gt.0)then
            iannt=jvehtr(1)
            if(iannt.le.0)iannt=1
            if(iannt.gt.200)iannt=200
            if(jvehtr(2).ne.26)modyrct(iage,iannt)=modyrct(iage,iannt)+1
            imod=jvehtr(2)
            agemodmom(imod,iage,1)=agemodmom(imod,iage,1)+1.d0
            if(jvehtr(1).le.200)ajvehtr=log(dble(float(jvehtr(1)*100)))
            if(jvehtr(1).gt.200)ajvehtr=log(20000.d0)
            agemodmom(imod,iage,2)=agemodmom(imod,iage,2)+ajvehtr
            agemodmom(imod,iage,3)=agemodmom(imod,iage,3)+(ajvehtr*
     &       ajvehtr)
            ib=iage-2
            if(ib.lt.1)ib=1
            ie=iage+2
            if(ie.gt.nages)ie=nages
            do 55 i=ib,ie
               ia=i-iage
               if(ia.lt.0)ia=-ia
               ia=ia+1
               agemodkmom(imod,i,1)=agemodkmom(imod,i,1)+agew(ia)
               agemodkmom(imod,i,2)=agemodkmom(imod,i,2)+(ajvehtr*
     &          agew(ia))
  55           agemodkmom(imod,i,3)=agemodkmom(imod,i,3)+(ajvehtr*
     &          ajvehtr*agew(ia))
            endif
         endif
c
c       odometer stuff:
c       4) month
c       5) year
c       6) reading
c
      jvehtr(4)=jveh(7)
      if(jvehtr(4).gt.12)then
         imiss(1,8)=imiss(1,8)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,8)=imiss(2,8)+1
            endif
         endif
      jvehtr(5)=jveh(8)
      if(jvehtr(5).gt.96)then
         imiss(1,9)=imiss(1,9)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,9)=imiss(2,9)+1
            endif
         endif
      jvehtr(6)=jveh(9)/100
      if(jvehtr(6).gt.9975)then
         imiss(1,10)=imiss(1,10)+1
         if(ifvmiss.eq.0)then
            ifvmiss=1
            imiss(2,10)=imiss(2,10)+1
            endif
         endif
      if(jvehtr(6).le.9975)then
         jvehtrt=jvehtr(6)/100
         do 41 i=1,10
            if(jvehtrt.le.i)then
               odrfrq(i)=odrfrq(i)+1.d0
               goto 40
               endif
  41        continue
         if(jvehtrt.le.15)then
            odrfrq(11)=odrfrq(11)+1.d0
            goto 40
            endif
         if(jvehtrt.le.20)then
            odrfrq(12)=odrfrq(12)+1.d0
            goto 40
            endif
         odrfrq(13)=odrfrq(13)+1.d0
  40     continue
         if(iage.gt.0)then
            odyrmn(iage,1)=odyrmn(iage,1)+1.d0
            odyrmn(iage,2)=odyrmn(iage,2)+dble(float(jvehtr(6)))
            endif
         endif
c
c       check for match.
c
      if(ihouseid.eq.jhouseid)then
         ihco=ihco+1
         if(jvehtr(2).ne.26)ihcar=ihcar+1
         do 5 i=1,nvehm3
   5        mveh(ihco,i)=jvehtr(i)
         goto 9
         endif
      if(ihouseid.ne.jhouseid)then
         if((ihco.gt.0).and.(nhchar.gt.0))then
c
c       update household moments.
c
            hhmom(1,1,1)=hhmom(1,1,1)+1.d0
            hhmom(1,1,2)=hhmom(1,1,2)+weight
            hhmom(1,1,3)=hhmom(1,1,3)+(weight*weight)
            if(hhmom(1,1,4).gt.weight)hhmom(1,1,4)=weight
            if(hhmom(1,1,5).lt.weight)hhmom(1,1,5)=weight
            if(ihousinc.lt.0)then
               imiss(1,1)=imiss(1,1)+1
               if(ifhmiss.eq.0)then
                  ifhmiss=1
                  imiss(2,1)=imiss(2,1)+1
                  endif
               endif
            if(ihousinc.ge.0)then
               hhmom(1,2,1)=hhmom(1,2,1)+1.d0
               housinc=dble(float(ihousinc))
               hhmom(1,2,2)=hhmom(1,2,2)+housinc
               hhmom(1,2,3)=hhmom(1,2,3)+(housinc*housinc)
               if(hhmom(1,2,4).gt.housinc)hhmom(1,2,4)=housinc
               if(hhmom(1,2,5).lt.housinc)hhmom(1,2,5)=housinc
               hhmom(2,2,1)=hhmom(2,2,1)+weight
               hhmom(2,2,2)=hhmom(2,2,2)+(housinc*weight)
               hhmom(2,2,3)=hhmom(2,2,3)+(housinc*housinc*weight)
               endif
            if(ibusavl.eq.-9)then
               imiss(1,2)=imiss(1,2)+1
               if(ifhmiss.eq.0)then
                  ifhmiss=1
                  imiss(2,2)=imiss(2,2)+1
                  endif
               endif
            if(ibusavl.ge.0)then
               hhmom(1,3,1)=hhmom(1,3,1)+1.d0
               busavl=dble(float(ibusavl))
               hhmom(1,3,2)=hhmom(1,3,2)+busavl
               hhmom(1,3,3)=hhmom(1,3,3)+(busavl*busavl)
               if(hhmom(1,3,4).gt.busavl)hhmom(1,3,4)=busavl
               if(hhmom(1,3,5).lt.busavl)hhmom(1,3,5)=busavl
               hhmom(2,3,1)=hhmom(2,3,1)+weight
               hhmom(2,3,2)=hhmom(2,3,2)+(busavl*weight)
               hhmom(2,3,3)=hhmom(2,3,3)+(busavl*busavl*weight)
               endif
            if(ipbtravl.eq.-9)then
               imiss(1,3)=imiss(1,3)+1
               if(ifhmiss.eq.0)then
                  ifhmiss=1
                  imiss(2,3)=imiss(2,3)+1
                  endif
               endif
            if(ipbtravl.ge.0)then
               hhmom(1,4,1)=hhmom(1,4,1)+1.d0
               pbtravl=dble(float(ipbtravl))
               hhmom(1,4,2)=hhmom(1,4,2)+pbtravl
               hhmom(1,4,3)=hhmom(1,4,3)+(pbtravl*pbtravl)
               if(hhmom(1,4,4).gt.pbtravl)hhmom(1,4,4)=pbtravl
               if(hhmom(1,4,5).lt.pbtravl)hhmom(1,4,5)=pbtravl
               hhmom(2,4,1)=hhmom(2,4,1)+weight
               hhmom(2,4,2)=hhmom(2,4,2)+(pbtravl*weight)
               hhmom(2,4,3)=hhmom(2,4,3)+(pbtravl*pbtravl*weight)
               endif
            if(iurban1.ge.0)then
               hhmom(1,5,1)=hhmom(1,5,1)+1.d0
               urban1=dble(float(iurban1))
               hhmom(1,5,2)=hhmom(1,5,2)+urban1
               hhmom(1,5,3)=hhmom(1,5,3)+(urban1*urban1)
               if(hhmom(1,5,4).gt.urban1)hhmom(1,5,4)=urban1
               if(hhmom(1,5,5).lt.urban1)hhmom(1,5,5)=urban1
               hhmom(2,5,1)=hhmom(2,5,1)+weight
               hhmom(2,5,2)=hhmom(2,5,2)+(urban1*weight)
               hhmom(2,5,3)=hhmom(2,5,3)+(urban1*urban1*weight)
               endif
            if(iurban2.gt.0)then
               hhmom(1,6,1)=hhmom(1,6,1)+1.d0
               urban2=dble(float(iurban2))
               hhmom(1,6,2)=hhmom(1,6,2)+urban2
               hhmom(1,6,3)=hhmom(1,6,3)+(urban2*urban2)
               if(hhmom(1,6,4).gt.urban2)hhmom(1,6,4)=urban2
               if(hhmom(1,6,5).lt.urban2)hhmom(1,6,5)=urban2
               hhmom(2,6,1)=hhmom(2,6,1)+weight
               hhmom(2,6,2)=hhmom(2,6,2)+(urban2*weight)
               hhmom(2,6,3)=hhmom(2,6,3)+(urban2*urban2*weight)
               endif
            hhmom(1,7,1)=hhmom(1,7,1)+1.d0
            anhchar=dble(float(nhchar))
            hhmom(1,7,2)=hhmom(1,7,2)+anhchar
            hhmom(1,7,3)=hhmom(1,7,3)+(anhchar*anhchar)
            if(hhmom(1,7,4).gt.anhchar)hhmom(1,7,4)=anhchar
            if(hhmom(1,7,5).lt.anhchar)hhmom(1,7,5)=anhchar
            hhmom(2,7,1)=hhmom(2,7,1)+weight
            hhmom(2,7,2)=hhmom(2,7,2)+(anhchar*weight)
            hhmom(2,7,3)=hhmom(2,7,3)+(anhchar*anhchar*weight)
            hhmom(1,8,1)=hhmom(1,8,1)+1.d0
            hco=dble(float(ihco))
            hhmom(1,8,2)=hhmom(1,8,2)+hco
            hhmom(1,8,3)=hhmom(1,8,3)+(hco*hco)
            if(hhmom(1,8,4).gt.hco)hhmom(1,8,4)=hco
            if(hhmom(1,8,5).lt.hco)hhmom(1,8,5)=hco
            hhmom(2,8,1)=hhmom(2,8,1)+weight
            hhmom(2,8,2)=hhmom(2,8,2)+(hco*weight)
            hhmom(2,8,3)=hhmom(2,8,3)+(hco*hco*weight)
            hhmom(1,9,1)=hhmom(1,9,1)+1.d0
            hcar=dble(float(ihcar))
            hhmom(1,9,2)=hhmom(1,9,2)+hcar
            hhmom(1,9,3)=hhmom(1,9,3)+(hcar*hcar)
            if(hhmom(1,9,4).gt.hcar)hhmom(1,9,4)=hcar
            if(hhmom(1,9,5).lt.hcar)hhmom(1,9,5)=hcar
            hhmom(2,9,1)=hhmom(2,9,1)+weight
            hhmom(2,9,2)=hhmom(2,9,2)+(hcar*weight)
            hhmom(2,9,3)=hhmom(2,9,3)+(hcar*hcar*weight)
c
c       output household data.
c
            write(10,101)ihouseid,weight,ihousinc,ibusavl,ipbtravl,
     &       iurban1,iurban2,nhchar,ihco,ihcar
 101        format(1x,i8,1x,f8.2,1x,i5,4(1x,i2),3(1x,i2))
c
c       update person moments.
c
            do 38 i=1,nhchar
               if((ihchar(i,1).gt.0).and.(ihchar(i,1).lt.75))then
                  do 23 j=1,4
                     pmom(1,j,1)=pmom(1,j,1)+1.d0
                     aihchar=dble(float(ihchar(i,j)))
                     pmom(1,j,2)=pmom(1,j,2)+aihchar
                     pmom(1,j,3)=pmom(1,j,3)+(aihchar*aihchar)
                     if(pmom(1,j,4).gt.aihchar)pmom(1,j,4)=aihchar
                     if(pmom(1,j,5).lt.aihchar)pmom(1,j,5)=aihchar
                     pmom(2,j,1)=pmom(2,j,1)+weight
                     pmom(2,j,2)=pmom(2,j,2)+(aihchar*weight)
  23                 pmom(2,j,3)=pmom(2,j,3)+(aihchar*aihchar*weight)
                  endif
  38           continue
c
c       output person data.
c
            do 12 i=1,nhchar
  12           write(10,103)i,(ihchar(i,j),j=1,4)
 103        format(2(1x,i2),3(1x,i1))
c
c       update vehicle moments.
c
            do 35 i=1,ihco
               if(mveh(i,2).eq.26)goto 35
               do 31 j=1,6
                  if((j.eq.1).and.((mveh(i,j).lt.0).or.
     &             (mveh(i,j).gt.1150)))goto 31
                  if((j.eq.3).and.(mveh(i,j).gt.2010))goto 31
                  if((j.eq.4).and.(mveh(i,j).gt.12))goto 31
                  if((j.eq.5).and.(mveh(i,j).gt.96))goto 31
                  if((j.eq.6).and.(mveh(i,j).gt.9975))goto 31
                  vmom(1,j,1)=vmom(1,j,1)+1.d0
                  vehtrt=dble(float(mveh(i,j)))
                  vmom(1,j,2)=vmom(1,j,2)+vehtrt
                  vmom(1,j,3)=vmom(1,j,3)+(vehtrt*vehtrt)
                  if(vmom(1,j,4).gt.vehtrt)vmom(1,j,4)=vehtrt
                  if(vmom(1,j,5).lt.vehtrt)vmom(1,j,5)=vehtrt
                  vmom(2,j,1)=vmom(2,j,1)+weight
                  vmom(2,j,2)=vmom(2,j,2)+(vehtrt*weight)
                  vmom(2,j,3)=vmom(2,j,3)+(vehtrt*vehtrt*weight)
  31              continue
               vmodel(1,mveh(i,2))=vmodel(1,mveh(i,2))+1.d0
               vmodel(2,mveh(i,2))=vmodel(2,mveh(i,2))+weight
  35           continue
            mfszvh(nhchar,ihco)=mfszvh(nhchar,ihco)+1
            amlsum=0.d0
            do 64 i=1,ihco
               if(mveh(i,1).lt.0)then
                  write(6,140)ihhco,i,mveh(i,1)
 140              format(1x,'negative mileage for household ',i8,
     &             ', vehicle ',i2,': ',i8)
                  stop
                  endif
               if(mveh(i,1).le.200)ajvehtr=(dble(float(mveh(i,1)*100)))
               if(mveh(i,1).gt.200)ajvehtr=20000.d0
               amlsum=amlsum+ajvehtr
               if(i.eq.1)rmiles(1)=ajvehtr
               if(i.gt.1)then
                  im1=i-1
                  do 67 j=1,im1
                     if(ajvehtr.gt.rmiles(j))then
                        kt=i
                        do 68 k=j,im1
                           kt=kt-1
  68                       rmiles(kt+1)=rmiles(kt)
                        rmiles(j)=ajvehtr
                        goto 69
                        endif
  67                 continue
                  rmiles(i)=ajvehtr
  69              continue
                  endif
  64           continue
            almlsum=log(amlsum)
            amfsmh(nhchar,1)=amfsmh(nhchar,1)+1.d0
            amfsmh(nhchar,2)=amfsmh(nhchar,2)+almlsum
            amfsmh(nhchar,3)=amfsmh(nhchar,3)+(almlsum*almlsum)
            idm=(amlsum/5000)+1
            if(idm.lt.1)idm=1
            if(idm.gt.20)idm=20
            dmfsmh(nhchar,idm)=dmfsmh(nhchar,idm)+1.d0
            do 70 i=1,ihco
               rmfsmh(ihco,i,1)=rmfsmh(ihco,i,1)+1.d0
  70           rmfsmh(ihco,i,2)=rmfsmh(ihco,i,2)+(rmiles(i)/amlsum)
c
c       output vehicle data.
c
            do 6 i=1,ihco
   6           write(10,102)(mveh(i,j),j=1,6)
 102        format(1x,i6,1x,i2,3(1x,i4),1x,i6)
            endif
         ihco=1
         ihcar=0
         if(jvehtr(2).ne.26)ihcar=1
         do 7 i=1,nvehm3
   7        mveh(ihco,i)=jvehtr(i)
         goto 8
         endif
  10  continue
      close(8)
      close(9)
      close(10)
c
c       output missing value counts.
c
      write(6,106)
 106  format(1x,50('-'))
      write(6,111)
 111  format(1x,'missing value counts:',/,1x,'variable',2x,'count1',2x,
     & 'count2')
      do 20 i=1,nmiss
  20     write(6,110)amiss(i),(imiss(j,i),j=1,2)
 110  format(1x,a8,2(2x,i6))
c
c       adjust moments and output.
c       household moments.
c
      write(6,106)
      do 17 i=1,2
         do 13 j=1,nhhmom
            hhmom(i,j,2)=hhmom(i,j,2)/hhmom(i,j,1)
  13        hhmom(i,j,3)=((hhmom(i,j,3)/hhmom(i,j,1))-(hhmom(i,j,2)*
     &       hhmom(i,j,2)))**.5d0
         if(i.eq.1)then
            write(6,107)
 107        format(1x,'moments for unweighted household data')
            write(6,113)
 113        format(1x,'variable',2x,'# obs',5x,'mean',6x,'std dev',3x,
     &       'minimum',3x,'maximum')
            do 18 j=1,nhhmom
  18           write(6,105)ahname(j),(hhmom(i,j,k),k=1,5)
 105        format(1x,a8,2x,f8.1,4(2x,f8.2))
            endif
         if(i.eq.2)then
            write(6,108)
 108        format(1x,'moments for weighted household data')
            write(6,114)
 114        format(1x,'variable',2x,'# obs',5x,'mean',6x,'std dev')
            do 19 j=2,nhhmom
               hhmom(i,j,1)=hhmom(i,j,1)/hhmom(1,j,1)
  19           write(6,109)ahname(j),(hhmom(i,j,k),k=1,3)
 109        format(1x,a8,2x,f8.1,2(2x,f8.2))
            endif
  17     continue
      write(6,106)
      imfs=0
      do 61 i=1,10
         do 62 j=1,20   
            if(mfszvh(i,j).gt.0)then
               imfs=imfs+1
               mfszkp(imfs)=i
               goto 61
               endif
  62        continue
  61     continue
      write(6,135)(mfszkp(i),i=1,imfs)
 135  format(1x,'frequency of vehicle ownership by number of drivers:',
     & /,13x,'# drivers',/,1x,'# vehicles',10(4x,i2))
      do 59 i=1,20   
         do 63 j=1,imfs
            if(mfszvh(mfszkp(j),i).gt.0)then  
               write(6,134)i,(mfszvh(mfszkp(k),i),k=1,imfs)
 134           format(1x,i1,9x,10(2x,i4))
               goto 59
               endif
  63        continue
  59     continue
      write(6,106)
      write(6,137)
 137  format(1x,'household log mileage by # drivers',/,1x,'# drivers',
     & 2x,'# obs',5x,'mean',6x,'std dev')
      do 66 i=1,10
         if(amfsmh(i,1).gt.5.)then
            amfsmh(i,2)=amfsmh(i,2)/amfsmh(i,1)
            amfsmh(i,3)=((amfsmh(i,3)/amfsmh(i,1))-(amfsmh(i,2)*
     &       amfsmh(i,2)))**.5d0
            write(6,138)i,(amfsmh(i,j),j=1,3)
 138        format(1x,i2,7x,2x,f8.1,2(2x,f8.4))
            endif
  66     continue
      write(6,106)
      imfs=0
      do 77 i=1,10
         dmtot=0.d0
         do 78 j=1,20
  78        dmtot=dmtot+dmfsmh(i,j)
         if(dmtot.gt.5.)then
            do 79 j=1,20
  79           dmfsmh(i,j)=dmfsmh(i,j)/dmtot
            imfs=imfs+1
            mfszkp(imfs)=i
            endif
  77     continue
      write(6,142)(mfszkp(i),i=1,imfs)
 142  format(1x,'density of household mileage by # drivers',/,18x,
     & '# drivers',/,1x,'mileage range',5x,10(6x,i2))
      imile2=0
      do 80 i=1,20
         imile1=imile2
         imile2=imile2+5000
  80     write(6,143)imile1,imile2,(dmfsmh(mfszkp(j),i),j=1,imfs)
 143  format(1x,i6,' to ',i6,10(2x,f6.4))
      write(6,106)
      it=11
      do 75 i=1,10
         it=it-1
         if(rmfsmh(it,1,1).gt.5)then
            nmfs=it
            goto 76
            endif
  75     continue
  76  write(6,139)(aorder(i),i=1,nmfs)
 139  format(1x,'proportion of household miles by mileage rank of',
     & ' vehicle and number of vehicles in household',/,'# vehicles',
     & 10(2x,a8))
      imfs=0
      do 72 i=1,ihco
         if(rmfsmh(i,1,1).gt.5.)then
            imfs=imfs+1
            mfszkp(imfs)=i
            do 73 j=1,i
  73           rmfsmh(i,j,2)=rmfsmh(i,j,2)/rmfsmh(i,j,1)
            endif
  72     continue
      do 74 i=1,imfs
  74     write(6,141)mfszkp(i),(rmfsmh(mfszkp(i),j,2),j=1,mfszkp(i))
 141  format(1x,i2,7x,10(2x,f6.4))
c
c       person moments.
c
      write(6,106)
      do 21 i=1,2
         do 37 j=1,npmom
            pmom(i,j,2)=pmom(i,j,2)/pmom(i,j,1)
  37        pmom(i,j,3)=((pmom(i,j,3)/pmom(i,j,1))-(pmom(i,j,2)*
     &       pmom(i,j,2)))**.5d0
         if(i.eq.1)then
            write(6,112)
 112        format(1x,'moments for unweighted person data')
            write(6,113)
            do 22 j=1,npmom
  22           write(6,105)apname(j),(pmom(i,j,k),k=1,5)
            endif
         if(i.eq.2)then
            write(6,115)
 115        format(1x,'moments for weighted person data')
            write(6,114)
            do 26 j=1,npmom
               pmom(i,j,1)=pmom(i,j,1)/pmom(1,j,1)
  26           write(6,109)apname(j),(pmom(i,j,k),k=1,3)
            endif
  21     continue
c
c       vehicle moments.
c
      write(6,106)
      do 27 i=1,2
         do 28 j=1,nvmom
            vmom(i,j,2)=vmom(i,j,2)/vmom(i,j,1)
  28        vmom(i,j,3)=((vmom(i,j,3)/vmom(i,j,1))-(vmom(i,j,2)*
     &       vmom(i,j,2)))**.5d0
         if(i.eq.1)then
            write(6,116)
 116        format(1x,'moments for unweighted vehicle data')
            write(6,113)
            do 32 j=1,nvmom
  32           write(6,105)avname(j),(vmom(i,j,k),k=1,5)
            endif
         if(i.eq.2)then
            write(6,136)
 136        format(1x,'moments for weighted vehicle data')
            write(6,114)
            do 33 j=1,nvmom
               vmom(i,j,1)=vmom(i,j,1)/vmom(1,j,1)
  33           write(6,109)avname(j),(vmom(i,j,k),k=1,3)
            endif
  27     continue
      write(6,106)
      write(6,125)
 125  format(1x,'unweighted frequency of model year',/,1x,'model year',
     & 2x,'frequency')
      do 47 i=1,55
         if(modyrfrq(i).gt.0)then
            modyr=i+1954
            write(6,126)modyr,modyrfrq(i)
 126        format(1x,i4,8x,i5)
            endif
  47     continue
      write(6,106)
      write(6,123)
 123  format(1x,'unweighted frequency of odometer reading',/,1x,
     & 'reading',3x,'frequency')
      do 39 i=1,13
  39     write(6,104)aodo(i),odrfrq(i)
 104  format(1x,a8,2x,f8.1)
c
c       median and mean mileage conditional on age.
c
      write(6,106)
      write(6,128)
 128  format(1x,'median and mean mileage conditional on age',/,1x,'age',
     & 2x,'# cars',2x,'median',4x,'mean',6x,'mean odom reading',2x,
     & 'difference')
      do 49 i=1,nages
         mvage=0
         amean=0.d0
         do 50 j=1,200
            mvage=mvage+modyrct(i,j)
  50        amean=amean+dble(float(modyrct(i,j)*j))
         if(mvage.ge.30)then
            amean=amean/mvage
            iodd=mvage-((mvage/2)*2)
            if(iodd.eq.0)then
               mdvage1=mvage/2
               mdvage2=mdvage1+1
               endif
            if(iodd.eq.1)then
               mdvage1=(mvage/2)+1
               mdvage2=mdvage1
               endif
            ivage=0
            do 51 j=1,200
               ivage=ivage+modyrct(i,j)
               if(ivage.ge.mdvage1)then
                  if(j.eq.1)then
                     write(6,129)i
 129                 format(1x,'median annual miles < 0 for i = ',i4)
                     stop
                     endif
                  amed=dble(float(j-1))
                  if((iodd.eq.0).and.(ivage.lt.mdvage2))amed=amed+.5d0
                  goto 52
                  endif
  51           continue
            write(6,130)i
 130        format(1x,'median annual miles > 200 for i = ',i4)
            stop
  52        continue
            im1=i-1
            odyrmn(i,2)=odyrmn(i,2)/odyrmn(i,1)
            if(i.eq.1)diff=odyrmn(i,2)
            if(i.gt.1)diff=odyrmn(i,2)-odyrmn((i-1),2)
            write(6,131)im1,mvage,amed,amean,odyrmn(i,2),diff
 131        format(1x,i2,3x,i5,3(2x,f8.3),11x,f8.3)
            endif
  49     continue
c
c       distribution of models
c
      write(6,106)
      write(6,119)
 119  format(1x,'frequency of car models,',/,1x,'model',5x,
     & 'unweighted',2x,'weighted')
      vmw=0.d0
      do 46 i=1,nmodel
  46     vmw=vmw+vmodel(2,i)
      do 34 i=1,nmodel
         if(vmodel(1,i).gt.0.)then
            vmodel(2,i)=vmodel(2,i)/vmw
            write(6,118)amodel(i),(vmodel(j,i),j=1,2)
 118        format(1x,a8,2x,f8.1,4x,f7.5)
            endif
  34     continue
c
c       mean mileage conditional on model and age.
c
      write(6,106)
      write(6,133)
 133  format(1x,'mean log mileage conditional on model and age')
      do 57 i=1,nmodel
         write(6,132)amodel(i)
 132     format(1x,'model = ',a8,/,1x,'age',2x,'# obs',5x,'mean',6x,
     &    'std dev')
         do 56 j=1,nages
            if(agemodmom(i,j,1).le.5.)write(6,127)j,agemodmom(i,j,1)
 127        format(1x,i2,3x,f8.1,2x)
            if(agemodmom(i,j,1).gt.5.)then
               agemodmom(i,j,2)=agemodmom(i,j,2)/agemodmom(i,j,1)
               agemodmom(i,j,3)=((agemodmom(i,j,3)/agemodmom(i,j,1))-
     &          (agemodmom(i,j,2)*agemodmom(i,j,2)))**.5d0
               write(6,120)j,(agemodmom(i,j,k),k=1,3)
 120           format(1x,i2,3x,f8.1,2(2x,f8.4))
               endif
  56        continue
  57     continue
c
c       kernel weighted mean mileage conditional on model and age.
c
      write(6,106)
      write(6,117)
 117  format(1x,'kernel weighted mean log mileage conditional on model',
     & ' and age')
      do 54 i=1,nmodel
         write(6,132)amodel(i)
         do 53 j=1,nages
            if(agemodkmom(i,j,1).le.5.)write(6,127)j,agemodkmom(i,j,1)
            if(agemodkmom(i,j,1).gt.5.)then
               agemodkmom(i,j,2)=agemodkmom(i,j,2)/agemodkmom(i,j,1)
               agemodkmom(i,j,3)=((agemodkmom(i,j,3)/agemodkmom(i,j,1))-
     &          (agemodkmom(i,j,2)*agemodkmom(i,j,2)))**.5d0
               write(6,120)j,(agemodkmom(i,j,k),k=1,3)
               endif
  53        continue
  54     continue
      stop
      end
c
c
      subroutine maketr(model,imake,imodl,iveht)
c
c       this subroutine constructs model numbers.  
c
      implicit real*8(a-h,o-z)
      if(iveht.ne.1)then
c
c       not car.
c
         model=26
         return
         endif
      if(imake.eq.38)then
c
c       isuzu.
c
         model=1
         return
         endif
c
c       chrysler.
c
      if(imake.eq.6)then
         model=2
         return
         endif
c
c       dodge.
c
      if(imake.eq.7)then
         model=3
         return
         endif
c
c       plymouth.
c
      if(imake.eq.9)then
         model=4
         return
         endif
c
c       ford.
c
      if(imake.eq.12)then
         model=5
         return
         endif
c
c       mercury.
c
      if(imake.eq.14)then
         model=6
         return
         endif
c
c       buick.
c
      if(imake.eq.18)then
         model=7
         return
         endif
      if(imake.eq.20)then
         if((imodl.ne.34).and.(imodl.ne.35))then
c
c       chevrolet.
c
            model=8
            return
            endif
         if((imodl.eq.34).or.(imodl.eq.35))then
c
c       geo.
c
            model=23
            return
            endif
         endif
c
c       oldsmobile.
c
      if(imake.eq.21)then
         model=9
         return
         endif
c
c       pontiac.
c
      if(imake.eq.22)then
         model=10
         return
         endif
c
c       saturn.
c
      if(imake.eq.24)then
         model=11
         return
         endif
c
c       luxury american.
c
      if((imake.eq.13).or.(imake.eq.19))then
         model=12
         return
         endif
c
c       luxury japanese.
c
      if((imake.eq.58).or.(imake.eq.59))then
         model=13
         return
         endif
c
c       luxury european.
c
      if((imake.eq.32).or.(imake.eq.34).or.(imake.eq.39).or.
     & (imake.eq.42).or.(imake.eq.45).or.(imake.eq.47))then
         model=14
         return
         endif
c
c       honda.
c
      if((imake.eq.37).or.(imake.eq.54))then
         model=15
         return
         endif
c
c       mitsubishi.
c
      if(imake.eq.52)then
         model=16
         return
         endif
c
c       mazda.
c
      if(imake.eq.41)then
         model=17
         return
         endif
c
c       nissan.
c
      if(imake.eq.35)then
         model=18
         return
         endif
c
c       subaru.
c
      if(imake.eq.48)then
         model=19
         return
         endif
c
c       toyota.
c
      if(imake.eq.49)then
         model=20
         return
         endif
c
c       volkswagen.
c
      if(imake.eq.30)then
         model=21
         return
         endif
c
c       volvo.
c
      if(imake.eq.51)then
         model=22
         return
         endif
c
c       hyundai.
c
      if(imake.eq.61)then
         model=24
         return
         endif
      model=25
      return
      end
