###R-CODE-AND-DATASETS-FOR-FOLLOWING-PAPER: 
###Elshiewy O,Zenetti G, Boztug Y. 2016. Differences between Classical 
###and Bayesian Estimates for Mixed Logit Models - A Replication Study.
###Journal of Applied Econometrics, forthcoming
###Correspondence: Ossama Elshiewy; oelshie@uni-goettingen.de
###LOAD-PACKAGE
library(mlogit)
###TO-OBTAIN-PARAMETER-ESTIMATES:
###0. REDIRECT "LOAD" FOR SIMULATED DATASETS WHERE ezb-rdata IS DOWNLOADED
###1. MARK ENTIRE CODE IN THE SPECIFIC DATASET SECTION
###2. PRESS F5
###3. GRAB A COFFEE AND ENJOY THE VIEW...
#########################################################################
#####################################
###########BEGIN SECTION: ELECTRICITY
###LOAD-DATA
data(Electricity)
###EXCLUDE 12TH CHOICE-SET AS IN HUBER/TRAIN
dat<-Electricity
# add choiceSet
if(1){
  nobs= dim(dat)[1]
  choiceSet = rep(0,nobs)
  for(i in 1:nobs){
    choiceSet[i]=  sum(dat$id[1:i]==dat$id[i])
  }
  dat$choiceSet = choiceSet
}
dat2 <- dat[dat$choiceSet!=12,]

###FROM-WIDE-2-LONG
electro <- mlogit.data(dat2, 
id="id", 
choice = "choice",
varying = 3:26, 
shape = "wide", 
sep = "")

###PARAMETER-ESTIMATION
m1 <- mlogit(
choice ~ pf + cl + loc + wk + tod + seas | 0,
data=electro,
rpar = c(pf = "n", cl = "n", loc = "n", wk = "n",tod = "n", seas = "n"), 
R = 3000, halton=NA, 
print.level = 0,
correlation = TRUE,
panel = TRUE		
)
cbind(coef(m1)[1:6])
round(vcov(m1,
what="rpar",
type="sd"),3)
cor.mlogit(m1)
#############END SECTION: ELECTRICITY
#####################################
##########################################################################
############################################
###########BEGIN SECTION: SIM_PANEL_COR-HIGH
###REDIRECT TO WHERE FOLDER ezb-rdata IS DOWNLOADED
load("C:/XXX/ezb-rdata/data_cor_high_PANEL.RData")
simhigh<-data
#
simhigh$choice <- as.factor(simhigh$choice)
names(simhigh)[3:8] <- c("promo.x1","promo.x2","promo.x3","price.x1","price.x2","price.x3")
levels(simhigh$choice) <- c("x1","x2","x3")
loshigh <- mlogit.data(simhigh, choice="choice", shape = "wide", id="ID", varying = c(3:8), sep=".")
#
###PARAMETER-ESTIMATION: CORRELATION HIGH 0.75
testhigh<-mlogit(
choice ~ price+promo, 
data=loshigh,
rpar = c(price = "n",promo = "n"), 
R = 3000, halton=NA, 
print.level = 0,
correlation=TRUE,
panel = TRUE
)
cbind(coef(testhigh)[1:4])
round(vcov(testhigh,
what="rpar",
type="sd"),3)
cor.mlogit(testhigh)
#############END SECTION: SIM_PANEL_COR-HIGH
############################################
##########################################################################
############################################
############BEGIN SECTION: SIM_PANEL_COR-LOW
###REDIRECT TO WHERE FOLDER ezb-rdata IS DOWNLOADED
load("C:/XXX/ezb-rdata/data_cor_low_PANEL.RData")
simlow<-data
simlow$choice <- as.factor(simlow$choice)
names(simlow)[3:8] <- c("promo.x1","promo.x2","promo.x3","price.x1","price.x2","price.x3")
levels(simlow$choice) <- c("x1","x2","x3")
loslow <- mlogit.data(simlow, choice="choice", shape = "wide", id="ID", varying = c(3:8), sep=".")

###PARAMETER-ESTIMATION: CORRELATION LOW 0.25
testlow<-mlogit(
choice ~ price+promo, 
data=loslow,
rpar = c(price = "n",promo = "n"), 
R = 3000, halton=NA, 
print.level = 0,
correlation=TRUE,
panel = TRUE
)
cbind(coef(testlow)[1:4])
round(vcov(testlow,
what="rpar",
type="sd"),3)
cor.mlogit(testlow)
##############END SECTION: SIM_PANEL_COR-LOW
############################################
##########################################################################
#############################################
############BEGIN SECTION: SIM_CROSS_COR-HIGH
###REDIRECT TO WHERE FOLDER ezb-rdata IS DOWNLOADED
load("C:/XXX/ezb-rdata/data_cor_high_CS.RData")
ch<-data
summary(ch)
sapply(ch,class)
ch$choice<- as.factor(ch$choice)
levels(ch$choice) <- c("x1","x2","x3")
names(ch)[3:8] <- c("promo.x1","promo.x2","promo.x3","price.x1","price.x2","price.x3")

crosshigh<-mlogit.data(ch,choice="choice",shape="wide",varying=c(3:8),sep=".")

chm<-mlogit(choice ~ price+promo, data=crosshigh, 
rpar = c(price = "n",promo = "n"), 
R = 3000, halton=NA, 
correlation=TRUE)

cbind(coef(chm))
round(vcov(chm,
what="rpar",
type="sd"),3)
cor.mlogit(chm)
##############END SECTION: SIM_CROSS_COR-HIGH
#############################################
##########################################################################
#############################################
#############BEGIN SECTION: SIM_CROSS_COR-LOW
###REDIRECT TO WHERE FOLDER ezb-rdata IS DOWNLOADED
load("C:/XXX/ezb-rdata/data_cor_low_CS.RData")
cl<-data
summary(cl)
sapply(cl,class)
cl$choice<- as.factor(cl$choice)
levels(cl$choice) <- c("x1","x2","x3")
names(cl)[3:8] <- c("promo.x1","promo.x2","promo.x3","price.x1","price.x2","price.x3")

crosslow<-mlogit.data(cl,choice="choice",shape="wide",varying=c(3:8),sep=".")

clm<-mlogit(choice ~ price+promo, data=crosslow, 
rpar = c(price = "n",promo = "n"), 
R = 3000, halton=NA, 
correlation=TRUE)

cbind(coef(clm))
round(vcov(clm,
what="rpar",
type="sd"),3)
cor.mlogit(clm)
###############END SECTION: SIM_CROSS_COR-LOW
#############################################
##########################################################################
#############################################
#######################BEGIN SECTION: CRACKER
data(Cracker)

###FROM-WIDE-2-LONG
crack <- mlogit.data(Cracker, 
id="id", 
choice = "choice",
varying = 2:13, 
shape = "wide", 
sep = ".")
crack$price<-crack$price/100

###ESTIMATION
m2 <- mlogit(
choice ~ price+feat+disp,
data=crack,
reflevel="private",
rpar = c(price = "n", feat = "n", disp = "n"), 
R = 3000, halton=NA, 
print.level = 0,
correlation = TRUE,
panel = TRUE		
)

cbind(coef(m2)[1:6])
round(vcov(m2,
what="rpar",
type="sd"),3)
cor.mlogit(m2)
#########################END SECTION: CRACKER
#############################################
##########################################################################
#############################################
#######################BEGIN SECTION: FISHING
data(Fishing)
Fishing$price.beach<-Fishing$price.beach/100
Fishing$price.pier<-Fishing$price.pier/100
Fishing$price.boat<-Fishing$price.boat/100
Fishing$price.charter<-Fishing$price.charter/100
Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")

fm<-mlogit(mode ~ price+catch, data=Fish, 
rpar=c(price="n",catch="n"),
correlation=TRUE, 
halton=NA,
R = 3000,
reflevel="charter")

cbind(coef(fm))
round(vcov(fm,
what="rpar",
type="sd"),3)
cor.mlogit(fm) 
#########################END SECTION: FISHING
#############################################
##########################################################################
