###R-CODE-AND-DATASETS-FOR-FOLLOWING-PAPER:
###Elshiewy O,Zenetti G, Boztug Y. 2016. Differences between Classical 
###and Bayesian Estimates for Mixed Logit Models - A Replication Study.
###Journal of Applied Econometrics, forthcoming
###Correspondence: Ossama Elshiewy; oelshie@uni-goettingen.de
###LOAD_PACKAGES
library(RSGHB)
library(mlogit)
###REDIRECT THE FOLLOWING TO THE FOLDER ezb-rdata IS DOWNLOADED ON YOUR COMPUTER
setwd("C:/XXX/ezb-rdata")
#######################################################
###STEP1: SET "1" FOR DATASET YOU WANT TO ESTIMATE, AND "0" FOR ALL OTHER DATASETS
###((DEFAULT IS SIMULATED-PANEL-COR-LOW))
###RUN ENTIRE CODE FOR DATASETS ASSIGNMENT
ht<-0	##Electricity
d1<-0	##SimulatedPanelCorHigh
d2<-0	##SimulatedPanelCorLow
d3<-0	##SimulatedCrossCorHigh
d4<-1	##SimulatedCrossCorLow
ep<-0	##Cracker
ec<-0	##Fishing
#
###STEP2: MARK EVERYTHING (CTRL+A) AND THEN PRESS F5. GRAB A COFFEE AND ENJOY THE VIEW...

####################################################################################################################################################
# Electricity
####################################################################################################################################################
if(ht){
  modelname <- "hubertrain"  
  data(Electricity)
  Data = Electricity
  rm(Electricity)  
  if(ht){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$id[1:i]==Data$id[i])}
    Data$choiceSet = choiceSet}
  if(ht){uniRes = unique(Data$id)
    nresp= length(uniRes)
    NUMcsPerRespont = rep(0,nresp)    
    for(i in 1:nresp){NUMcsPerRespont[i]=  max( Data$choiceSet[Data$id == uniRes[i]])}}
  Data= Data[Data$choiceSet!=12,]
  Data$ID = Data$id
  Data$id =NULL  
  nvar  =6
  gVarNamesFixed <- NULL 
  gVarNamesNormal <- c("pf","cl","loc","wk","tod","seas")
  FC <- NULL 
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar)
  
  likelihood <- function(fc,b){    
    # utility functions
    v1 <- rowSums(cbind(Data$pf1,Data$cl1,Data$loc1,Data$wk1,Data$tod1,Data$seas1)*b)
    v2 <- rowSums(cbind(Data$pf2,Data$cl2,Data$loc2,Data$wk2,Data$tod2,Data$seas2)*b)
    v3 <- rowSums(cbind(Data$pf3,Data$cl3,Data$loc3,Data$wk3,Data$tod3,Data$seas3)*b)
    v4 <- rowSums(cbind(Data$pf4,Data$cl4,Data$loc4,Data$wk4,Data$tod4,Data$seas4)*b)
    
    ev = exp(cbind(v1,v2,v3,v4))
    # mnl probability statement
    p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)    
    return((p))
  }}

####################################################################################################################################################
# Sim PANEL
####################################################################################################################################################
  #########################################################################
  # Sim Cor High  
  if(d1){
  modelname <- "SIM_PANEL_COR_HIGH"
  load("data_cor_high_PANEL.RData")
  Data = data
  rm(data) 
  }
  if(d1){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$ID[1:i]==Data$ID[i])}
    Data$choiceSet = choiceSet}
  if(d1){
  nvar=2
  gVarNamesFixed <-  c("pro2", "pro3")
  gVarNamesNormal <- c("price","promo")
  FC <- c(0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar) 

  likelihood <- function(fc,b){      
  # utility functions
  if(1){
    v1 <-          rowSums( cbind(Data$price1, Data$promo1 )*b)
    v2 <- fc[1] +  rowSums( cbind(Data$price2, Data$promo2 )*b)
    v3 <- fc[2] +  rowSums( cbind(Data$price3, Data$promo3 )*b)
  }else{
    v1 <-  rowSums(       cbind( Data$price1, Data$promo1  )*b[4:5])
    v2 <-  rowSums( b[1]+ cbind( Data$price2, Data$promo2  )*b[4:5])
    v3 <-  rowSums( b[2]+ cbind( Data$price3, Data$promo3  )*b[4:5])
    v4 <-  rowSums( b[3]+ cbind( Data$price4, Data$promo4  )*b[4:5])
  }
  ev = exp(cbind(v1,v2,v3))
  # mnl probability statement
  p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)
  return((p))
  }}
  #########################################################################
  # Sim Cor Low  
  if(d2){
  modelname <- "SIM_PANEL_COR_LOW"
  load("data_cor_low_PANEL.RData")
  Data = data
  rm(data)
  }
  if(d2){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$ID[1:i]==Data$ID[i])}
    Data$choiceSet = choiceSet}
  if(d2){
  nvar=2
  gVarNamesFixed <-  c("pro2", "pro3")
  gVarNamesNormal <- c("price","promo")
  FC <- c(0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar) 

  likelihood <- function(fc,b){      
  # utility functions
  if(1){
    v1 <-          rowSums( cbind(Data$price1, Data$promo1 )*b)
    v2 <- fc[1] +  rowSums( cbind(Data$price2, Data$promo2 )*b)
    v3 <- fc[2] +  rowSums( cbind(Data$price3, Data$promo3 )*b)
  }else{
    v1 <-  rowSums(       cbind( Data$price1, Data$promo1  )*b[4:5])
    v2 <-  rowSums( b[1]+ cbind( Data$price2, Data$promo2  )*b[4:5])
    v3 <-  rowSums( b[2]+ cbind( Data$price3, Data$promo3  )*b[4:5])
    v4 <-  rowSums( b[3]+ cbind( Data$price4, Data$promo4  )*b[4:5])
  }  
  ev = exp(cbind(v1,v2,v3))
  # mnl probability statement
  p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)
  return((p))
  }}
####################################################################################################################################################
# Sim CROSS SECTIONAL
####################################################################################################################################################
#########################################################################
  # Sim Cor High
  if(d3){
  modelname <- "SIM_CROSS_COR_HIGH"
  load("data_cor_high_CS.RData")
  Data = data
  rm(data)  
  }  
  if(d3){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$ID[1:i]==Data$ID[i])}
    Data$choiceSet = choiceSet}
  if(d3){
  nvar  =2
  gVarNamesFixed <-  c("pro2", "pro3")
  gVarNamesNormal <- c("price","promo")
  FC <- c(0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar)

  likelihood <- function(fc,b){  
  # utility functions
  if(1){
    v1 <-          rowSums( cbind(Data$price1, Data$promo1 )*b)
    v2 <- fc[1] +  rowSums( cbind(Data$price2, Data$promo2 )*b)
    v3 <- fc[2] +  rowSums( cbind(Data$price3, Data$promo3 )*b)
  }else{
    v1 <-  rowSums(       cbind( Data$price1, Data$promo1  )*b[4:5])
    v2 <-  rowSums( b[1]+ cbind( Data$price2, Data$promo2  )*b[4:5])
    v3 <-  rowSums( b[2]+ cbind( Data$price3, Data$promo3  )*b[4:5])
    v4 <-  rowSums( b[3]+ cbind( Data$price4, Data$promo4  )*b[4:5])
  }
  
  ev = exp(cbind(v1,v2,v3))
  # mnl probability statement
  p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)
  return((p))
  }}
  #########################################################################
  # Sim Cor Low
  if(d4){
  modelname <- "SIM_CROSS_COR_LOW"
  load("data_cor_low_CS.RData")
  Data = data
  rm(data) 
  }  
  if(d4){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$ID[1:i]==Data$ID[i])}
    Data$choiceSet = choiceSet}
  if(d4){
  nvar  =2
  gVarNamesFixed <-  c("pro2", "pro3")
  gVarNamesNormal <- c("price","promo")
  FC <- c(0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar)

  likelihood <- function(fc,b){  
  # utility functions
  if(1){
    v1 <-          rowSums( cbind(Data$price1, Data$promo1 )*b)
    v2 <- fc[1] +  rowSums( cbind(Data$price2, Data$promo2 )*b)
    v3 <- fc[2] +  rowSums( cbind(Data$price3, Data$promo3 )*b)
  }else{
    v1 <-  rowSums(       cbind( Data$price1, Data$promo1  )*b[4:5])
    v2 <-  rowSums( b[1]+ cbind( Data$price2, Data$promo2  )*b[4:5])
    v3 <-  rowSums( b[2]+ cbind( Data$price3, Data$promo3  )*b[4:5])
    v4 <-  rowSums( b[3]+ cbind( Data$price4, Data$promo4  )*b[4:5])
  }
  
  ev = exp(cbind(v1,v2,v3))
  # mnl probability statement
  p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)
  return((p))
  }}
####################################################################################################################################################
# Cracker
####################################################################################################################################################
if(ep){
  modelname <- "CRACKER"
  data(Cracker)
  Data =Cracker
  rm(Cracker) 
  # add choiceSet
  if(ep){
    nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){
      choiceSet[i]=  sum(Data$id[1:i]==Data$id[i])
    }
    Data$choiceSet = choiceSet
  }
 
  if(ep){uniRes = unique(Data$id)
    nresp= length(uniRes)
    NUMcsPerRespont = rep(0,nresp)    
    for(i in 1:nresp){NUMcsPerRespont[i]=  max( Data$choiceSet[Data$id == uniRes[i]])}}    
  Data$ID = Data$id
  Data$id =NULL
  Data$price.sunshine = Data$price.sunshine/100
  Data$price.keebler = Data$price.keebler/100
  Data$price.nabisco = Data$price.nabisco/100
  Data$price.private = Data$price.private/100
  nvar  =3
  gVarNamesFixed <- c("sunshine", "keebler", "nabisco")
  gVarNamesNormal <- c("disp","feat","price")
  FC <- c(0,0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar)
  
  likelihood <- function(fc,b){      
    # utility functions
    if(1){
      v1 <- fc[1] + rowSums(  cbind(Data$disp.sunshine, Data$feat.sunshine,  Data$price.sunshine)*b)
      v2 <- fc[2] + rowSums(  cbind( Data$disp.keebler, Data$feat.keebler,  Data$price.keebler)*b)
      v3 <- fc[3] + rowSums(  cbind( Data$disp.nabisco, Data$feat.nabisco,  Data$price.nabisco)*b)
      v4 <- 0     + rowSums(  cbind( Data$disp.private, Data$feat.private,  Data$price.private)*b)
    }else{
      v1 <- b[1] + rowSums(  cbind(Data$disp.sunshine, Data$feat.sunshine,  Data$price.sunshine)*b[4:6])
      v2 <- b[2] + rowSums(  cbind( Data$disp.keebler, Data$feat.keebler,  Data$price.keebler)*b[4:6])
      v3 <- b[3] + rowSums(  cbind( Data$disp.nabisco, Data$feat.nabisco,  Data$price.nabisco)*b[4:6])
      v4 <- 0     + rowSums(  cbind( Data$disp.private, Data$feat.private,  Data$price.private)*b[4:6])
    }
    ev = exp(cbind(v1,v2,v3,v4))
    # mnl probability statement
    p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)
    return((p))
  }}

####################################################################################################################################################
# Fishing
####################################################################################################################################################
if(ec){
  modelname <- "FISHING"
  data(Fishing)
  Data =Fishing
  rm(Fishing)         
  Data$id = 1:length(Data$mode)
  # add choiceSet
  if(ec){nobs= dim(Data)[1] 
    choiceSet = rep(0,nobs)
    for(i in 1:nobs){choiceSet[i]=  sum(Data$id[1:i]==Data$id[i])}
    Data$choiceSet = choiceSet}
  if(ec){
    uniRes = unique(Data$id)
    nresp= length(uniRes)
    NUMcsPerRespont = rep(0,nresp)    
    for(i in 1:nresp){NUMcsPerRespont[i]=  max( Data$choiceSet[Data$id == uniRes[i]])}}  
  Data$ID = Data$id
  Data$id =NULL  
  Data$choice =as.numeric(Data$mode)      
  Data$price.beach = Data$price.beach/100
  Data$price.pier = Data$price.pier/100
  Data$price.boat = Data$price.boat/100
  Data$price.charter = Data$price.charter/100
  nvar  =2
  gVarNamesFixed <- c("beach", "pier", "boat")
  gVarNamesNormal <- c("price","catch")
  FC <- c(0,0,0)
  gDIST <- rep(1,nvar)
  sVN <- rep(0,nvar)
 
  likelihood <- function(fc,b){      
    # utility functions        
    v1 <- fc[1] + rowSums(  cbind(Data$price.beach, Data$catch.beach)*b) 
    v2 <- fc[2] + rowSums(  cbind(Data$price.pier, Data$catch.pier)*b) 
    v3 <- fc[3] + rowSums(  cbind(Data$price.boat, Data$catch.boat)*b) 
    v4 <-                             rowSums(  cbind(Data$price.charter, Data$catch.charter)*b) 
    ev = exp(cbind(v1,v2,v3,v4))
    # mnl probability statement
    p <- ev[ind = cbind(c(1:length(Data$choice)), Data$choice)] /rowSums(ev)    
    return((p))
  }}

####################################################################################################################################################
# Setup II: Arguments
####################################################################################################################################################

control <- list(
  modelname=modelname,
  gVarNamesFixed =gVarNamesFixed,
  gVarNamesNormal=gVarNamesNormal,
  FC = FC,
  gDIST=gDIST,
  svN=sVN,
  gNCREP=75000,
  gNEREP=75000,
  gNSKIP=1,
  gINFOSKIP=100,
  gSeed=99,
  nodiagnostics = FALSE
)

####################################################################################################################################################
# Setup III: Estimate
####################################################################################################################################################

mnl<-doHB(likelihood, Data, control) 
Y

####################################################################################################################################################
# # Setup IV: Results
####################################################################################################################################################

#MEAN OF ALTERNATIVE-SPECIFIC CONSTANTS (not for Electricity)
round(cbind(apply(mnl$F[,-1],2,mean)),3)

#MEAN AND SD OF RANDOM COEFFICIENTS
round(data.frame(
MEAN=apply(mnl$A[,-1],2,mean),
SD=diag(sqrt(apply(array(mnl$D, dim=c(nvar,nvar,75000)),c(1,2),mean)))),3)

#CORRELATION
round(matrix(cov2cor(apply(array(mnl$D, dim=c(nvar,nvar,75000)),c(1,2),mean)),nvar,nvar,
dimnames=list(mnl$params.vary,mnl$params.vary)),3)





