""" This module contains some auxiliary functions that are used to assess the effect of the
number of interpolation points on the estimation quality.
"""
import pickle as pkl
import pandas as pd

import matplotlib
import os

matplotlib.use('Agg')
from auxiliary_shared import to_string


def aggregate_smoothing_fixed(parameters):
    """ Aggregate the results in one file for comparison.
    """
    with open('../../smoothing_fixed.txt', 'w') as outfile:
        for tau in parameters:
            os.chdir('tau_' + to_string(tau))
            outfile.write('\n TAU {:d}\n'.format(tau))
            with open('smoothing_fixed.txt') as infile:
                outfile.write(infile.read())
            outfile.write('\n')
            os.chdir('../')


def aggregate_smoothing_adaptive(rslts):
    """ Aggregate all results.
    """
    pkl.dump(rslts, open('rslts.smoothing_adaptive.pkl', 'wb'))
    df = pd.DataFrame(rslts, columns=['RMSE'])

    with open('../../smoothing_adaptive.txt', 'w') as log_file:
        string = '\n' + '{:>15}' * 9 + '\n'
        header = ['Statistic', 'Count', 'Mean', 'Std.', 'Min', '25%', '50%', '75%', 'Max']
        log_file.write(string.format(*header))

        string = '\n{:>15}' + '{:15.4f}' * 8
        line = ['RMSE'] + df['RMSE'].describe().transpose().tolist()
        log_file.write(string.format(*line))


def write_smoothing(rslts):
    """ Write out results to an interpretable file. I also store a pickle version for further
    processing.
    """
    # Create a well-interpretable dataframe.
    columns = ['Seed', 'RMSE_Start', 'RMSE_Finish', 'Evals', 'Steps', 'Duration']
    df = pd.DataFrame(rslts, columns=columns)

    pkl.dump(df, open('rslts.smoothing_fixed.pkl', 'wb'))

    with open('smoothing_fixed.txt', 'w') as log_file:

        string = '\n' + '{:>15}' * 9 + '\n'
        header = ['Statistic', 'Count', 'Mean', 'Std.', 'Min', '25%', '50%', '75%', 'Max']
        log_file.write(string.format(*header))

        string = '\n{:>15}' + '{:15.4f}' * 8
        for label in ['RMSE_Start', 'RMSE_Finish', 'Evals', 'Steps', 'Duration']:
            line = [label] + df[label].describe().transpose().tolist()
            log_file.write(string.format(*line))

