""" This module contains some auxiliary functions that are used to assess the effect of the
number of interpolation points on the estimation quality.
"""
import pickle as pkl
import pandas as pd

import matplotlib
import os

matplotlib.use('Agg')
from auxiliary_shared import to_string


def aggregate_schemes(points):
    """ Aggregate the results in one file for comparison.
    """
    with open('../schemes.txt', 'w') as outfile:
        for point in points:
            os.chdir('points_' + to_string(point))
            outfile.write('\n POINTS {:d}\n'.format(point))
            with open('schemes.txt') as infile:
                outfile.write(infile.read())
            outfile.write('\n')
            os.chdir('../')


def write_schemes(rslts):
    """ Write out results to an interpretable file. I also store a pickle version for further
    processing.
    """
    # Create a well-interpretable dataframe.
    columns = ['Seed', 'RMSE_Start', 'RMSE_Finish', 'Evals', 'Steps', 'Duration']
    df = pd.DataFrame(rslts, columns=columns)

    pkl.dump(df, open('rslts.schemes.pkl', 'wb'))

    with open('schemes.txt', 'w') as log_file:

        string = '\n' + '{:>15}' * 9 + '\n'
        header = ['Statistic', 'Count', 'Mean', 'Std.', 'Min', '25%', '50%', '75%', 'Max']
        log_file.write(string.format(*header))

        string = '\n{:>15}' + '{:15.4f}' * 8
        for label in ['RMSE_Start', 'RMSE_Finish', 'Evals', 'Steps', 'Duration']:
            line = [label] + df[label].describe().transpose().tolist()
            log_file.write(string.format(*line))

