import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt


def plot_choices(rslts, tasks):
    """ Function to produce plot for choice patterns.
    """
    for task in tasks:
        choice_probabilities = rslts[task]

        deciles = range(40)
        colors = ['blue', 'yellow', 'orange', 'red']
        width = 0.9

        # Plotting
        bottom = [0] * 40

        # Initialize plot
        ax = plt.figure(figsize=(12, 8)).add_subplot(111)
        labels = ['Home', 'School', 'Occupation A', 'Occupation B']
        for j, i in enumerate([3, 2, 0, 1]):

            heights = choice_probabilities[:, i]
            plt.bar(deciles, heights, width, bottom=bottom, color=colors[j],
                    alpha=0.70)
            bottom = [heights[i] + bottom[i] for i in range(40)]

        # Both Axes
        ax.tick_params(labelsize=16, direction='out', axis='both', top='off',
            right='off')

        ax.spines['top'].set_visible(False)
        ax.spines['right'].set_visible(False)
        ax.spines['bottom'].set_visible(False)
        ax.spines['left'].set_visible(False)

        # X axis
        ax.set_xlabel('Period', fontsize=16)
        ax.set_xlim([0, 40])

        # Y axis
        ax.set_ylabel('Share of Population', fontsize=16)
        ax.yaxis.get_major_ticks()[0].set_visible(False)

        # Legend
        plt.legend(labels, loc='upper center', bbox_to_anchor=(0.5, -0.10),
            fancybox=False, frameon=False, shadow=False, ncol=4, fontsize=20)

        # Write out to
        plt.savefig('choices_' + task + '.png', bbox_inches='tight',
            format='png')
