import numpy as np


def write_correct(num_points, num_draws_emax, success_indicators,
        selected_periods, which, num_agents_sim, num_periods, selected_ranges):
    """ Write out the results
    """
    # Write out information.
    if which == 'one':
        spec = 0
    elif which == 'two':
        spec = 1
    elif which == 'three':
        spec = 2

    fname = 'table_2.' + str(spec + 1) + '.txt'
    with open(fname, 'a') as f:

        # Write out header information
        if num_points is None:
            label_points = 'All'
        else:
            label_points = str(num_points)
        fmt_ = 'EMAX {0:>6}  POINTS {1:>6}\n'
        line = fmt_.format(*[str(num_draws_emax), label_points])
        f.write(line)

        f.write('\n At Selected Periods \n\n')

        for period in selected_periods:
            share_success = sum(success_indicators[:, (period - 1)])
            share_success /= float(num_agents_sim)
            fmt_ = ' Period {0:>6}   {1:6.4f} \n'
            line = fmt_.format(*[str(period), share_success])
            f.write(line)

        # Share of correct decisions over all periods.
        share_success = np.sum(success_indicators)
        share_success /= float((num_agents_sim * num_periods))
        fmt_ = '\n Total  {0:>6}   {1:6.4f} \n'
        line = fmt_.format(*[' ', share_success])
        f.write(line)

        f.write('\n Number of Periods over the Lifetime \n\n')

        for ranges in selected_ranges:
            lower, upper = ranges

            successes_by_agent = np.sum(success_indicators, axis=1)

            counts = 0
            for i in range(num_agents_sim):
                counts += (successes_by_agent[i] in range(lower, upper + 1))

            share_success = counts / float(num_agents_sim)
            fmt_ = ' Period  {0:>3}-{1:<3} {2:6.4f} \n'
            line = fmt_.format(*[lower, upper, share_success])
            f.write(line)

        # Share individuals for which all periods are predicted correctly.
        average_success = np.mean(np.sum(success_indicators, axis=1))
        fmt_ = '\n Average {0:14.4f} \n'
        line = fmt_.format(*[average_success])
        f.write(line)

        f.write('\n\n\n')

