new;

library maxlik;
#include maxlik.ext;
maxset;

/**************************************************************************************************************/
/* GAUSSKERN.G              */
/* programmer: Andrea Weber  */ 
/* This version: 04-06-2005  */ 

/* This Gauss program estimates the main models of the paper "sectoral adjustment of employment" 
   by Andrea Weber, Peter Egger, Michael Pfaffermayer

   The model is fixed effects multinomial logit with lagged dependent variables and discrete and continuous 
   exogenous variables.
   Likelihood function given by Honore Kyriazidou (2000)*/

/*** 


    gauss input datafile     gausm,   m male
  

    contains both routines
    data sorting of entries to the likelihood and calculation of indicator matrices "crx"
    and the likelihood procedure 
    
    allows for state-dependent X variables
    and for age variables (not state dependent)
    
    this program estimates 2 Model versions with 3 or 4 explanatory trade variabels
    (basic Tabels in paper No 3 (model version 1, 4 vars) and No 4 (model version 1, 3 vars))
    
    Version: loops over different values of bandwidths, Table 6 in paper
    
********************************************************************/


output file=c:\industry\gauss\resultsrev\crxkern7.out;         /* !!!!!! insert  !!!!!!!!  */
output reset;


nx = 6;			      /* number of covariates    */
mx=12;                         /* number of x-variables in data matrix */

periods=12;

M = 6;                        /* number of choices  */

nb = (M-1)*(M-1)+(M-1)*nx;    /* number of parameters */

ya = 2;                       /* choice of dependent variable 0 state, 1 statea, 2 stateb */
ke=1;                         /* kernel variable - continuous variable among the x-vars */
bw=0.1;                       /* bandwidth parameter */


/************************************************************************************/
/*                          CREATE INDICATORS				            */
/************************************************************************************/

filein = "\\industry\\data\\male\\gausm";
fileout = "\\industry\\data\\male\\xm";

fileyt = "\\industry\\data\\male\\iyt";
fileys = "\\industry\\data\\male\\iys";

fileytm1ys = "\\industry\\data\\male\\iytm1ys";
fileytm1yt = "\\industry\\data\\male\\iytm1yt";
fileysysp1 = "\\industry\\data\\male\\iysysp1";
fileytysp1 = "\\industry\\data\\male\\iytysp1";

fileytytp1 = "\\industry\\data\\male\\iytytp1";
fileysytp1 = "\\industry\\data\\male\\iysytp1";
fileysm1ys = "\\industry\\data\\male\\iysm1ys";
fileysm1yt = "\\industry\\data\\male\\iysm1yt";

fileytys = "\\industry\\data\\male\\iytys";
fileysyt = "\\industry\\data\\male\\iysyt";




/**********************************************************************************/
/*                     LOAD STARTING VALUES                                       */
/**********************************************************************************/


load b=c:\industry\gauss\resultsrev\bm2;

b0=b;


if rows(b) ne nb; print" error with number of startingvalues "; endif;


let bw={0.1,0.05,0.2};    /* different bandwidth values */
let bw={0.1};    /* different bandwidth values */


/* rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr*/

bm8=zeros(nb,rows(bw));
covm8=zeros(nb,nb*rows(bw));

/*------------------------------------------------------------------------------------------*/
ibw=1;
do while ibw<=rows(bw);

bandw=bw[ibw];
print"bw " bandw;
print"nx " nx;

/*****************************************************************************************/
/*                 LOAD DATAMATRIX                                                       */
/*****************************************************************************************/

n1 = crx(bandw,ke,nx,mx);

open zh=c:\industry\data\male\xm;   /* !!!!!! insert  !!!!!!!!  */
n2 = rowsf(zh)-n1;

X= readr(zh, rowsf(zh));

kern=X[.,1];
xts = X[.,2:2*nx+1];
ytm1 = X[.,2*nx+2]+1;
yt =  X[.,2*nx+3]+1;
ytp1 = X[.,2*nx+4]+1;
ysm1 = X[.,2*nx+5]+1;
ys =  X[.,2*nx+6]+1;
ysp1 = X[.,2*nx+7]+1;

persnr = xts./xts;
clear x;



/*   Indicator matrices    */

open zyt=c:\industry\data\male\iyt;
open zys=c:\industry\data\male\iys;

open zytys=c:\industry\data\male\iytys;
open zysyt=c:\industry\data\male\iysyt;

open zytm1yt=c:\industry\data\male\iytm1yt;
open zytm1ys=c:\industry\data\male\iytm1ys;
open zytytp1=c:\industry\data\male\iytytp1;
open zysytp1=c:\industry\data\male\iysytp1;
open zysysp1=c:\industry\data\male\iysysp1;
open zytysp1=c:\industry\data\male\iytysp1;
open zysm1ys=c:\industry\data\male\iysm1ys;
open zysm1yt=c:\industry\data\male\iysm1yt;


/******************************************************************************************************/
/*   MAXIMISATION                                                                                     */
/******************************************************************************************************/


_max_GradProc = &lgd;
_max_GradCheckTol = 0.00;

_max_GradTol=0.00001;
_max_CovPar=2;
_max_FinalHess;
_max_MaxIters=500;

__rows=0;
__rowfac = 1;
__output=20;


_max_Algorithm = 2;
_max_Active=ones(rows(b),1);

b[26]=0;
b[31]=0;
b[29]=0;
b[34]=0;

_max_Active[26]=0;
_max_Active[31]=0;
_max_Active[29]=0;
_max_Active[34]=0;

b[30]=0;
b[35]=0;

_max_Active[30]=0;
_max_Active[35]=0;


/*  Alternative specification for table 5 */
/*
b[1]=0;
b[4:6]=zeros(3,1);
b[9:11]=zeros(3,1);
b[14:16]=zeros(3,1);
b[19:21]=zeros(3,1);
b[24:26]=zeros(3,1);
b[29:31]=zeros(3,1);
b[34:36]=zeros(3,1);
b[39:41]=zeros(3,1);
b[44:46]=zeros(3,1);
b[49:51]=zeros(3,1);
b[54:55]=zeros(2,1);

_max_Active[1]=0;
_max_Active[4:6]=zeros(3,1);
_max_Active[9:11]=zeros(3,1);
_max_Active[14:16]=zeros(3,1);
_max_Active[19:21]=zeros(3,1);
_max_Active[24:26]=zeros(3,1);
_max_Active[29:31]=zeros(3,1);
_max_Active[34:36]=zeros(3,1);
_max_Active[39:41]=zeros(3,1);
_max_Active[44:46]=zeros(3,1);
_max_Active[49:51]=zeros(3,1);
_max_Active[54:55]=zeros(2,1);

*/


__title="Maximum Likelihood Estimation";


{b, lnlkval, lnlkgr, bcov, retcode} = maxlik (persnr, 0, &lnlk, b);
/*{x, f, g, h, retcode} = maxprt (b, lnlkval, lnlkgr, bcov, retcode);*/

/* save parameter vector and covariance matrix  */
__title="Wald Confidence Limits";
cl1 = maxtlimits (b, bcov);
call maxclprt (b, lnlkval, lnlkgr, cl1, retcode);

if (rows(bcov)>1);
print"Bandwidth   " bandw;
call poutput(b,bcov);
endif;

/* save parameter vector and covariance matrix  */
bm8[.,ibw]=b;
covm8[.,(ibw-1)*nb+1:ibw*nb]=bcov;

closeall;

ibw=ibw+1;
endo;
/*------------------------------------------------------------------------------------------*/

save path=c:\industry\gauss\resultsrev bm8;
save path=c:\industry\gauss\resultsrev covm8;

/* rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr*/

nx=7;
print" nx" nx;
nb = (M-1)*(M-1)+(M-1)*nx;    /* number of parameters */

load b=c:\industry\gauss\resultsrev\brca410;
load b=c:\industry\gauss\resultsrev\bm1;

bm7=zeros(nb,rows(bw));
covm7=zeros(nb,nb*rows(bw));

/*------------------------------------------------------------------------------------------*/
ibw=1;
do while ibw<=rows(bw);            /*rows(bw);*/

bandw=bw[ibw];



/*****************************************************************************************/
/*                 LOAD DATAMATRIX                                                       */
/*****************************************************************************************/

n1 = crxa(bandw,ke,nx,mx);

open zh=c:\industry\data\male\xm;   /* !!!!!! insert  !!!!!!!!  */
n2 = rowsf(zh)-n1;


X= readr(zh, rowsf(zh));

kern=X[.,1];
xts = X[.,2:2*nx+1];
ytm1 = X[.,2*nx+2]+1;
yt =  X[.,2*nx+3]+1;
ytp1 = X[.,2*nx+4]+1;
ysm1 = X[.,2*nx+5]+1;
ys =  X[.,2*nx+6]+1;
ysp1 = X[.,2*nx+7]+1;

persnr = xts./xts;
clear x;



/*   Indicator matrices    */

open zyt=c:\industry\data\male\iyt;
open zys=c:\industry\data\male\iys;

open zytys=c:\industry\data\male\iytys;
open zysyt=c:\industry\data\male\iysyt;

open zytm1yt=c:\industry\data\male\iytm1yt;
open zytm1ys=c:\industry\data\male\iytm1ys;
open zytytp1=c:\industry\data\male\iytytp1;
open zysytp1=c:\industry\data\male\iysytp1;
open zysysp1=c:\industry\data\male\iysysp1;
open zytysp1=c:\industry\data\male\iytysp1;
open zysm1ys=c:\industry\data\male\iysm1ys;
open zysm1yt=c:\industry\data\male\iysm1yt;


/******************************************************************************************************/
/*   MAXIMISATION                                                                                     */
/******************************************************************************************************/


_max_GradProc = &lgd;

_max_GradTol=0.00001;
_max_CovPar=2;
_max_MaxIters=500;

__rows=0;
__rowfac = 1;
__output=20;

_max_Algorithm = 2;
_max_Active=ones(rows(b),1);
_max_Active=ones(rows(b),1);

b[26]=0;
b[31]=0;
b[36]=0;
b[29]=0;
b[34]=0;
b[39]=0;
_max_Active[26]=0;
_max_Active[31]=0;
_max_Active[36]=0;
_max_Active[29]=0;
_max_Active[34]=0;
_max_Active[39]=0;

b[30]=0;
b[35]=0;
b[40]=0;
_max_Active[30]=0;
_max_Active[35]=0;
_max_Active[40]=0;

/*  Alternative fr nur transitions in 2 und 3 */
/*
b[1]=0;
b[4:6]=zeros(3,1);
b[9:11]=zeros(3,1);
b[14:16]=zeros(3,1);
b[19:21]=zeros(3,1);
b[24:26]=zeros(3,1);
b[29:31]=zeros(3,1);
b[34:36]=zeros(3,1);
b[39:41]=zeros(3,1);
b[44:46]=zeros(3,1);
b[49:51]=zeros(3,1);
b[54:56]=zeros(3,1);
b[59:60]=zeros(2,1);
_max_Active[1]=0;
_max_Active[4:6]=zeros(3,1);
_max_Active[9:11]=zeros(3,1);
_max_Active[14:16]=zeros(3,1);
_max_Active[19:21]=zeros(3,1);
_max_Active[24:26]=zeros(3,1);
_max_Active[29:31]=zeros(3,1);
_max_Active[34:36]=zeros(3,1);
_max_Active[39:41]=zeros(3,1);
_max_Active[44:46]=zeros(3,1);
_max_Active[49:51]=zeros(3,1);
_max_Active[54:56]=zeros(3,1);
_max_Active[59:60]=zeros(2,1);
*/

__title="Maximum Likelihood Estimation";

{b, lnlkval, lnlkgr, bcov, retcode} = maxlik (persnr, 0, &lnlk, b);
/*{x, f, g, h, retcode} = maxprt (b, lnlkval, lnlkgr, bcov, retcode);*/

/* save parameter vector and covariance matrix  */
__title="Wald Confidence Limits";
cl1 = maxtlimits (b, bcov);
call maxclprt (b, lnlkval, lnlkgr, cl1, retcode);

if (rows(bcov)>1);
print"Bandwidth   " bandw;
call poutput(b,bcov);
endif;


/* save parameter vector and covariance matrix  */
bm7[.,ibw]=b;
covm7[.,(ibw-1)*nb+1:ibw*nb]=bcov;

closeall;

ibw=ibw+1;
endo;
/*------------------------------------------------------------------------------------------*/

save path=c:\industry\gauss\resultsrev bm7;
save path=c:\industry\gauss\resultsrev covm7;


/* rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr*/

output off;
end;

/*------------------------------------------------------------------------------------------*/
/*                    PROCEDURES                                                            */
/*------------------------------------------------------------------------------------------*/


/********************************************************************************************/
/*                   LIKELIHOOD                                                             */
/********************************************************************************************/
proc lnlk (b,data);                      /* likelihood function  **/
/*local ytm1, yt, ytp1, ysm1, ys, ysp1, xts;*/
local n, Gp, bp, ret,i;


/* Aufteilung von  b   */
Gp = b[1:(M-1)*(M-1)];

bp = zeros(nx,M);
i=1;
do while i<=nx;
   bp[i, 2:M] = b[((M-1)*(M-1)+(M-1)*(i-1)+1):((M-1)*(M-1)+i*(M-1))]';
   i=i+1;
endo;
ret = zeros(2,1);    

ret[1]=d1(xts[1:n1,.],Gp,bp);

ret[2]=d2(xts[n1+1:n1+n2,.],Gp,bp);


ret=sumc(ret);

retp (ret);
endp;

/*-------------------------------------------------------------------------------------------------*/
proc d1(x12,GP,bp);
local d,i,ii,dh, up,n, down, retd1,point, x12l, x12m;

n = rows(x12);

x12m=x12[.,1:nx];
x12l=x12[.,nx+1:2*nx];

i=1;
ii = 5000;

d = zeros(1,1);

do while i<=n;
	dh = x12m[i:i+ii-1,.] .* (readr(zyt,ii)*bp') - x12l[i:i+ii-1,.] .* (readr(zys,ii)*bp');
	dh = sumc(dh');
	dh = dh + readr(zytm1yt,ii)*GP + readr(zytys,ii)*GP + readr(zysysp1,ii)*GP 
	      - readr(zytm1ys,ii)*GP - readr(zysyt,ii)*GP - readr(zytysp1,ii)*GP;
	d=d|dh;
        i = i+ii;
        if (i<=n and i+ii>n);
           ii = n-i+1;
        endif;
endo;

d=d[2:rows(d)];

if rows(d) ne n;
  print" error in d1";
  end;
endif;

point=seekr(zyt,1); point=seekr(zys,1); point=seekr(zytm1yt,1); point=seekr(zytm1ys,1); 
point=seekr(zytys,1); point=seekr(zysyt,1);
point=seekr(zysysp1,1); point=seekr(zytysp1,1);

up = (exp(d));
down = 1 + exp(d);

retd1= up./down; 
retd1=sumc(kern[1:n1].*ln(retd1));

retp(retd1);
endp;

/*-------------------------------------------------------------------------------------------------*/
proc d2(x12,GP,bp);
local d,n,i,ii,dh, up, down, retd2, point, x12l, x12m;

n = rows(x12);

x12m=x12[.,1:nx];
x12l=x12[.,nx+1:2*nx];

i=1;
ii = 800;

/* pointer richtig setzen  nach n1+1 */
point=seekr(zyt,n1+1); point=seekr(zys,n1+1); point=seekr(zytm1yt,n1+1); point=seekr(zysm1ys,n1+1); 
point=seekr(zytytp1,n1+1); point=seekr(zysysp1,n1+1);
point=seekr(zytysp1,n1+1); point=seekr(zysytp1,n1+1); point=seekr(zytm1ys,n1+1); point=seekr(zysm1yt,n1+1);


d = zeros(1,1);

do while i<=n;
	dh = x12m[i:i+ii-1,.] .* (readr(zyt,ii)*bp') - x12l[i:i+ii-1,.] .* (readr(zys,ii)*bp');
	dh = sumc(dh');
	dh = dh + readr(zytm1yt,ii)*GP + readr(zytytp1,ii)*GP + readr(zysm1ys,ii)*GP + readr(zysysp1,ii)*GP 
	      - readr(zytm1ys,ii)*GP - readr(zysytp1,ii)*GP - readr(zysm1yt,ii)*GP - readr(zytysp1,ii)*GP;
	d=d|dh;
        i = i+ii;
        if (i<=n and i+ii>n);
           ii = n-i+1;
        endif;
endo;

d=d[2:rows(d)];

if rows(d) ne n;
  print" error in d2";
  end;
endif;

point=seekr(zyt,1); point=seekr(zys,1); point=seekr(zytm1yt,1); point=seekr(zysm1ys,1); 
point=seekr(zytytp1,1); point=seekr(zysysp1,1);
point=seekr(zytysp1,1); point=seekr(zysytp1,1); point=seekr(zytm1ys,1); point=seekr(zysm1yt,1);

up = (exp(d));
down = 1 + exp(d);

retd2= up./down; 
retd2=sumc(kern[n1+1:n1+n2].*ln(retd2));

retp(retd2);
endp;


/*-------------------------------------------------------------------------------------------------*/
proc lgd(b,data);                             /* Gradient  **/
/*local xts, ytm1, yt, ytp1, ysm1, ys, ysp1, ;*/
local Gp, bp, n, i, ret, ytmp;

/* Aufteilung von  X   */
n = rows(xts);


/* Aufteilung von  b   */
Gp = b[1:(M-1)*(M-1)];

bp = zeros(nx,M);
i=1;
do while i<=nx;
   bp[i, 2:M] = b[((M-1)*(M-1)+(M-1)*(i-1)+1):((M-1)*(M-1)+i*(M-1))]';
   i=i+1;
endo;

ret = zeros(n,rows(b));

ret[1:n1,.]=kern[1:n1].*der1(xts[1:n1,.],Gp,bp); 

ret[n1+1:n1+n2,.]=kern[n1+1:n1+n2].*der2(xts[n1+1:n1+n2,.],Gp,bp);



retp (ret);
endp;

/*-------------------------------------------------------------------------------------------------*/
proc der1(x12,Gp,bp);
local n, d, ii,ij,dh, h1, i, j, retder1, zii,point;
local iyt,iys,iytm1yt,iytys,iysyt,iysysp1, iytm1ys, iytysp1, x12l, x12m;


n=rows(x12);

x12m=x12[.,1:nx];
x12l=x12[.,nx+1:2*nx];

i=1;
ii = 5000;

d = zeros(1,1);

do while i<=n;
	dh = x12m[i:i+ii-1,.] .* (readr(zyt,ii)*bp') - x12l[i:i+ii-1,.] .* (readr(zys,ii)*bp');
	dh = sumc(dh');
	dh = dh + readr(zytm1yt,ii)*GP + readr(zytys,ii)*GP + readr(zysysp1,ii)*GP 
	      - readr(zytm1ys,ii)*GP - readr(zysyt,ii)*GP - readr(zytysp1,ii)*GP;
	d=d|dh;
        i = i+ii;
        if (i<=n and i+ii>n);
           ii = n-i+1;
        endif;
endo;

d=d[2:rows(d)];

if rows(d) ne n;
  print" error in der1";
  end;
endif;

point=seekr(zyt,1); point=seekr(zys,1); point=seekr(zytm1yt,1); point=seekr(zytm1ys,1); 
point=seekr(zytys,1); point=seekr(zysyt,1);
point=seekr(zysysp1,1); point=seekr(zytysp1,1);

h1 = ones(n,1)./(ones(n,1)+exp(d));

retder1 = zeros(1,(M-1)*(M-1)+(M-1)*nx);

ij=1;
ii = 5000;

do while (ij<=n);

iyt= readr(zyt, ii);
iys= readr(zys, ii);
iytm1yt= readr(zytm1yt, ii);
iytm1ys= readr(zytm1ys, ii);
iytys= readr(zytys, ii);
iysyt= readr(zysyt, ii);
iysysp1= readr(zysysp1, ii);
iytysp1= readr(zytysp1, ii);
dh = zeros(ii,(M-1)*(M-1)+(M-1)*nx);

i =1;
do while i<=(M-1)*(M-1);
dh[.,i] = h1[ij:ij+ii-1] .* (iytm1yt[.,i]+iytys[.,i]+iysysp1[.,i]-iytm1ys[.,i]-iysyt[.,i]-iytysp1[.,i]);
i=i+1;
endo;

j=1;
zii=1;
do while j<=nx;
   i=(M-1)*(M-1)+1;
   do while i<=(M-1)*(M-1)+(M-1);
      dh[.,(M-1)*(M-1)+zii] = h1[ij:ij+ii-1] .* (x12m[ij:ij+ii-1,j] .* (iyt[.,i-(M-1)*(M-1)+1])
                                                -x12l[ij:ij+ii-1,j] .* (iys[.,i-(M-1)*(M-1)+1]));
   i=i+1;
   zii=zii+1;
   endo;
j=j+1;
endo;

retder1 = retder1|dh;

        ij = ij+ii;
        if (ij<=n and ij+ii>n);
           ii = n-ij+1;
        endif;
endo;

point=seekr(zyt,1); point=seekr(zys,1); point=seekr(zytm1yt,1); point=seekr(zytm1ys,1); 
point=seekr(zytys,1); point=seekr(zysyt,1);
point=seekr(zysysp1,1); point=seekr(zytysp1,1);

retder1=retder1[2:rows(retder1),.];

if rows(retder1) ne n;
  print" error in der1,2";
  end;
endif;

retp(retder1);
endp;

/*-------------------------------------------------------------------------------------------------*/

proc der2(x12,Gp,bp);
local i, j;
local n, d,ii,ij,dh, h1, retder2, zii, point;
local iyt,iys,iytm1yt,iytytp1,iysm1ys,iysysp1, iytm1ys, iysytp1,iysm1yt,iytysp1, x12l, x12m;

n=rows(x12);

x12m=x12[.,1:nx];
x12l=x12[.,nx+1:2*nx];

i=1;
ii = 800;

/* pointer richtig setzen  nach n1+1 */
point=seekr(zyt,n1+1); point=seekr(zys,n1+1); point=seekr(zytm1yt,n1+1); point=seekr(zysm1ys,n1+1); 
point=seekr(zytytp1,n1+1); point=seekr(zysysp1,n1+1);
point=seekr(zytysp1,n1+1); point=seekr(zysytp1,n1+1); point=seekr(zytm1ys,n1+1); point=seekr(zysm1yt,n1+1);


d = zeros(1,1);

do while i<=n;
	dh = x12m[i:i+ii-1,.] .* (readr(zyt,ii)*bp') - x12l[i:i+ii-1,.] .* (readr(zys,ii)*bp');
	dh = sumc(dh');
	dh = dh + readr(zytm1yt,ii)*GP + readr(zytytp1,ii)*GP + readr(zysm1ys,ii)*GP + readr(zysysp1,ii)*GP 
	      - readr(zytm1ys,ii)*GP - readr(zysytp1,ii)*GP - readr(zysm1yt,ii)*GP - readr(zytysp1,ii)*GP;
	d=d|dh;
        i = i+ii;
        if (i<=n and i+ii>n);
           ii = n-i+1;
        endif;
endo;

d=d[2:rows(d)];

if rows(d) ne n;
  print" error in der2";
  end;
endif;

point=seekr(zyt,n1+1); point=seekr(zys,n1+1); point=seekr(zytm1yt,n1+1); point=seekr(zysm1ys,n1+1);
point= seekr(zytytp1,n1+1); point= seekr(zysysp1,n1+1);
point=seekr(zytysp1,n1+1); point=seekr(zysytp1,n1+1); point=seekr(zytm1ys,n1+1); point=seekr(zysm1yt,n1+1);

h1 = ones(n,1)./(ones(n,1)+exp(d));


retder2 = zeros(1,(M-1)*(M-1)+(M-1)*nx);

ij=1;
ii = 800;

do while (ij<=n);

Iyt= readr(zyt, ii);
Iys= readr(zys, ii);
Iytm1yt= readr(zytm1yt, ii);
Iytm1ys= readr(zytm1ys, ii);
Iytytp1= readr(zytytp1, ii);
Iysytp1= readr(zysytp1, ii);
Iysysp1= readr(zysysp1, ii);
Iytysp1= readr(zytysp1, ii);
Iysm1ys= readr(zysm1ys, ii);
Iysm1yt= readr(zysm1yt, ii);

dh = zeros(ii,(M-1)*(M-1)+(M-1)*nx);
i =1;
do while i<=(M-1)*(M-1);
dh[.,i] = h1[ij:ij+ii-1] .* (iytm1yt[.,i]+iytytp1[.,i]+iysm1ys[.,i]+iysysp1[.,i]
                            -iytm1ys[.,i]-iysytp1[.,i]-iysm1yt[.,i]-iytysp1[.,i]);
i=i+1;
endo;
j=1;
zii=1;
do while j<=nx;
   i=(M-1)*(M-1)+1;
   do while i<=(M-1)*(M-1)+(M-1);
      dh[.,(M-1)*(M-1)+zii] = h1[ij:ij+ii-1] .* (x12m[ij:ij+ii-1,j] .* (iyt[.,i-(M-1)*(M-1)+1])
                                                -x12l[ij:ij+ii-1,j] .* (iys[.,i-(M-1)*(M-1)+1]));
   i=i+1;
   zii=zii+1;
   endo;
j=j+1;
endo;
retder2=retder2|dh;

        ij = ij+ii;
        if (ij<=n and ij+ii>n);
           ii = n-ij+1;
        endif;
endo;

retder2=retder2[2:rows(retder2),.];

if rows(retder2) ne n;
  print" error in der2,2";
  end;
endif;

point=seekr(zyt,1); point=seekr(zys,1); point=seekr(zytm1yt,1); point=seekr(zysm1ys,1); 
point=seekr(zytytp1,1); point=seekr(zysysp1,1);
point=seekr(zytysp1,1); point=seekr(zysytp1,1); point=seekr(zytm1ys,1); point=seekr(zysm1yt,1);




retp(retder2);
endp;


/*-------------------------------------------------------------------------------------------------*/


/**************************************************************************************************************

             OUTPUT 
*****************************************************************************************************************/

proc poutput(b,ccov);                            

local gama, betta, sdgamma, sdbeta,i, cov, waldt; 

cov=diag(ccov);

/**** delta (M-1)*(M-1)+(M-1)*nx  **********/

gama=b[1:(M-1)*(M-1)];
sdgamma = sqrt(cov[1:(M-1)*(M-1)]);

print "";
print "";
print "************ state dependence  *************";
format /rd 12,3;
i=1;
do while (i<=(M-1));
print "";
print gama[(M-1)*(i-1)+1:(M-1)*i]';
print sdgamma[(M-1)*(i-1)+1:(M-1)*i]';
i=i+1;
endo;

/****  explanatory variables  **********/

betta = b[(M-1)*(M-1)+1:(M-1)*(M-1)+(M-1)*nx];
sdbeta = sqrt(cov[(M-1)*(M-1)+1:(M-1)*(M-1)+(M-1)*nx]);

print "";
print "************ explanatory variables  *************";
format /rd 12,3;
i=1;
do while (i<=nx);
print "";
print betta[(M-1)*(i-1)+1:(M-1)*i]';
print sdbeta[(M-1)*(i-1)+1:(M-1)*i]';
i=i+1;
endo;
/*
print "";
print "************ wald test trade vars  *************";
waldt=betta[1:15]'*inv(ccov[(M-1)*(M-1)+1:(M-1)*(M-1)+(M-1)*3,(M-1)*(M-1)+1:(M-1)*(M-1)+(M-1)*3])*betta[1:15];
print "";
print "Test Statistik chi(15)  " waldt;
*/
retp(i);
endp;


/**********************************************************************************************
             CRX  
************************************************************************************************/

proc crx(bandw,ke,nx,mx);  

local zi, n, zo, n1, n2, i, z, y, x;
local xx1, xx2, xx3, xx4, xx5, xx6, xx7, xx8, xgdp, xa1, xa2, xa3, sx;
local t, s, ty, sy, h, num;
local zyt,zys, zytysm, zysyt, zytysp1, zytm1yt, zytm1ys, zysysp1, zytytp1, zysytp1, zysm1ys, zysm1yt;
local ytm1, yt, ytp1, ysm1, ys, ysp1, help, iyt, iys, help1, help2, ein, mm;


/* number of columns in the datamatrix: 3*13 y, 12*mx+ 12*(4)*8 x;  */

open zi= ^filein for read;
n = rowsf(zi);
create zo = ^fileout with var,2*nx+6+ke,4;

mm=M-1;

/*** Decompositions  ****/
/*******************************************************  erste Schleife  *******************************************/

n1=0;
i=1;
do while i<=n;

   z=readr(zi,1);
   if ya==0;
    y=z[1:periods+1];
   elseif ya==1;
    y=z[periods+2:2*(periods+1)];
   else ;
     y=z[2*(periods+1)+1:3*(periods+1)];
   endif;
   x=z[3*periods+4:3*(periods+1)+(mx+1+8*(mm-1))*periods];

   xx1=reshape(x[1:mm*periods],mm,periods);			/* rm1 ... rm5 */
   xx1=zeros(1,cols(xx1))|xx1;					/* rm0 rm1 ... rm5 */	
   xx2=reshape(x[mm*periods+1:2*mm*periods],mm,periods);		/* rx1 ... rx5 */
   xx2=zeros(1,cols(xx2))|xx2;
   
   xx3=reshape(x[2*mm*periods+1:3*mm*periods],mm,periods);		/* ter1 ... ter5 */
   xx3=zeros(1,cols(xx3))|xx3;
   xx4=reshape(x[3*mm*periods+1:4*mm*periods],mm,periods);		/* ier1 ... ier5 */
   xx4=zeros(1,cols(xx4))|xx4;
   xx5=reshape(x[4*mm*periods+1:5*mm*periods],mm,periods);		/* xer1 ... xer5 */
   xx5=zeros(1,cols(xx5))|xx5;
   xx3=xx3;
      
   xx6=reshape(x[5*mm*periods+1:6*mm*periods],mm,periods);		/* outsc1 ... outsc5 */
   xx6=zeros(1,cols(xx6))|xx6; 

   xx7=reshape(x[6*mm*periods+1:7*mm*periods],mm,periods);		/* varb1 ... varb5 */
   xx7=zeros(1,cols(xx7))|xx7; 

   xx8=reshape(x[7*mm*periods+1:8*mm*periods],mm,periods);		/* yst1 ... yst5 */
   xx8=zeros(1,cols(xx8))|xx8; 


   xgdp=x[8*mm*periods+1:(8*mm+1)*periods];
   
   xa1=x[(8*mm+1)*periods+1:(8*mm+2)*periods];
   xa2=x[(8*mm+2)*periods+1:(8*mm+3)*periods];
   xa3=x[(8*mm+3)*periods+1:(8*mm+4)*periods];
   sx=z[3*(periods+1)+(mx+8*(mm-1))*periods+1:cols(z)];
   t=1;
   do while t<=periods-2;
      s=t+1;
         ty=t+1;
         sy=s+1;
         if ((y[ty] ne y[sy]) and (xa1[t+1]~xa2[t+1]~xa3[t+1] eq         /*   nx    */
                                   xa1[s+1]~xa2[s+1]~xa3[s+1])
                                   and((1-(1/bandw*(xx3[.,t+1]-xx3[.,s+1])).^2)>0) 
                                   and((1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2)>0)
                                   and (sx[t] eq 0));                    /* corrects for school  */
            n1 = n1 + 1;
            h=(prodc(1-(1/bandw*(xx3[.,t+1]-xx3[.,s+1])).^2)*prodc(1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)
                                                        *prodc(1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2))
              ~(xx3[y[ty]+1,t]-xx3[y[ty]+1,s])~(xx6[y[ty]+1,t]-xx6[y[ty]+1,s])~(xx7[y[ty]+1,t]-xx7[y[ty]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~(xx3[y[sy]+1,t]-xx3[y[sy]+1,s])~(xx6[y[sy]+1,t]-xx6[y[sy]+1,s])~(xx7[y[sy]+1,t]-xx7[y[sy]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~y[ty-1]~y[ty]~y[ty+1]~y[sy-1]~y[sy]~y[sy+1];                          /*   nx    */
            call writer(zo,h);
         endif;
   t=t+1;
   endo;
i=i+1;
endo;

/****************************************************  zweite Schleife  **********************************************/

num=seekr(zi,1);

n2 = 0;
i=1;
do while i<=n;
   z=readr(zi,1);
   if ya==0;
    y=z[1:periods+1];
   elseif ya==1;
    y=z[periods+2:2*(periods+1)];
   else ;
     y=z[2*(periods+1)+1:3*(periods+1)];
   endif;
   x=z[3*periods+4:3*(periods+1)+(mx+1+8*(mm-1))*periods];
   xx1=reshape(x[1:mm*periods],mm,periods);			/* rm1 ... rm5 */
   xx1=zeros(1,cols(xx1))|xx1;					/* rm0 rm1 ... rm5 */	
   xx2=reshape(x[mm*periods+1:2*mm*periods],mm,periods);		/* rx1 ... rx5 */
   xx2=zeros(1,cols(xx2))|xx2;
   
   xx3=reshape(x[2*mm*periods+1:3*mm*periods],mm,periods);		/* ter1 ... ter5 */
   xx3=zeros(1,cols(xx3))|xx3;
   xx4=reshape(x[3*mm*periods+1:4*mm*periods],mm,periods);		/* ier1 ... ier5 */
   xx4=zeros(1,cols(xx4))|xx4;
   xx5=reshape(x[4*mm*periods+1:5*mm*periods],mm,periods);		/* xer1 ... xer5 */
   xx5=zeros(1,cols(xx5))|xx5; 
   xx3=xx3;
   
   xx6=reshape(x[5*mm*periods+1:6*mm*periods],mm,periods);		/* outsc1 ... outsc5 */
   xx6=zeros(1,cols(xx6))|xx6; 

   xx7=reshape(x[6*mm*periods+1:7*mm*periods],mm,periods);		/* varb1 ... varb5 */
   xx7=zeros(1,cols(xx7))|xx7; 

   xx8=reshape(x[7*mm*periods+1:8*mm*periods],mm,periods);		/* yst1 ... yst5 */
   xx8=zeros(1,cols(xx8))|xx8; 


   xgdp=x[8*mm*periods+1:(8*mm+1)*periods];
   
   xa1=x[(8*mm+1)*periods+1:(8*mm+2)*periods];
   xa2=x[(8*mm+2)*periods+1:(8*mm+3)*periods];
   xa3=x[(8*mm+3)*periods+1:(8*mm+4)*periods];
   sx=z[3*(periods+1)+(mx+8*(mm-1))*periods+1:cols(z)];
   t=1;
   do while t<=periods-2;
      s=t+2;
      do while s<=periods-1;
         ty=t+1;
         sy=s+1;
         if ((y[ty] ne y[sy]) and (xa1[t+1]~xa2[t+1]~xa3[t+1] eq         /*   nx    */
                                   xa1[s+1]~xa2[s+1]~xa3[s+1])
                                   and((1-(1/bandw*(xx3[.,t+1]-xx3[.,s+1])).^2)>0) 
                                   and((1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2)>0)
                                   and (sx[t] eq 0));                                                 /* corrects for school  */
            n2 = n2 + 1;
            h=(prodc(1-(1/bandw*(xx3[.,t+1]-xx3[.,s+1])).^2)*prodc(1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)
                                                        *prodc(1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2))
              ~(xx3[y[ty]+1,t]-xx3[y[ty]+1,s])~(xx6[y[ty]+1,t]-xx6[y[ty]+1,s])~(xx7[y[ty]+1,t]-xx7[y[ty]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~(xx3[y[sy]+1,t]-xx3[y[sy]+1,s])~(xx6[y[sy]+1,t]-xx6[y[sy]+1,s])~(xx7[y[sy]+1,t]-xx7[y[sy]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~y[ty-1]~y[ty]~y[ty+1]~y[sy-1]~y[sy]~y[sy+1];                                     /*   nx    */
            call writer(zo,h);
         endif;
      s=s+1;
      endo;
   t=t+1;
   endo;
i=i+1;
endo;

closeall zi, zo;


print" number of observations " n;
print " number of entries in the first sum of the likelihood function ";
print" n1  "  n1;
n=n1+n2;
print " total number of entries in the likelihood function ";
print" rows of x" n;

/*  Indikatormatrizen erzeugen  */

open zi= ^fileout for read;

create zyt = ^fileyt with var,6,2;
create zys = ^fileys with var,6,2;

create zytys = ^fileytys with var,25,2;
create zysyt = ^fileysyt with var,25,2;

create zytysp1 = ^fileytysp1 with var,25,2;
create zytm1yt = ^fileytm1yt with var,25,2;
create zytm1ys = ^fileytm1ys with var,25,2;
create zysysp1 = ^fileysysp1 with var,25,2;

create zytytp1 = ^fileytytp1 with var,25,2;
create zysytp1 = ^fileysytp1 with var,25,2;
create zysm1ys = ^fileysm1ys with var,25,2;
create zysm1yt = ^fileysm1yt with var,25,2;

i=1;
do while i<=rowsf(zi);
   z=readr(zi,1);
   y = z[2*nx+ke+1:colsf(zi)];
   ytm1 = y[1]+1;
   yt = y[2]+1;      
   ytp1 = y[3]+1;
   ysm1 = y[4]+1;
   ys = y[5]+1;
   ysp1 = y[6]+1;
   
   let help = {1 2 3 4 5 6};
   iyt = (yt*ones(1,6) .eq help);
   iys = (ys*ones(1,6) .eq help);
   
   call writer(zyt,iyt);
   call writer(zys,iys);
   
   help1 = ones(1,6)~2*ones(1,6)~3*ones(1,6)~4*ones(1,6)~5*ones(1,6)~6*ones(1,6);
   help2 = help~help~help~help~help~help;
   /*  ytys  */
   ein = (yt*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytys,ein);
   /*  ysyt  */
   ein = (ys*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysyt,ein);
   /*  ytm1yt */
   ein = (ytm1*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytm1yt,ein);
   /* ytm1ys */
   ein = (ytm1*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytm1ys,ein);
   /* ysysp1 */ 
   ein = (ys*ones(1,36) .eq help1) .and (ysp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysysp1,ein);
   /*  ytysp1 */
   ein = (yt*ones(1,36) .eq help1) .and (ysp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytysp1,ein);
   /* ytytp1  */
   ein = (yt*ones(1,36) .eq help1) .and (ytp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytytp1,ein);
   /* ysytp1  */
   ein = (ys*ones(1,36) .eq help1) .and (ytp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysytp1,ein);
   /* ysm1ys  */
   ein = (ysm1*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysm1ys,ein);
   /* ysm1yt  */
   ein = (ysm1*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysm1yt,ein);

i=i+1;
endo;

closeall zi, zyt, zys, zytys, zysyt, zytm1yt, zytm1ys, zysysp1, zytysp1, zytytp1, zysytp1, zysm1yt, zysm1ys;


retp(n1);
endp;


/**********************************************************************************************
             CRX  
************************************************************************************************/

proc crxa(bandw,ke,nx,mx);  

local zi, n, zo, n1, n2, i, z, y, x;
local xx1, xx2, xx3, xx4, xx5, xx6, xx7, xx8, xgdp, xa1, xa2, xa3, sx;
local t, s, ty, sy, h, num;
local zyt,zys, zytysm, zysyt, zytysp1, zytm1yt, zytm1ys, zysysp1, zytytp1, zysytp1, zysm1ys, zysm1yt;
local ytm1, yt, ytp1, ysm1, ys, ysp1, help, iyt, iys, help1, help2, ein, mm;

/* number of columns in the datamatrix: 3*13 y, 12*mx+ 12*(4)*8 x;   */

open zi= ^filein for read;
n = rowsf(zi);
create zo = ^fileout with var,2*nx+6+ke,4;
mm=M-1;
print" mm" mm;

/*** Decompositions  ****/
/*******************************************************  erste Schleife  *******************************************/

n1=0;
i=1;
do while i<=n;

   z=readr(zi,1);
   if ya==0;
    y=z[1:periods+1];
   elseif ya==1;
    y=z[periods+2:2*(periods+1)];
   else ;
     y=z[2*(periods+1)+1:3*(periods+1)];
   endif;
   x=z[3*periods+4:3*(periods+1)+(mx+1+8*(mm-1))*periods];


   xx1=reshape(x[1:mm*periods],mm,periods);			/* rm1 ... rm5 */
   xx1=zeros(1,cols(xx1))|xx1;					/* rm0 rm1 ... rm5 */	
   xx2=reshape(x[mm*periods+1:2*mm*periods],mm,periods);		/* rx1 ... rx5 */
   xx2=zeros(1,cols(xx2))|xx2;
   
   xx3=reshape(x[2*mm*periods+1:3*mm*periods],mm,periods);		/* ter1 ... ter5 */
   xx3=zeros(1,cols(xx3))|xx3;
   xx4=reshape(x[3*mm*periods+1:4*mm*periods],mm,periods);		/* ier1 ... ier5 */
   xx4=zeros(1,cols(xx4))|xx4;
   xx5=reshape(x[4*mm*periods+1:5*mm*periods],mm,periods);		/* xer1 ... xer5 */
   xx5=zeros(1,cols(xx5))|xx5; 
   xx3=xx3;
      
   xx6=reshape(x[5*mm*periods+1:6*mm*periods],mm,periods);		/* outsc1 ... outsc5 */
   xx6=zeros(1,cols(xx6))|xx6; 

   xx7=reshape(x[6*mm*periods+1:7*mm*periods],mm,periods);		/* varb1 ... varb5 */
   xx7=zeros(1,cols(xx7))|xx7; 

   xx8=reshape(x[7*mm*periods+1:8*mm*periods],mm,periods);		/* yst1 ... yst5 */
   xx8=zeros(1,cols(xx8))|xx8; 


   xgdp=x[8*mm*periods+1:(8*mm+1)*periods];
   
   xa1=x[(8*mm+1)*periods+1:(8*mm+2)*periods];
   xa2=x[(8*mm+2)*periods+1:(8*mm+3)*periods];
   xa3=x[(8*mm+3)*periods+1:(8*mm+4)*periods];
   sx=z[3*(periods+1)+(mx+8*(mm-1))*periods+1:cols(z)];
   t=1;
   do while t<=periods-2;
      s=t+1;
         ty=t+1;
         sy=s+1;
         if ((y[ty] ne y[sy]) and (xa1[t+1]~xa2[t+1]~xa3[t+1] eq         /*   nx    */
                                   xa1[s+1]~xa2[s+1]~xa3[s+1])
                                   and((1-(1/bandw*(xx1[.,t+1]-xx1[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx2[.,t+1]-xx2[.,s+1])).^2)>0) 
                                   and((1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2)>0)
                                   and (sx[t] eq 0));                    /* corrects for school  */
            n1 = n1 + 1;
            h=(prodc(1-(1/bandw*(xx1[.,t+1]-xx1[.,s+1])).^2)*
               prodc(1-(1/bandw*(xx2[.,t+1]-xx2[.,s+1])).^2)*prodc(1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)
                                                        *prodc(1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2))
              ~(xx1[y[ty]+1,t]-xx1[y[ty]+1,s])~(xx2[y[ty]+1,t]-xx2[y[ty]+1,s])~(xx6[y[ty]+1,t]-xx6[y[ty]+1,s])~(xx7[y[ty]+1,t]-xx7[y[ty]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~(xx1[y[sy]+1,t]-xx1[y[sy]+1,s])~(xx2[y[sy]+1,t]-xx2[y[sy]+1,s])~(xx6[y[sy]+1,t]-xx6[y[sy]+1,s])~(xx7[y[sy]+1,t]-xx7[y[sy]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~y[ty-1]~y[ty]~y[ty+1]~y[sy-1]~y[sy]~y[sy+1];                          /*   nx    */
            call writer(zo,h);
         endif;
   t=t+1;
   endo;
i=i+1;
endo;

/****************************************************  zweite Schleife  **********************************************/

num=seekr(zi,1);

n2 = 0;
i=1;
do while i<=n;
   
   z=readr(zi,1);
   if ya==0;
    y=z[1:periods+1];
   elseif ya==1;
    y=z[periods+2:2*(periods+1)];
   else ;
     y=z[2*(periods+1)+1:3*(periods+1)];
   endif;
   x=z[3*periods+4:3*(periods+1)+(mx+1+8*(mm-1))*periods];
   xx1=reshape(x[1:mm*periods],mm,periods);			/* rm1 ... rm5 */
   xx1=zeros(1,cols(xx1))|xx1;					/* rm0 rm1 ... rm5 */	
   xx2=reshape(x[mm*periods+1:2*mm*periods],mm,periods);		/* rx1 ... rx5 */
   xx2=zeros(1,cols(xx2))|xx2;
   
   xx3=reshape(x[2*mm*periods+1:3*mm*periods],mm,periods);		/* ter1 ... ter5 */
   xx3=zeros(1,cols(xx3))|xx3;
   xx4=reshape(x[3*mm*periods+1:4*mm*periods],mm,periods);		/* ier1 ... ier5 */
   xx4=zeros(1,cols(xx4))|xx4;
   xx5=reshape(x[4*mm*periods+1:5*mm*periods],mm,periods);		/* xer1 ... xer5 */
   xx5=zeros(1,cols(xx5))|xx5;
   xx3=xx3;
      
   xx6=reshape(x[5*mm*periods+1:6*mm*periods],mm,periods);		/* outsc1 ... outsc5 */
   xx6=zeros(1,cols(xx6))|xx6; 

   xx7=reshape(x[6*mm*periods+1:7*mm*periods],mm,periods);		/* varb1 ... varb5 */
   xx7=zeros(1,cols(xx7))|xx7; 

   xx8=reshape(x[7*mm*periods+1:8*mm*periods],mm,periods);		/* yst1 ... yst5 */
   xx8=zeros(1,cols(xx8))|xx8; 


   xgdp=x[8*mm*periods+1:(8*mm+1)*periods];
   
   xa1=x[(8*mm+1)*periods+1:(8*mm+2)*periods];
   xa2=x[(8*mm+2)*periods+1:(8*mm+3)*periods];
   xa3=x[(8*mm+3)*periods+1:(8*mm+4)*periods];
   sx=z[3*(periods+1)+(mx+8*(mm-1))*periods+1:cols(z)];
   t=1;
   do while t<=periods-2;
      s=t+2;
      do while s<=periods-1;
         ty=t+1;
         sy=s+1;
         if ((y[ty] ne y[sy]) and (xa1[t+1]~xa2[t+1]~xa3[t+1] eq         /*   nx    */
                                   xa1[s+1]~xa2[s+1]~xa3[s+1])
                                   and((1-(1/bandw*(xx1[.,t+1]-xx1[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx2[.,t+1]-xx2[.,s+1])).^2)>0) 
                                   and((1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)>0)
                                   and((1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2)>0)
                                   and (sx[t] eq 0));                                                 /* corrects for school  */
            n2 = n2 + 1;
            h=(prodc(1-(1/bandw*(xx1[.,t+1]-xx1[.,s+1])).^2)*
               prodc(1-(1/bandw*(xx2[.,t+1]-xx2[.,s+1])).^2)*prodc(1-(1/bandw*(xx6[.,t+1]-xx6[.,s+1])).^2)
                                                        *prodc(1-(1/bandw*(xx7[.,t+1]-xx7[.,s+1])).^2))
              ~(xx1[y[ty]+1,t]-xx1[y[ty]+1,s])~(xx2[y[ty]+1,t]-xx2[y[ty]+1,s])~(xx6[y[ty]+1,t]-xx6[y[ty]+1,s])~(xx7[y[ty]+1,t]-xx7[y[ty]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~(xx1[y[sy]+1,t]-xx1[y[sy]+1,s])~(xx2[y[sy]+1,t]-xx2[y[sy]+1,s])~(xx6[y[sy]+1,t]-xx6[y[sy]+1,s])~(xx7[y[sy]+1,t]-xx7[y[sy]+1,s])
              ~(xa1[t]-xa1[s])~(xa2[t]-xa2[s])~(xa3[t]-xa3[s])
              ~y[ty-1]~y[ty]~y[ty+1]~y[sy-1]~y[sy]~y[sy+1];                                     /*   nx    */
            call writer(zo,h);
         endif;
      s=s+1;
      endo;
   t=t+1;
   endo;
i=i+1;
endo;

closeall zi, zo;

print" number of observations " n;
print " number of entries in the first sum of the likelihood function ";
print" n1  "  n1;
n=n1+n2;
print " total number of entries in the likelihood function ";
print" rows of x" n;

/*  Indikatormatrizen erzeugen  */

open zi= ^fileout for read;

create zyt = ^fileyt with var,6,2;
create zys = ^fileys with var,6,2;

create zytys = ^fileytys with var,25,2;
create zysyt = ^fileysyt with var,25,2;

create zytysp1 = ^fileytysp1 with var,25,2;
create zytm1yt = ^fileytm1yt with var,25,2;
create zytm1ys = ^fileytm1ys with var,25,2;
create zysysp1 = ^fileysysp1 with var,25,2;

create zytytp1 = ^fileytytp1 with var,25,2;
create zysytp1 = ^fileysytp1 with var,25,2;
create zysm1ys = ^fileysm1ys with var,25,2;
create zysm1yt = ^fileysm1yt with var,25,2;

i=1;
do while i<=rowsf(zi);
   z=readr(zi,1);
   y = z[2*nx+ke+1:colsf(zi)];
   ytm1 = y[1]+1;
   yt = y[2]+1;      
   ytp1 = y[3]+1;
   ysm1 = y[4]+1;
   ys = y[5]+1;
   ysp1 = y[6]+1;
   
   let help = {1 2 3 4 5 6};
   iyt = (yt*ones(1,6) .eq help);
   iys = (ys*ones(1,6) .eq help);
   
   call writer(zyt,iyt);
   call writer(zys,iys);
   
   help1 = ones(1,6)~2*ones(1,6)~3*ones(1,6)~4*ones(1,6)~5*ones(1,6)~6*ones(1,6);
   help2 = help~help~help~help~help~help;
   /*  ytys  */
   ein = (yt*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytys,ein);
   /*  ysyt  */
   ein = (ys*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysyt,ein);
   /*  ytm1yt */
   ein = (ytm1*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytm1yt,ein);
   /* ytm1ys */
   ein = (ytm1*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytm1ys,ein);
   /* ysysp1 */ 
   ein = (ys*ones(1,36) .eq help1) .and (ysp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysysp1,ein);
   /*  ytysp1 */
   ein = (yt*ones(1,36) .eq help1) .and (ysp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytysp1,ein);
   /* ytytp1  */
   ein = (yt*ones(1,36) .eq help1) .and (ytp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zytytp1,ein);
   /* ysytp1  */
   ein = (ys*ones(1,36) .eq help1) .and (ytp1*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysytp1,ein);
   /* ysm1ys  */
   ein = (ysm1*ones(1,36) .eq help1) .and (ys*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysm1ys,ein);
   /* ysm1yt  */
   ein = (ysm1*ones(1,36) .eq help1) .and (yt*ones(1,36) .eq help2);
   ein = ein[8:12]~ein[14:18]~ein[20:24]~ein[26:30]~ein[32:36];
   call writer(zysm1yt,ein);

i=i+1;
endo;

closeall zi, zyt, zys, zytys, zysyt, zytm1yt, zytm1ys, zysysp1, zytysp1, zytytp1, zysytp1, zysm1yt, zysm1ys;


retp(n1);
endp;